<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		script.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
JHTML::_('behavior.modal');

/**
 * Script File of Moojla Component
 */
class com_moojlaInstallerScript
{
	/**
	 * Constructor
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 */
	public function __construct(JAdapterInstance $parent) {}

	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install(JAdapterInstance $parent) {}

	/**
	 * Called on uninstallation
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 */
	public function uninstall(JAdapterInstance $parent)
	{
		// Get Application object
		$app = JFactory::getApplication();

		// Get The Database object
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select ids from fields
		$query->select($db->quoteName('id'));
		$query->from($db->quoteName('#__fields'));
		// Where course context is found
		$query->where( $db->quoteName('context') . ' = '. $db->quote('com_moojla.course') );
		$db->setQuery($query);
		// Execute query to see if context is found
		$db->execute();
		$course_found = $db->getNumRows();
		// Now check if there were any rows
		if ($course_found)
		{
			// Since there are load the needed  course field ids
			$course_field_ids = $db->loadColumn();
			// Remove course from the field table
			$course_condition = array( $db->quoteName('context') . ' = '. $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__fields'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully remove course add queued success message.
				$app->enqueueMessage(JText::_('The fields with type (com_moojla.course) context was removed from the <b>#__fields</b> table'));
			}
			// Also Remove course field values
			$course_condition = array( $db->quoteName('field_id') . ' IN ('. implode(',', $course_field_ids) .')');
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__fields_values'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove course field values
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully remove course add queued success message.
				$app->enqueueMessage(JText::_('The fields values for course was removed from the <b>#__fields_values</b> table'));
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select ids from field groups
		$query->select($db->quoteName('id'));
		$query->from($db->quoteName('#__fields_groups'));
		// Where course context is found
		$query->where( $db->quoteName('context') . ' = '. $db->quote('com_moojla.course') );
		$db->setQuery($query);
		// Execute query to see if context is found
		$db->execute();
		$course_found = $db->getNumRows();
		// Now check if there were any rows
		if ($course_found)
		{
			// Remove course from the field groups table
			$course_condition = array( $db->quoteName('context') . ' = '. $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__fields_groups'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully remove course add queued success message.
				$app->enqueueMessage(JText::_('The field groups with type (com_moojla.course) context was removed from the <b>#__fields_groups</b> table'));
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where course alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$course_found = $db->getNumRows();
		// Now check if there were any rows
		if ($course_found)
		{
			// Since there are load the needed  course type ids
			$course_ids = $db->loadColumn();
			// Remove course from the content type table
			$course_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully remove course add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove course items from the contentitem tag map table
			$course_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully remove course add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove course items from the ucm content table
			$course_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully removed course add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the course items are cleared from DB
			foreach ($course_ids as $course_id)
			{
				// Remove course items from the ucm base table
				$course_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($course_condition);
				$db->setQuery($query);
				// Execute the query to remove course items
				$db->execute();

				// Remove course items from the ucm history table
				$course_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($course_condition);
				$db->setQuery($query);
				// Execute the query to remove course items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Course alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$course_found = $db->getNumRows();
		// Now check if there were any rows
		if ($course_found)
		{
			// Since there are load the needed  course type ids
			$course_ids = $db->loadColumn();
			// Remove Course from the content type table
			$course_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove Course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully remove Course add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Course items from the contentitem tag map table
			$course_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove Course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully remove Course add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Course items from the ucm content table
			$course_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.course') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($course_condition);
			$db->setQuery($query);
			// Execute the query to remove Course items
			$course_done = $db->execute();
			if ($course_done)
			{
				// If successfully removed Course add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Course items are cleared from DB
			foreach ($course_ids as $course_id)
			{
				// Remove Course items from the ucm base table
				$course_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($course_condition);
				$db->setQuery($query);
				// Execute the query to remove Course items
				$db->execute();

				// Remove Course items from the ucm history table
				$course_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($course_condition);
				$db->setQuery($query);
				// Execute the query to remove Course items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Course catid alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course.category') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$course_catid_found = $db->getNumRows();
		// Now check if there were any rows
		if ($course_catid_found)
		{
			// Since there are load the needed  course_catid type ids
			$course_catid_ids = $db->loadColumn();
			// Remove Course catid from the content type table
			$course_catid_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($course_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Course catid items
			$course_catid_done = $db->execute();
			if ($course_catid_done)
			{
				// If successfully remove Course catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course.category) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Course catid items from the contentitem tag map table
			$course_catid_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($course_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Course catid items
			$course_catid_done = $db->execute();
			if ($course_catid_done)
			{
				// If successfully remove Course catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course.category) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Course catid items from the ucm content table
			$course_catid_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.course.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($course_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Course catid items
			$course_catid_done = $db->execute();
			if ($course_catid_done)
			{
				// If successfully removed Course catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course.category) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Course catid items are cleared from DB
			foreach ($course_catid_ids as $course_catid_id)
			{
				// Remove Course catid items from the ucm base table
				$course_catid_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_catid_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($course_catid_condition);
				$db->setQuery($query);
				// Execute the query to remove Course catid items
				$db->execute();

				// Remove Course catid items from the ucm history table
				$course_catid_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_catid_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($course_catid_condition);
				$db->setQuery($query);
				// Execute the query to remove Course catid items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Course_field_mapper alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course_field_mapper') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$course_field_mapper_found = $db->getNumRows();
		// Now check if there were any rows
		if ($course_field_mapper_found)
		{
			// Since there are load the needed  course_field_mapper type ids
			$course_field_mapper_ids = $db->loadColumn();
			// Remove Course_field_mapper from the content type table
			$course_field_mapper_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course_field_mapper') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($course_field_mapper_condition);
			$db->setQuery($query);
			// Execute the query to remove Course_field_mapper items
			$course_field_mapper_done = $db->execute();
			if ($course_field_mapper_done)
			{
				// If successfully remove Course_field_mapper add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course_field_mapper) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Course_field_mapper items from the contentitem tag map table
			$course_field_mapper_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course_field_mapper') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($course_field_mapper_condition);
			$db->setQuery($query);
			// Execute the query to remove Course_field_mapper items
			$course_field_mapper_done = $db->execute();
			if ($course_field_mapper_done)
			{
				// If successfully remove Course_field_mapper add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course_field_mapper) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Course_field_mapper items from the ucm content table
			$course_field_mapper_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.course_field_mapper') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($course_field_mapper_condition);
			$db->setQuery($query);
			// Execute the query to remove Course_field_mapper items
			$course_field_mapper_done = $db->execute();
			if ($course_field_mapper_done)
			{
				// If successfully removed Course_field_mapper add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course_field_mapper) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Course_field_mapper items are cleared from DB
			foreach ($course_field_mapper_ids as $course_field_mapper_id)
			{
				// Remove Course_field_mapper items from the ucm base table
				$course_field_mapper_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_field_mapper_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($course_field_mapper_condition);
				$db->setQuery($query);
				// Execute the query to remove Course_field_mapper items
				$db->execute();

				// Remove Course_field_mapper items from the ucm history table
				$course_field_mapper_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_field_mapper_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($course_field_mapper_condition);
				$db->setQuery($query);
				// Execute the query to remove Course_field_mapper items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where User_map alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.user_map') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$user_map_found = $db->getNumRows();
		// Now check if there were any rows
		if ($user_map_found)
		{
			// Since there are load the needed  user_map type ids
			$user_map_ids = $db->loadColumn();
			// Remove User_map from the content type table
			$user_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.user_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($user_map_condition);
			$db->setQuery($query);
			// Execute the query to remove User_map items
			$user_map_done = $db->execute();
			if ($user_map_done)
			{
				// If successfully remove User_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.user_map) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove User_map items from the contentitem tag map table
			$user_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.user_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($user_map_condition);
			$db->setQuery($query);
			// Execute the query to remove User_map items
			$user_map_done = $db->execute();
			if ($user_map_done)
			{
				// If successfully remove User_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.user_map) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove User_map items from the ucm content table
			$user_map_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.user_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($user_map_condition);
			$db->setQuery($query);
			// Execute the query to remove User_map items
			$user_map_done = $db->execute();
			if ($user_map_done)
			{
				// If successfully removed User_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.user_map) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the User_map items are cleared from DB
			foreach ($user_map_ids as $user_map_id)
			{
				// Remove User_map items from the ucm base table
				$user_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $user_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($user_map_condition);
				$db->setQuery($query);
				// Execute the query to remove User_map items
				$db->execute();

				// Remove User_map items from the ucm history table
				$user_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $user_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($user_map_condition);
				$db->setQuery($query);
				// Execute the query to remove User_map items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where User_field_map alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.user_field_map') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$user_field_map_found = $db->getNumRows();
		// Now check if there were any rows
		if ($user_field_map_found)
		{
			// Since there are load the needed  user_field_map type ids
			$user_field_map_ids = $db->loadColumn();
			// Remove User_field_map from the content type table
			$user_field_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.user_field_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($user_field_map_condition);
			$db->setQuery($query);
			// Execute the query to remove User_field_map items
			$user_field_map_done = $db->execute();
			if ($user_field_map_done)
			{
				// If successfully remove User_field_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.user_field_map) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove User_field_map items from the contentitem tag map table
			$user_field_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.user_field_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($user_field_map_condition);
			$db->setQuery($query);
			// Execute the query to remove User_field_map items
			$user_field_map_done = $db->execute();
			if ($user_field_map_done)
			{
				// If successfully remove User_field_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.user_field_map) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove User_field_map items from the ucm content table
			$user_field_map_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.user_field_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($user_field_map_condition);
			$db->setQuery($query);
			// Execute the query to remove User_field_map items
			$user_field_map_done = $db->execute();
			if ($user_field_map_done)
			{
				// If successfully removed User_field_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.user_field_map) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the User_field_map items are cleared from DB
			foreach ($user_field_map_ids as $user_field_map_id)
			{
				// Remove User_field_map items from the ucm base table
				$user_field_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $user_field_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($user_field_map_condition);
				$db->setQuery($query);
				// Execute the query to remove User_field_map items
				$db->execute();

				// Remove User_field_map items from the ucm history table
				$user_field_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $user_field_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($user_field_map_condition);
				$db->setQuery($query);
				// Execute the query to remove User_field_map items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Course_group_map alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course_group_map') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$course_group_map_found = $db->getNumRows();
		// Now check if there were any rows
		if ($course_group_map_found)
		{
			// Since there are load the needed  course_group_map type ids
			$course_group_map_ids = $db->loadColumn();
			// Remove Course_group_map from the content type table
			$course_group_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course_group_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($course_group_map_condition);
			$db->setQuery($query);
			// Execute the query to remove Course_group_map items
			$course_group_map_done = $db->execute();
			if ($course_group_map_done)
			{
				// If successfully remove Course_group_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course_group_map) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Course_group_map items from the contentitem tag map table
			$course_group_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.course_group_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($course_group_map_condition);
			$db->setQuery($query);
			// Execute the query to remove Course_group_map items
			$course_group_map_done = $db->execute();
			if ($course_group_map_done)
			{
				// If successfully remove Course_group_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course_group_map) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Course_group_map items from the ucm content table
			$course_group_map_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.course_group_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($course_group_map_condition);
			$db->setQuery($query);
			// Execute the query to remove Course_group_map items
			$course_group_map_done = $db->execute();
			if ($course_group_map_done)
			{
				// If successfully removed Course_group_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.course_group_map) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Course_group_map items are cleared from DB
			foreach ($course_group_map_ids as $course_group_map_id)
			{
				// Remove Course_group_map items from the ucm base table
				$course_group_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_group_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($course_group_map_condition);
				$db->setQuery($query);
				// Execute the query to remove Course_group_map items
				$db->execute();

				// Remove Course_group_map items from the ucm history table
				$course_group_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $course_group_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($course_group_map_condition);
				$db->setQuery($query);
				// Execute the query to remove Course_group_map items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Enrolment alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.enrolment') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$enrolment_found = $db->getNumRows();
		// Now check if there were any rows
		if ($enrolment_found)
		{
			// Since there are load the needed  enrolment type ids
			$enrolment_ids = $db->loadColumn();
			// Remove Enrolment from the content type table
			$enrolment_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.enrolment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($enrolment_condition);
			$db->setQuery($query);
			// Execute the query to remove Enrolment items
			$enrolment_done = $db->execute();
			if ($enrolment_done)
			{
				// If successfully remove Enrolment add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.enrolment) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Enrolment items from the contentitem tag map table
			$enrolment_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.enrolment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($enrolment_condition);
			$db->setQuery($query);
			// Execute the query to remove Enrolment items
			$enrolment_done = $db->execute();
			if ($enrolment_done)
			{
				// If successfully remove Enrolment add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.enrolment) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Enrolment items from the ucm content table
			$enrolment_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.enrolment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($enrolment_condition);
			$db->setQuery($query);
			// Execute the query to remove Enrolment items
			$enrolment_done = $db->execute();
			if ($enrolment_done)
			{
				// If successfully removed Enrolment add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.enrolment) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Enrolment items are cleared from DB
			foreach ($enrolment_ids as $enrolment_id)
			{
				// Remove Enrolment items from the ucm base table
				$enrolment_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $enrolment_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($enrolment_condition);
				$db->setQuery($query);
				// Execute the query to remove Enrolment items
				$db->execute();

				// Remove Enrolment items from the ucm history table
				$enrolment_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $enrolment_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($enrolment_condition);
				$db->setQuery($query);
				// Execute the query to remove Enrolment items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Tag alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.tag') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$tag_found = $db->getNumRows();
		// Now check if there were any rows
		if ($tag_found)
		{
			// Since there are load the needed  tag type ids
			$tag_ids = $db->loadColumn();
			// Remove Tag from the content type table
			$tag_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.tag') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($tag_condition);
			$db->setQuery($query);
			// Execute the query to remove Tag items
			$tag_done = $db->execute();
			if ($tag_done)
			{
				// If successfully remove Tag add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.tag) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Tag items from the contentitem tag map table
			$tag_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.tag') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($tag_condition);
			$db->setQuery($query);
			// Execute the query to remove Tag items
			$tag_done = $db->execute();
			if ($tag_done)
			{
				// If successfully remove Tag add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.tag) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Tag items from the ucm content table
			$tag_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.tag') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($tag_condition);
			$db->setQuery($query);
			// Execute the query to remove Tag items
			$tag_done = $db->execute();
			if ($tag_done)
			{
				// If successfully removed Tag add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.tag) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Tag items are cleared from DB
			foreach ($tag_ids as $tag_id)
			{
				// Remove Tag items from the ucm base table
				$tag_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $tag_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($tag_condition);
				$db->setQuery($query);
				// Execute the query to remove Tag items
				$db->execute();

				// Remove Tag items from the ucm history table
				$tag_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $tag_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($tag_condition);
				$db->setQuery($query);
				// Execute the query to remove Tag items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Tag_instance alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.tag_instance') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$tag_instance_found = $db->getNumRows();
		// Now check if there were any rows
		if ($tag_instance_found)
		{
			// Since there are load the needed  tag_instance type ids
			$tag_instance_ids = $db->loadColumn();
			// Remove Tag_instance from the content type table
			$tag_instance_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.tag_instance') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($tag_instance_condition);
			$db->setQuery($query);
			// Execute the query to remove Tag_instance items
			$tag_instance_done = $db->execute();
			if ($tag_instance_done)
			{
				// If successfully remove Tag_instance add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.tag_instance) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Tag_instance items from the contentitem tag map table
			$tag_instance_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.tag_instance') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($tag_instance_condition);
			$db->setQuery($query);
			// Execute the query to remove Tag_instance items
			$tag_instance_done = $db->execute();
			if ($tag_instance_done)
			{
				// If successfully remove Tag_instance add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.tag_instance) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Tag_instance items from the ucm content table
			$tag_instance_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.tag_instance') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($tag_instance_condition);
			$db->setQuery($query);
			// Execute the query to remove Tag_instance items
			$tag_instance_done = $db->execute();
			if ($tag_instance_done)
			{
				// If successfully removed Tag_instance add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.tag_instance) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Tag_instance items are cleared from DB
			foreach ($tag_instance_ids as $tag_instance_id)
			{
				// Remove Tag_instance items from the ucm base table
				$tag_instance_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $tag_instance_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($tag_instance_condition);
				$db->setQuery($query);
				// Execute the query to remove Tag_instance items
				$db->execute();

				// Remove Tag_instance items from the ucm history table
				$tag_instance_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $tag_instance_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($tag_instance_condition);
				$db->setQuery($query);
				// Execute the query to remove Tag_instance items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Section alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.section') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$section_found = $db->getNumRows();
		// Now check if there were any rows
		if ($section_found)
		{
			// Since there are load the needed  section type ids
			$section_ids = $db->loadColumn();
			// Remove Section from the content type table
			$section_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.section') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($section_condition);
			$db->setQuery($query);
			// Execute the query to remove Section items
			$section_done = $db->execute();
			if ($section_done)
			{
				// If successfully remove Section add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.section) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Section items from the contentitem tag map table
			$section_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.section') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($section_condition);
			$db->setQuery($query);
			// Execute the query to remove Section items
			$section_done = $db->execute();
			if ($section_done)
			{
				// If successfully remove Section add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.section) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Section items from the ucm content table
			$section_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.section') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($section_condition);
			$db->setQuery($query);
			// Execute the query to remove Section items
			$section_done = $db->execute();
			if ($section_done)
			{
				// If successfully removed Section add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.section) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Section items are cleared from DB
			foreach ($section_ids as $section_id)
			{
				// Remove Section items from the ucm base table
				$section_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $section_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($section_condition);
				$db->setQuery($query);
				// Execute the query to remove Section items
				$db->execute();

				// Remove Section items from the ucm history table
				$section_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $section_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($section_condition);
				$db->setQuery($query);
				// Execute the query to remove Section items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Module alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.module') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$module_found = $db->getNumRows();
		// Now check if there were any rows
		if ($module_found)
		{
			// Since there are load the needed  module type ids
			$module_ids = $db->loadColumn();
			// Remove Module from the content type table
			$module_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.module') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($module_condition);
			$db->setQuery($query);
			// Execute the query to remove Module items
			$module_done = $db->execute();
			if ($module_done)
			{
				// If successfully remove Module add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.module) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Module items from the contentitem tag map table
			$module_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.module') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($module_condition);
			$db->setQuery($query);
			// Execute the query to remove Module items
			$module_done = $db->execute();
			if ($module_done)
			{
				// If successfully remove Module add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.module) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Module items from the ucm content table
			$module_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.module') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($module_condition);
			$db->setQuery($query);
			// Execute the query to remove Module items
			$module_done = $db->execute();
			if ($module_done)
			{
				// If successfully removed Module add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.module) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Module items are cleared from DB
			foreach ($module_ids as $module_id)
			{
				// Remove Module items from the ucm base table
				$module_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $module_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($module_condition);
				$db->setQuery($query);
				// Execute the query to remove Module items
				$db->execute();

				// Remove Module items from the ucm history table
				$module_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $module_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($module_condition);
				$db->setQuery($query);
				// Execute the query to remove Module items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Content alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.content') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$content_found = $db->getNumRows();
		// Now check if there were any rows
		if ($content_found)
		{
			// Since there are load the needed  content type ids
			$content_ids = $db->loadColumn();
			// Remove Content from the content type table
			$content_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.content') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($content_condition);
			$db->setQuery($query);
			// Execute the query to remove Content items
			$content_done = $db->execute();
			if ($content_done)
			{
				// If successfully remove Content add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.content) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Content items from the contentitem tag map table
			$content_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.content') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($content_condition);
			$db->setQuery($query);
			// Execute the query to remove Content items
			$content_done = $db->execute();
			if ($content_done)
			{
				// If successfully remove Content add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.content) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Content items from the ucm content table
			$content_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.content') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($content_condition);
			$db->setQuery($query);
			// Execute the query to remove Content items
			$content_done = $db->execute();
			if ($content_done)
			{
				// If successfully removed Content add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.content) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Content items are cleared from DB
			foreach ($content_ids as $content_id)
			{
				// Remove Content items from the ucm base table
				$content_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $content_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($content_condition);
				$db->setQuery($query);
				// Execute the query to remove Content items
				$db->execute();

				// Remove Content items from the ucm history table
				$content_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $content_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($content_condition);
				$db->setQuery($query);
				// Execute the query to remove Content items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Category_map alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.category_map') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$category_map_found = $db->getNumRows();
		// Now check if there were any rows
		if ($category_map_found)
		{
			// Since there are load the needed  category_map type ids
			$category_map_ids = $db->loadColumn();
			// Remove Category_map from the content type table
			$category_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.category_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($category_map_condition);
			$db->setQuery($query);
			// Execute the query to remove Category_map items
			$category_map_done = $db->execute();
			if ($category_map_done)
			{
				// If successfully remove Category_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.category_map) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Category_map items from the contentitem tag map table
			$category_map_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.category_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($category_map_condition);
			$db->setQuery($query);
			// Execute the query to remove Category_map items
			$category_map_done = $db->execute();
			if ($category_map_done)
			{
				// If successfully remove Category_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.category_map) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Category_map items from the ucm content table
			$category_map_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.category_map') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($category_map_condition);
			$db->setQuery($query);
			// Execute the query to remove Category_map items
			$category_map_done = $db->execute();
			if ($category_map_done)
			{
				// If successfully removed Category_map add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.category_map) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Category_map items are cleared from DB
			foreach ($category_map_ids as $category_map_id)
			{
				// Remove Category_map items from the ucm base table
				$category_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $category_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($category_map_condition);
				$db->setQuery($query);
				// Execute the query to remove Category_map items
				$db->execute();

				// Remove Category_map items from the ucm history table
				$category_map_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $category_map_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($category_map_condition);
				$db->setQuery($query);
				// Execute the query to remove Category_map items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Cohort alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.cohort') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$cohort_found = $db->getNumRows();
		// Now check if there were any rows
		if ($cohort_found)
		{
			// Since there are load the needed  cohort type ids
			$cohort_ids = $db->loadColumn();
			// Remove Cohort from the content type table
			$cohort_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.cohort') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($cohort_condition);
			$db->setQuery($query);
			// Execute the query to remove Cohort items
			$cohort_done = $db->execute();
			if ($cohort_done)
			{
				// If successfully remove Cohort add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.cohort) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Cohort items from the contentitem tag map table
			$cohort_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_moojla.cohort') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($cohort_condition);
			$db->setQuery($query);
			// Execute the query to remove Cohort items
			$cohort_done = $db->execute();
			if ($cohort_done)
			{
				// If successfully remove Cohort add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.cohort) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Cohort items from the ucm content table
			$cohort_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_moojla.cohort') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($cohort_condition);
			$db->setQuery($query);
			// Execute the query to remove Cohort items
			$cohort_done = $db->execute();
			if ($cohort_done)
			{
				// If successfully removed Cohort add queued success message.
				$app->enqueueMessage(JText::_('The (com_moojla.cohort) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Cohort items are cleared from DB
			foreach ($cohort_ids as $cohort_id)
			{
				// Remove Cohort items from the ucm base table
				$cohort_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $cohort_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($cohort_condition);
				$db->setQuery($query);
				// Execute the query to remove Cohort items
				$db->execute();

				// Remove Cohort items from the ucm history table
				$cohort_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $cohort_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($cohort_condition);
				$db->setQuery($query);
				// Execute the query to remove Cohort items
				$db->execute();
			}
		}

		// If All related items was removed queued success message.
		$app->enqueueMessage(JText::_('All related items was removed from the <b>#__ucm_base</b> table'));
		$app->enqueueMessage(JText::_('All related items was removed from the <b>#__ucm_history</b> table'));

		// Remove moojla assets from the assets table
		$moojla_condition = array( $db->quoteName('name') . ' LIKE ' . $db->quote('com_moojla%') );

		// Create a new query object.
		$query = $db->getQuery(true);
		$query->delete($db->quoteName('#__assets'));
		$query->where($moojla_condition);
		$db->setQuery($query);
		$cohort_done = $db->execute();
		if ($cohort_done)
		{
			// If successfully removed moojla add queued success message.
			$app->enqueueMessage(JText::_('All related items was removed from the <b>#__assets</b> table'));
		}

/***[JCBGUI.joomla_component.php_method_uninstall.29.$$$$]***/
require_once JPATH_ADMINISTRATOR.'/components/com_menus/models/item.php';
require_once JPATH_ADMINISTRATOR.'/components/com_menus/tables/menu.php' ;

$db = JFactory::getDbo();
$query = $db->getQuery(true);

$query->select('id')->from($db->quoteName('#__menu'))->where($db->quoteName('menutype').'='.$db->quote('moojla_default'));
$db->setQuery($query);
$menuItemIds= $db->loadColumn(0);


$obj= new MenusModelItem;
$obj->publish($menuItemIds,-2);
$obj->delete($menuItemIds);


$query = $db->getQuery(true);

$query->delete($db->quoteName('#__menu_types'))->where($db->quoteName('menutype').'='.$db->quote('moojla_default'));
$db->setQuery($query);
$db->execute();/***[/JCBGUI$$$$]***/


		// little notice as after service, in case of bad experience with component.
		echo '<h2>Did something go wrong? Are you disappointed?</h2>
		<p>Please let me know at <a href="mailto:info@Lmskaran.com">info@Lmskaran.com</a>.
		<br />We at Lmskaran are committed to building extensions that performs proficiently! You can help us, really!
		<br />Send me your thoughts on improvements that is needed, trust me, I will be very grateful!
		<br />Visit us at <a href="http://Lmskaran.com" target="_blank">http://Lmskaran.com</a> today!</p>';
	}

	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function update(JAdapterInstance $parent){}

	/**
	 * Called before any type of action
	 *
	 * @param   string  $type  Which action is happening (install|uninstall|discover_install|update)
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function preflight($type, JAdapterInstance $parent)
	{
		// get application
		$app = JFactory::getApplication();
		// is redundant or so it seems ...hmmm let me know if it works again
		if ($type === 'uninstall')
		{
			return true;
		}
		// the default for both install and update
		$jversion = new JVersion();
		if (!$jversion->isCompatible('3.8.0'))
		{
			$app->enqueueMessage('Please upgrade to at least Joomla! 3.8.0 before continuing!', 'error');
			return false;
		}
		// do any updates needed
		if ($type === 'update')
		{
		}
		// do any install needed
		if ($type === 'install')
		{
		}
		// check if the PHPExcel stuff is still around
		if (File::exists(JPATH_ADMINISTRATOR . '/components/com_moojla/helpers/PHPExcel.php'))
		{
			// We need to remove this old PHPExcel folder
			$this->removeFolder(JPATH_ADMINISTRATOR . '/components/com_moojla/helpers/PHPExcel');
			// We need to remove this old PHPExcel file
			File::delete(JPATH_ADMINISTRATOR . '/components/com_moojla/helpers/PHPExcel.php');
		}
		return true;
	}

	/**
	 * Called after any type of action
	 *
	 * @param   string  $type  Which action is happening (install|uninstall|discover_install|update)
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function postflight($type, JAdapterInstance $parent)
	{
		// get application
		$app = JFactory::getApplication();
		// We check if we have dynamic folders to copy
		$this->setDynamicF0ld3rs($app, $parent);
		// set the default component settings
		if ($type === 'install')
		{

			// Get The Database object
			$db = JFactory::getDbo();

			// Create the course content type object.
			$course = new stdClass();
			$course->type_title = 'Moojla Course';
			$course->type_alias = 'com_moojla.course';
			$course->table = '{"special": {"dbtable": "#__moojla_course","key": "id","type": "Course","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$course->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "shortname","core_state": "published","core_alias": "alias","core_created_time": "created","core_modified_time": "modified","core_body": "teachers","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "metadata","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "metakey","core_metadesc": "metadesc","core_catid": "catid","core_xreference": "null","asset_id": "asset_id"},"special": {"shortname":"shortname","fullname":"fullname","addcontrols":"addcontrols","showregtab":"showregtab","startdate":"startdate","enterlbl":"enterlbl","cangotomoodle":"cangotomoodle","preloadaudio":"preloadaudio","loginurl":"loginurl","in_enrol_date":"in_enrol_date","enddate":"enddate","remoteid":"remoteid","guest":"guest","cost":"cost","teachers":"teachers","summary_files":"summary_files","autoplay":"autoplay","summary":"summary","useglobalaudio":"useglobalaudio","alias":"alias","cat_name":"cat_name","currency":"currency","alterurl":"alterurl","loginlbl":"loginlbl","buylbl":"buylbl","enrollbl":"enrollbl","popupbutton":"popupbutton","videotype":"videotype","registrationurl":"registrationurl","self_enrolment":"self_enrolment","freeenterlbl":"freeenterlbl","permanent_fields":"permanent_fields","useglobalvideo":"useglobalvideo","course_templatestyle_forcourseconfig":"course_templatestyle_forcourseconfig","preventdownload":"preventdownload","course_detail_layout":"course_detail_layout","preloadvideo":"preloadvideo","availabilityinfolink":"availabilityinfolink","muted":"muted","redirect_after_enrol":"redirect_after_enrol","preventdownloadaudio":"preventdownloadaudio","showlogintab":"showlogintab","autoplayaudio":"autoplayaudio","cat_id":"cat_id"}}';
			$course->router = 'MoojlaHelperRoute::getCourseRoute';
			$course->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/course.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","catid","addcontrols","showregtab","cangotomoodle","preloadaudio","remoteid","guest","cost","autoplay","useglobalaudio","popupbutton","videotype","useglobalvideo","course_templatestyle_forcourseconfig","preventdownload","preloadvideo","availabilityinfolink","muted","redirect_after_enrol","preventdownloadaudio","showlogintab","autoplayaudio","cat_id"],"displayLookup": [{"sourceColumn": "catid","targetTable": "#__categories","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "course_templatestyle_forcourseconfig","targetTable": "#__template_styles","targetColumn": "id","displayColumn": "title"}]}';

			// Set the object into the content types table.
			$course_Inserted = $db->insertObject('#__content_types', $course);

			// Create the course category content type object.
			$course_category = new stdClass();
			$course_category->type_title = 'Moojla Course Catid';
			$course_category->type_alias = 'com_moojla.course.category';
			$course_category->table = '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}';
			$course_category->field_mappings = '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}';
			$course_category->router = 'MoojlaHelperRoute::getCategoryRoute';
			$course_category->content_history_options = '{"formFile":"administrator\/components\/com_categories\/models\/forms\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}';

			// Set the object into the content types table.
			$course_category_Inserted = $db->insertObject('#__content_types', $course_category);

			// Create the course_field_mapper content type object.
			$course_field_mapper = new stdClass();
			$course_field_mapper->type_title = 'Moojla Course_field_mapper';
			$course_field_mapper->type_alias = 'com_moojla.course_field_mapper';
			$course_field_mapper->table = '{"special": {"dbtable": "#__moojla_course_field_mapper","key": "id","type": "Course_field_mapper","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$course_field_mapper->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "coursefield","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"coursefield":"coursefield","mcoursefields":"mcoursefields","field_icon":"field_icon"}}';
			$course_field_mapper->router = 'MoojlaHelperRoute::getCourse_field_mapperRoute';
			$course_field_mapper->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/course_field_mapper.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","coursefield"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "coursefield","targetTable": "#__fields","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "mcoursefields","targetTable": "#__moojla_course_field_mapper","targetColumn": "id","displayColumn": "id"}]}';

			// Set the object into the content types table.
			$course_field_mapper_Inserted = $db->insertObject('#__content_types', $course_field_mapper);

			// Create the user_map content type object.
			$user_map = new stdClass();
			$user_map->type_title = 'Moojla User_map';
			$user_map->type_alias = 'com_moojla.user_map';
			$user_map->table = '{"special": {"dbtable": "#__moojla_user_map","key": "id","type": "User_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$user_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "jid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"jid":"jid","mid":"mid","userimage":"userimage","debug":"debug","updatetype":"updatetype"}}';
			$user_map->router = 'MoojlaHelperRoute::getUser_mapRoute';
			$user_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/user_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version","debug"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","jid","mid","updatetype"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$user_map_Inserted = $db->insertObject('#__content_types', $user_map);

			// Create the user_field_map content type object.
			$user_field_map = new stdClass();
			$user_field_map->type_title = 'Moojla User_field_map';
			$user_field_map->type_alias = 'com_moojla.user_field_map';
			$user_field_map->table = '{"special": {"dbtable": "#__moojla_user_field_map","key": "id","type": "User_field_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$user_field_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "juserfields","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"juserfields":"juserfields","muserfields":"muserfields","iscv":"iscv"}}';
			$user_field_map->router = 'MoojlaHelperRoute::getUser_field_mapRoute';
			$user_field_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/user_field_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","iscv"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "juserfields","targetTable": "#__fields","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "muserfields","targetTable": "#__moojla_user_field_map","targetColumn": "id","displayColumn": "id"}]}';

			// Set the object into the content types table.
			$user_field_map_Inserted = $db->insertObject('#__content_types', $user_field_map);

			// Create the course_group_map content type object.
			$course_group_map = new stdClass();
			$course_group_map->type_title = 'Moojla Course_group_map';
			$course_group_map->type_alias = 'com_moojla.course_group_map';
			$course_group_map->table = '{"special": {"dbtable": "#__moojla_course_group_map","key": "id","type": "Course_group_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$course_group_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "moojlacourse","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"moojlacourse":"moojlacourse","course_group":"course_group","role":"role"}}';
			$course_group_map->router = 'MoojlaHelperRoute::getCourse_group_mapRoute';
			$course_group_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/course_group_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","moojlacourse","course_group","role"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "moojlacourse","targetTable": "#__moojla_course","targetColumn": "remoteid","displayColumn": "fullname"},{"sourceColumn": "course_group","targetTable": "#__usergroups","targetColumn": "id","displayColumn": "title"}]}';

			// Set the object into the content types table.
			$course_group_map_Inserted = $db->insertObject('#__content_types', $course_group_map);

			// Create the enrolment content type object.
			$enrolment = new stdClass();
			$enrolment->type_title = 'Moojla Enrolment';
			$enrolment->type_alias = 'com_moojla.enrolment';
			$enrolment->table = '{"special": {"dbtable": "#__moojla_enrolment","key": "id","type": "Enrolment","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$enrolment->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"role":"role","moojlacourse":"moojlacourse","jid":"jid","enrolldate":"enrolldate"}}';
			$enrolment->router = 'MoojlaHelperRoute::getEnrolmentRoute';
			$enrolment->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/enrolment.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","moojlacourse","jid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "moojlacourse","targetTable": "#__moojla_course","targetColumn": "remoteid","displayColumn": "fullname"},{"sourceColumn": "jid","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$enrolment_Inserted = $db->insertObject('#__content_types', $enrolment);

			// Create the tag content type object.
			$tag = new stdClass();
			$tag->type_title = 'Moojla Tag';
			$tag->type_alias = 'com_moojla.tag';
			$tag->table = '{"special": {"dbtable": "#__moojla_tag","key": "id","type": "Tag","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$tag->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "tagname","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"tagid":"tagid","tagname":"tagname","isstandard":"isstandard","tags":"tags"}}';
			$tag->router = 'MoojlaHelperRoute::getTagRoute';
			$tag->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/tag.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","tagid","isstandard","tags"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$tag_Inserted = $db->insertObject('#__content_types', $tag);

			// Create the tag_instance content type object.
			$tag_instance = new stdClass();
			$tag_instance->type_title = 'Moojla Tag_instance';
			$tag_instance->type_alias = 'com_moojla.tag_instance';
			$tag_instance->table = '{"special": {"dbtable": "#__moojla_tag_instance","key": "id","type": "Tag_instance","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$tag_instance->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "moojlacourse","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"moojlacourse":"moojlacourse","moodletag":"moodletag"}}';
			$tag_instance->router = 'MoojlaHelperRoute::getTag_instanceRoute';
			$tag_instance->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/tag_instance.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","moojlacourse","moodletag"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "moojlacourse","targetTable": "#__moojla_course","targetColumn": "remoteid","displayColumn": "fullname"},{"sourceColumn": "moodletag","targetTable": "#__moojla_tag","targetColumn": "tagid","displayColumn": "tagname"}]}';

			// Set the object into the content types table.
			$tag_instance_Inserted = $db->insertObject('#__content_types', $tag_instance);

			// Create the section content type object.
			$section = new stdClass();
			$section->type_title = 'Moojla Section';
			$section->type_alias = 'com_moojla.section';
			$section->table = '{"special": {"dbtable": "#__moojla_section","key": "id","type": "Section","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$section->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "section_id","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "summary","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"courseid":"courseid","section_id":"section_id","name":"name","visible":"visible","uservisible":"uservisible","summary":"summary"}}';
			$section->router = 'MoojlaHelperRoute::getSectionRoute';
			$section->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/section.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","courseid","section_id","visible","uservisible"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$section_Inserted = $db->insertObject('#__content_types', $section);

			// Create the module content type object.
			$module = new stdClass();
			$module->type_title = 'Moojla Module';
			$module->type_alias = 'com_moojla.module';
			$module->table = '{"special": {"dbtable": "#__moojla_module","key": "id","type": "Module","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$module->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "module_id","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "modicon","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"module_section_id":"module_section_id","module_id":"module_id","name":"name","modname":"modname","visible":"visible","uservisible":"uservisible","modicon":"modicon","description":"description","url":"url"}}';
			$module->router = 'MoojlaHelperRoute::getModuleRoute';
			$module->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/module.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","module_section_id","module_id","visible","uservisible"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$module_Inserted = $db->insertObject('#__content_types', $module);

			// Create the content content type object.
			$content = new stdClass();
			$content->type_title = 'Moojla Content';
			$content->type_alias = 'com_moojla.content';
			$content->table = '{"special": {"dbtable": "#__moojla_content","key": "id","type": "Content","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$content->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "type","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"contents_module_id":"contents_module_id","type":"type","filename":"filename","mimetype":"mimetype","file":"file","filesize":"filesize","fileurl":"fileurl"}}';
			$content->router = 'MoojlaHelperRoute::getContentRoute';
			$content->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/content.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","contents_module_id","filesize"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$content_Inserted = $db->insertObject('#__content_types', $content);

			// Create the category_map content type object.
			$category_map = new stdClass();
			$category_map->type_title = 'Moojla Category_map';
			$category_map->type_alias = 'com_moojla.category_map';
			$category_map->table = '{"special": {"dbtable": "#__moojla_category_map","key": "id","type": "Category_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$category_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"jcatid":"jcatid","mcatid":"mcatid"}}';
			$category_map->router = 'MoojlaHelperRoute::getCategory_mapRoute';
			$category_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/category_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","jcatid","mcatid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$category_map_Inserted = $db->insertObject('#__content_types', $category_map);

			// Create the cohort content type object.
			$cohort = new stdClass();
			$cohort->type_title = 'Moojla Cohort';
			$cohort->type_alias = 'com_moojla.cohort';
			$cohort->table = '{"special": {"dbtable": "#__moojla_cohort","key": "id","type": "Cohort","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$cohort->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"mcohort":"mcohort","course_group":"course_group"}}';
			$cohort->router = 'MoojlaHelperRoute::getCohortRoute';
			$cohort->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/cohort.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","mcohort","course_group"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "course_group","targetTable": "#__usergroups","targetColumn": "id","displayColumn": "title"}]}';

			// Set the object into the content types table.
			$cohort_Inserted = $db->insertObject('#__content_types', $cohort);


			// Install the global extenstion params.
			$query = $db->getQuery(true);
			// Field to update.
			$fields = array(
				$db->quoteName('params') . ' = ' . $db->quote('{"autorName":"Lmskaran","autorEmail":"info@Lmskaran.com","course_detail_ws":"1","fetch_course_contents":"0","showenrolled":"1","show_label_contents":"1","pagetype":"1","cert_download":"0","oncoursedeleted":"1","course_templatestyle":"0","showdebug":"0","favorite":"0","rating":"0","averagerate":"0","availabilityinfolink":"0","cangotomoodle":"0","redirect_after_enrol":"0","popupbutton":"1","showlogintab":"1","loginurl":"index.php?option=com_users&amp;task=login&amp;tmpl=component","showregtab":"1","registrationurl":"index.php?option=com_users&amp;view=registration&amp;tmpl=component","loginlbl":"Login","enterlbl":"Enter","freeenterlbl":"Enter (free)","buylbl":"Buy","enrollbl":"Enroll","videotype":"1","videowidth":"100%","videoheight":"100%","preventdownload":"0","addcontrols":"1","preloadvideo":"0","autoplay":"0","muted":"0","preventdownloadaudio":"0","preloadaudio":"0","autoplayaudio":"0","additional_data_source":"0","student_group":"2","teacher_group":"6","total_fetch_moodle_users":"1000","number_per_request_fetch_moodle_users":"50","shop_integration":"0","shopcattype":"1","courses_category":"0","onenrolmethoddeleted":"1","moodleskyroommods":"lmskaranskyroom","directentry":"1","mycourses":"0","role":"0","showmycourse":"0","showsearchsidebar":"1","searchinmycourse":"1","number_of_results":"12","cs_display_cost":"1","coursegroupferchstep":"5","total_fetch_enrolment":"1000","number_per_request_fetch_enrolment":"50","check_in":"-1 day","save_history":"1","history_limit":"10","staffusers":["2"]}'),
			);
			// Condition.
			$conditions = array(
				$db->quoteName('element') . ' = ' . $db->quote('com_moojla')
			);
			$query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
			$db->setQuery($query);
			$allDone = $db->execute();



/***[JCBGUI.joomla_component.php_postflight_install.29.$$$$]***/
     $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('id')->from($db->quoteName('#__menu_types'))->where($db->quoteName('menutype') . '=' . $db->quote('moojla_default'));
        $db->setQuery($query);
        $result = $db->loadResult();

        if (empty($result)) {

            $query = $db->getQuery(true)
                ->select('extension_id')
                ->from($db->quoteName('#__extensions'))
                ->where($db->quoteName('name') . '=' . $db->quote('COM_MOOJLA'))
                ->where($db->quoteName('type') . '=' . $db->quote('component'));

            $db->setQuery($query);
            $moojla_component_id = $db->loadResult();


            $query = $db->getQuery(true);
            $columns = array('menutype', 'title', 'description');

            $values = array($db->quote('moojla_default'), $db->quote('Moojla Default Menus'), $db->quote('Moojla Default Description'));

            $query
                ->insert($db->quoteName('#__menu_types'))
                ->columns($db->quoteName($columns))
                ->values(implode(',', $values));

            $db->setQuery($query);
            $db->execute();


            require_once JPATH_ADMINISTRATOR . '/components/com_menus/tables/menu.php';
            require_once JPATH_ADMINISTRATOR . '/components/com_menus/models/item.php';
            $obj = new MenusModelItem;
            $menuItems = array(
                'moojla_default' =>
                    array(
                        'menutype' => 'moojla_default',
                        'title' => 'moojla_course_search',
                        'type' => 'component',
                        'link' => 'index.php?option=com_moojla&view=course_search',
                        'language' => '*',
                        'published' => 1,
                        'level' => 1,
                        'parent_id' => 1,
                        'access' => 1,
                        'client_id' => 0
                    )
            );

         

            foreach ($menuItems as $key => &$menuItem) {
                if ($key == 'moojla_default') {
                    $menuItem['component_id'] = $moojla_component_id;
                }

                $obj->save($menuItem);

            }


        }
/***[/JCBGUI$$$$]***/

			echo '<a target="_blank" href="http://Lmskaran.com" title="Moojla">
				<img src="components/com_moojla/assets/images/vdm-component.png"/>
				</a>';
		}
		// do any updates needed
		if ($type === 'update')
		{

			// Get The Database object
			$db = JFactory::getDbo();

			// Create the course content type object.
			$course = new stdClass();
			$course->type_title = 'Moojla Course';
			$course->type_alias = 'com_moojla.course';
			$course->table = '{"special": {"dbtable": "#__moojla_course","key": "id","type": "Course","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$course->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "shortname","core_state": "published","core_alias": "alias","core_created_time": "created","core_modified_time": "modified","core_body": "teachers","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "metadata","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "metakey","core_metadesc": "metadesc","core_catid": "catid","core_xreference": "null","asset_id": "asset_id"},"special": {"shortname":"shortname","fullname":"fullname","addcontrols":"addcontrols","showregtab":"showregtab","startdate":"startdate","enterlbl":"enterlbl","cangotomoodle":"cangotomoodle","preloadaudio":"preloadaudio","loginurl":"loginurl","in_enrol_date":"in_enrol_date","enddate":"enddate","remoteid":"remoteid","guest":"guest","cost":"cost","teachers":"teachers","summary_files":"summary_files","autoplay":"autoplay","summary":"summary","useglobalaudio":"useglobalaudio","alias":"alias","cat_name":"cat_name","currency":"currency","alterurl":"alterurl","loginlbl":"loginlbl","buylbl":"buylbl","enrollbl":"enrollbl","popupbutton":"popupbutton","videotype":"videotype","registrationurl":"registrationurl","self_enrolment":"self_enrolment","freeenterlbl":"freeenterlbl","permanent_fields":"permanent_fields","useglobalvideo":"useglobalvideo","course_templatestyle_forcourseconfig":"course_templatestyle_forcourseconfig","preventdownload":"preventdownload","course_detail_layout":"course_detail_layout","preloadvideo":"preloadvideo","availabilityinfolink":"availabilityinfolink","muted":"muted","redirect_after_enrol":"redirect_after_enrol","preventdownloadaudio":"preventdownloadaudio","showlogintab":"showlogintab","autoplayaudio":"autoplayaudio","cat_id":"cat_id"}}';
			$course->router = 'MoojlaHelperRoute::getCourseRoute';
			$course->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/course.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","catid","addcontrols","showregtab","cangotomoodle","preloadaudio","remoteid","guest","cost","autoplay","useglobalaudio","popupbutton","videotype","useglobalvideo","course_templatestyle_forcourseconfig","preventdownload","preloadvideo","availabilityinfolink","muted","redirect_after_enrol","preventdownloadaudio","showlogintab","autoplayaudio","cat_id"],"displayLookup": [{"sourceColumn": "catid","targetTable": "#__categories","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "course_templatestyle_forcourseconfig","targetTable": "#__template_styles","targetColumn": "id","displayColumn": "title"}]}';

			// Check if course type is already in content_type DB.
			$course_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($course->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$course->type_id = $db->loadResult();
				$course_Updated = $db->updateObject('#__content_types', $course, 'type_id');
			}
			else
			{
				$course_Inserted = $db->insertObject('#__content_types', $course);
			}

			// Create the course category content type object.
			$course_category = new stdClass();
			$course_category->type_title = 'Moojla Course Catid';
			$course_category->type_alias = 'com_moojla.course.category';
			$course_category->table = '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}';
			$course_category->field_mappings = '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}';
			$course_category->router = 'MoojlaHelperRoute::getCategoryRoute';
			$course_category->content_history_options = '{"formFile":"administrator\/components\/com_categories\/models\/forms\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}';

			// Check if course category type is already in content_type DB.
			$course_category_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($course_category->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$course_category->type_id = $db->loadResult();
				$course_category_Updated = $db->updateObject('#__content_types', $course_category, 'type_id');
			}
			else
			{
				$course_category_Inserted = $db->insertObject('#__content_types', $course_category);
			}

			// Create the course_field_mapper content type object.
			$course_field_mapper = new stdClass();
			$course_field_mapper->type_title = 'Moojla Course_field_mapper';
			$course_field_mapper->type_alias = 'com_moojla.course_field_mapper';
			$course_field_mapper->table = '{"special": {"dbtable": "#__moojla_course_field_mapper","key": "id","type": "Course_field_mapper","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$course_field_mapper->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "coursefield","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"coursefield":"coursefield","mcoursefields":"mcoursefields","field_icon":"field_icon"}}';
			$course_field_mapper->router = 'MoojlaHelperRoute::getCourse_field_mapperRoute';
			$course_field_mapper->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/course_field_mapper.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","coursefield"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "coursefield","targetTable": "#__fields","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "mcoursefields","targetTable": "#__moojla_course_field_mapper","targetColumn": "id","displayColumn": "id"}]}';

			// Check if course_field_mapper type is already in content_type DB.
			$course_field_mapper_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($course_field_mapper->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$course_field_mapper->type_id = $db->loadResult();
				$course_field_mapper_Updated = $db->updateObject('#__content_types', $course_field_mapper, 'type_id');
			}
			else
			{
				$course_field_mapper_Inserted = $db->insertObject('#__content_types', $course_field_mapper);
			}

			// Create the user_map content type object.
			$user_map = new stdClass();
			$user_map->type_title = 'Moojla User_map';
			$user_map->type_alias = 'com_moojla.user_map';
			$user_map->table = '{"special": {"dbtable": "#__moojla_user_map","key": "id","type": "User_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$user_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "jid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"jid":"jid","mid":"mid","userimage":"userimage","debug":"debug","updatetype":"updatetype"}}';
			$user_map->router = 'MoojlaHelperRoute::getUser_mapRoute';
			$user_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/user_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version","debug"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","jid","mid","updatetype"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Check if user_map type is already in content_type DB.
			$user_map_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($user_map->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$user_map->type_id = $db->loadResult();
				$user_map_Updated = $db->updateObject('#__content_types', $user_map, 'type_id');
			}
			else
			{
				$user_map_Inserted = $db->insertObject('#__content_types', $user_map);
			}

			// Create the user_field_map content type object.
			$user_field_map = new stdClass();
			$user_field_map->type_title = 'Moojla User_field_map';
			$user_field_map->type_alias = 'com_moojla.user_field_map';
			$user_field_map->table = '{"special": {"dbtable": "#__moojla_user_field_map","key": "id","type": "User_field_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$user_field_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "juserfields","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"juserfields":"juserfields","muserfields":"muserfields","iscv":"iscv"}}';
			$user_field_map->router = 'MoojlaHelperRoute::getUser_field_mapRoute';
			$user_field_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/user_field_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","iscv"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "juserfields","targetTable": "#__fields","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "muserfields","targetTable": "#__moojla_user_field_map","targetColumn": "id","displayColumn": "id"}]}';

			// Check if user_field_map type is already in content_type DB.
			$user_field_map_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($user_field_map->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$user_field_map->type_id = $db->loadResult();
				$user_field_map_Updated = $db->updateObject('#__content_types', $user_field_map, 'type_id');
			}
			else
			{
				$user_field_map_Inserted = $db->insertObject('#__content_types', $user_field_map);
			}

			// Create the course_group_map content type object.
			$course_group_map = new stdClass();
			$course_group_map->type_title = 'Moojla Course_group_map';
			$course_group_map->type_alias = 'com_moojla.course_group_map';
			$course_group_map->table = '{"special": {"dbtable": "#__moojla_course_group_map","key": "id","type": "Course_group_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$course_group_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "moojlacourse","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"moojlacourse":"moojlacourse","course_group":"course_group","role":"role"}}';
			$course_group_map->router = 'MoojlaHelperRoute::getCourse_group_mapRoute';
			$course_group_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/course_group_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","moojlacourse","course_group","role"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "moojlacourse","targetTable": "#__moojla_course","targetColumn": "remoteid","displayColumn": "fullname"},{"sourceColumn": "course_group","targetTable": "#__usergroups","targetColumn": "id","displayColumn": "title"}]}';

			// Check if course_group_map type is already in content_type DB.
			$course_group_map_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($course_group_map->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$course_group_map->type_id = $db->loadResult();
				$course_group_map_Updated = $db->updateObject('#__content_types', $course_group_map, 'type_id');
			}
			else
			{
				$course_group_map_Inserted = $db->insertObject('#__content_types', $course_group_map);
			}

			// Create the enrolment content type object.
			$enrolment = new stdClass();
			$enrolment->type_title = 'Moojla Enrolment';
			$enrolment->type_alias = 'com_moojla.enrolment';
			$enrolment->table = '{"special": {"dbtable": "#__moojla_enrolment","key": "id","type": "Enrolment","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$enrolment->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"role":"role","moojlacourse":"moojlacourse","jid":"jid","enrolldate":"enrolldate"}}';
			$enrolment->router = 'MoojlaHelperRoute::getEnrolmentRoute';
			$enrolment->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/enrolment.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","moojlacourse","jid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "moojlacourse","targetTable": "#__moojla_course","targetColumn": "remoteid","displayColumn": "fullname"},{"sourceColumn": "jid","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Check if enrolment type is already in content_type DB.
			$enrolment_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($enrolment->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$enrolment->type_id = $db->loadResult();
				$enrolment_Updated = $db->updateObject('#__content_types', $enrolment, 'type_id');
			}
			else
			{
				$enrolment_Inserted = $db->insertObject('#__content_types', $enrolment);
			}

			// Create the tag content type object.
			$tag = new stdClass();
			$tag->type_title = 'Moojla Tag';
			$tag->type_alias = 'com_moojla.tag';
			$tag->table = '{"special": {"dbtable": "#__moojla_tag","key": "id","type": "Tag","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$tag->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "tagname","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"tagid":"tagid","tagname":"tagname","isstandard":"isstandard","tags":"tags"}}';
			$tag->router = 'MoojlaHelperRoute::getTagRoute';
			$tag->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/tag.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","tagid","isstandard","tags"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Check if tag type is already in content_type DB.
			$tag_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($tag->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$tag->type_id = $db->loadResult();
				$tag_Updated = $db->updateObject('#__content_types', $tag, 'type_id');
			}
			else
			{
				$tag_Inserted = $db->insertObject('#__content_types', $tag);
			}

			// Create the tag_instance content type object.
			$tag_instance = new stdClass();
			$tag_instance->type_title = 'Moojla Tag_instance';
			$tag_instance->type_alias = 'com_moojla.tag_instance';
			$tag_instance->table = '{"special": {"dbtable": "#__moojla_tag_instance","key": "id","type": "Tag_instance","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$tag_instance->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "moojlacourse","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"moojlacourse":"moojlacourse","moodletag":"moodletag"}}';
			$tag_instance->router = 'MoojlaHelperRoute::getTag_instanceRoute';
			$tag_instance->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/tag_instance.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","moojlacourse","moodletag"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "moojlacourse","targetTable": "#__moojla_course","targetColumn": "remoteid","displayColumn": "fullname"},{"sourceColumn": "moodletag","targetTable": "#__moojla_tag","targetColumn": "tagid","displayColumn": "tagname"}]}';

			// Check if tag_instance type is already in content_type DB.
			$tag_instance_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($tag_instance->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$tag_instance->type_id = $db->loadResult();
				$tag_instance_Updated = $db->updateObject('#__content_types', $tag_instance, 'type_id');
			}
			else
			{
				$tag_instance_Inserted = $db->insertObject('#__content_types', $tag_instance);
			}

			// Create the section content type object.
			$section = new stdClass();
			$section->type_title = 'Moojla Section';
			$section->type_alias = 'com_moojla.section';
			$section->table = '{"special": {"dbtable": "#__moojla_section","key": "id","type": "Section","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$section->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "section_id","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "summary","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"courseid":"courseid","section_id":"section_id","name":"name","visible":"visible","uservisible":"uservisible","summary":"summary"}}';
			$section->router = 'MoojlaHelperRoute::getSectionRoute';
			$section->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/section.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","courseid","section_id","visible","uservisible"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Check if section type is already in content_type DB.
			$section_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($section->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$section->type_id = $db->loadResult();
				$section_Updated = $db->updateObject('#__content_types', $section, 'type_id');
			}
			else
			{
				$section_Inserted = $db->insertObject('#__content_types', $section);
			}

			// Create the module content type object.
			$module = new stdClass();
			$module->type_title = 'Moojla Module';
			$module->type_alias = 'com_moojla.module';
			$module->table = '{"special": {"dbtable": "#__moojla_module","key": "id","type": "Module","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$module->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "module_id","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "modicon","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"module_section_id":"module_section_id","module_id":"module_id","name":"name","modname":"modname","visible":"visible","uservisible":"uservisible","modicon":"modicon","description":"description","url":"url"}}';
			$module->router = 'MoojlaHelperRoute::getModuleRoute';
			$module->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/module.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","module_section_id","module_id","visible","uservisible"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Check if module type is already in content_type DB.
			$module_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($module->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$module->type_id = $db->loadResult();
				$module_Updated = $db->updateObject('#__content_types', $module, 'type_id');
			}
			else
			{
				$module_Inserted = $db->insertObject('#__content_types', $module);
			}

			// Create the content content type object.
			$content = new stdClass();
			$content->type_title = 'Moojla Content';
			$content->type_alias = 'com_moojla.content';
			$content->table = '{"special": {"dbtable": "#__moojla_content","key": "id","type": "Content","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$content->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "type","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"contents_module_id":"contents_module_id","type":"type","filename":"filename","mimetype":"mimetype","file":"file","filesize":"filesize","fileurl":"fileurl"}}';
			$content->router = 'MoojlaHelperRoute::getContentRoute';
			$content->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/content.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","contents_module_id","filesize"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Check if content type is already in content_type DB.
			$content_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($content->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$content->type_id = $db->loadResult();
				$content_Updated = $db->updateObject('#__content_types', $content, 'type_id');
			}
			else
			{
				$content_Inserted = $db->insertObject('#__content_types', $content);
			}

			// Create the category_map content type object.
			$category_map = new stdClass();
			$category_map->type_title = 'Moojla Category_map';
			$category_map->type_alias = 'com_moojla.category_map';
			$category_map->table = '{"special": {"dbtable": "#__moojla_category_map","key": "id","type": "Category_map","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$category_map->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"jcatid":"jcatid","mcatid":"mcatid"}}';
			$category_map->router = 'MoojlaHelperRoute::getCategory_mapRoute';
			$category_map->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/category_map.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","jcatid","mcatid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"}]}';

			// Check if category_map type is already in content_type DB.
			$category_map_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($category_map->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$category_map->type_id = $db->loadResult();
				$category_map_Updated = $db->updateObject('#__content_types', $category_map, 'type_id');
			}
			else
			{
				$category_map_Inserted = $db->insertObject('#__content_types', $category_map);
			}

			// Create the cohort content type object.
			$cohort = new stdClass();
			$cohort->type_title = 'Moojla Cohort';
			$cohort->type_alias = 'com_moojla.cohort';
			$cohort->table = '{"special": {"dbtable": "#__moojla_cohort","key": "id","type": "Cohort","prefix": "moojlaTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$cohort->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "null","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"mcohort":"mcohort","course_group":"course_group"}}';
			$cohort->router = 'MoojlaHelperRoute::getCohortRoute';
			$cohort->content_history_options = '{"formFile": "administrator/components/com_moojla/models/forms/cohort.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","mcohort","course_group"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "course_group","targetTable": "#__usergroups","targetColumn": "id","displayColumn": "title"}]}';

			// Check if cohort type is already in content_type DB.
			$cohort_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($cohort->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$cohort->type_id = $db->loadResult();
				$cohort_Updated = $db->updateObject('#__content_types', $cohort, 'type_id');
			}
			else
			{
				$cohort_Inserted = $db->insertObject('#__content_types', $cohort);
			}




/***[JCBGUI.joomla_component.php_postflight_update.29.$$$$]***/
     $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('id')->from($db->quoteName('#__menu_types'))->where($db->quoteName('menutype') . '=' . $db->quote('moojla_default'));
        $db->setQuery($query);
        $result = $db->loadResult();

        if (empty($result)) {

            $query = $db->getQuery(true)
                ->select('extension_id')
                ->from($db->quoteName('#__extensions'))
                ->where($db->quoteName('name') . '=' . $db->quote('COM_MOOJLA'))
                ->where($db->quoteName('type') . '=' . $db->quote('component'));

            $db->setQuery($query);
            $moojla_component_id = $db->loadResult();


            $query = $db->getQuery(true);
            $columns = array('menutype', 'title', 'description');

            $values = array($db->quote('moojla_default'), $db->quote('Moojla Default Menus'), $db->quote('Moojla Default Description'));

            $query
                ->insert($db->quoteName('#__menu_types'))
                ->columns($db->quoteName($columns))
                ->values(implode(',', $values));

            $db->setQuery($query);
            $db->execute();


            require_once JPATH_ADMINISTRATOR . '/components/com_menus/tables/menu.php';
            require_once JPATH_ADMINISTRATOR . '/components/com_menus/models/item.php';
            $obj = new MenusModelItem;
            $menuItems = array(
                'moojla_default' =>
                    array(
                        'menutype' => 'moojla_default',
                        'title' => 'moojla_course_search',
                        'type' => 'component',
                        'link' => 'index.php?option=com_moojla&view=course_search',
                        'language' => '*',
                        'published' => 1,
                        'level' => 1,
                        'parent_id' => 1,
                        'access' => 1,
                        'client_id' => 0
                    )
            );

          

            foreach ($menuItems as $key => &$menuItem) {
                if ($key == 'moojla_default') {
                    $menuItem['component_id'] = $moojla_component_id;
                }

                $obj->save($menuItem);

            }


        }
/***[/JCBGUI$$$$]***/

			echo '<a target="_blank" href="http://Lmskaran.com" title="Moojla">
				<img src="components/com_moojla/assets/images/vdm-component.png"/>
				</a>
				<h3>Upgrade to Version 1.0.77 Was Successful! Let us know if anything is not working as expected.</h3>';
		}
		return true;
	}

	/**
	 * Remove folders with files
	 * 
	 * @param   string   $dir     The path to folder to remove
	 * @param   boolean  $ignore  The folders and files to ignore and not remove
	 *
	 * @return  boolean   True in all is removed
	 * 
	 */
	protected function removeFolder($dir, $ignore = false)
	{
		if (Folder::exists($dir))
		{
			$it = new RecursiveDirectoryIterator($dir);
			$it = new RecursiveIteratorIterator($it, RecursiveIteratorIterator::CHILD_FIRST);
			// remove ending /
			$dir = rtrim($dir, '/');
			// now loop the files & folders
			foreach ($it as $file)
			{
				if ('.' === $file->getBasename() || '..' ===  $file->getBasename()) continue;
				// set file dir
				$file_dir = $file->getPathname();
				// check if this is a dir or a file
				if ($file->isDir())
				{
					$keeper = false;
					if ($this->checkArray($ignore))
					{
						foreach ($ignore as $keep)
						{
							if (strpos($file_dir, $dir.'/'.$keep) !== false)
							{
								$keeper = true;
							}
						}
					}
					if ($keeper)
					{
						continue;
					}
					Folder::delete($file_dir);
				}
				else
				{
					$keeper = false;
					if ($this->checkArray($ignore))
					{
						foreach ($ignore as $keep)
						{
							if (strpos($file_dir, $dir.'/'.$keep) !== false)
							{
								$keeper = true;
							}
						}
					}
					if ($keeper)
					{
						continue;
					}
					File::delete($file_dir);
				}
			}
			// delete the root folder if not ignore found
			if (!$this->checkArray($ignore))
			{
				return Folder::delete($dir);
			}
			return true;
		}
		return false;
	}

	/**
	 * Check if have an array with a length
	 *
	 * @input	array   The array to check
	 *
	 * @returns bool/int  number of items in array on success
	 */
	protected function checkArray($array, $removeEmptyString = false)
	{
		if (isset($array) && is_array($array) && ($nr = count((array)$array)) > 0)
		{
			// also make sure the empty strings are removed
			if ($removeEmptyString)
			{
				foreach ($array as $key => $string)
				{
					if (empty($string))
					{
						unset($array[$key]);
					}
				}
				return $this->checkArray($array, false);
			}
			return $nr;
		}
		return false;
	}

	/**
	 * Method to set/copy dynamic folders into place (use with caution)
	 *
	 * @return void
	 */
	protected function setDynamicF0ld3rs($app, $parent)
	{
		// get the instalation path
		$installer = $parent->getParent();
		$installPath = $installer->getPath('source');
		// get all the folders
		$folders = Folder::folders($installPath);
		// check if we have folders we may want to copy
		$doNotCopy = array('media','admin','site'); // Joomla already deals with these
		if (count((array) $folders) > 1)
		{
			foreach ($folders as $folder)
			{
				// Only copy if not a standard folders
				if (!in_array($folder, $doNotCopy))
				{
					// set the source path
					$src = $installPath.'/'.$folder;
					// set the destination path
					$dest = JPATH_ROOT.'/'.$folder;
					// now try to copy the folder
					if (!Folder::copy($src, $dest, '', true))
					{
						$app->enqueueMessage('Could not copy '.$folder.' folder into place, please make sure destination is writable!', 'error');
					}
				}
			}
		}
	}
}
