<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		mteacher.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Mteacher Form Field class for the Moojla component
 */
class JFormFieldMteacher extends JFormFieldList
{
	/**
	 * The mteacher field type.
	 *
	 * @var		string
	 */
	public $type = 'mteacher';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		// Get the user object.
$role= JComponentHelper::getParams('com_moojla')->get('role');
		$user = JFactory::getUser();
		// Get the databse object.
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('a.mid','a.jid','u.name'),array('mid','teacher_jid','name')));
		$query->from($db->quoteName('#__moojla_user_map', 'a'));
	$query->join('inner',$db->quoteName('#__moojla_enrolment', 'e').' on '.$db->quoteName('a.jid').'='.$db->quoteName('e.jid'));
		$query->join('inner',$db->quoteName('#__users', 'u').' on '.$db->quoteName('a.jid').'='.$db->quoteName('u.id'));
		$query->where($db->quoteName('e.role') . ' = '.$db->quote($role));
		$query->where($db->quoteName('a.published') . ' = 1');
		$query->order('a.jid ASC');
               $query->group('a.mid');
		// Implement View Level Access (if set in table)
		if (!$user->authorise('core.options', 'com_moojla'))
		{
			$columns = $db->getTableColumns('#__moojla_user_map');
			if(isset($columns['access']))
			{
				$groups = implode(',', $user->getAuthorisedViewLevels());
				$query->where('a.access IN (' . $groups . ')');
			}
		}
		$db->setQuery((string)$query);
		$items = $db->loadObjectList();
		$options = array();
		if ($items)
		{
			foreach($items as $item)
			{
				$options[] = JHtml::_('select.option', $item->mid, $item->name);
			}
		}
		return $options;
	}
}
