<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		juserfields.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Juserfields Form Field class for the Moojla component
 */
class JFormFieldJuserfields extends JFormFieldList
{
	/**
	 * The juserfields field type.
	 *
	 * @var		string
	 */
	public $type = 'juserfields';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		// Get the user object.
		$user = JFactory::getUser();
		// Get the databse object.
		$params = JComponentHelper::getParams('com_moojla');
		$ads = trim($params->get('additional_data_source'));
		switch($ads)
		{
			case "jf":
				$db = JFactory::getDBO();
				$query = $db->getQuery(true);
				$query->select($db->quoteName(array('a.id','a.name'),array('id','juserfields_name')));
				$query->from($db->quoteName('#__fields', 'a'));
				$query->where($db->quoteName('a.state') . ' = 1');
				$query->where($db->quoteName('a.context') . ' = "com_users.user"');
				$query->order('a.name ASC');
				// Implement View Level Access (if set in table)
				if (!$user->authorise('core.options', 'com_moojla'))
				{
					$columns = $db->getTableColumns('#__fields');
					if(isset($columns['access']))
					{
						$groups = implode(',', $user->getAuthorisedViewLevels());
						$query->where('a.access IN (' . $groups . ')');
					}
				}
				$db->setQuery((string)$query);
				$items = $db->loadObjectList();
				foreach($items as $index => $item)
				{
					$items[$index]->id = 'jf_'.$item->juserfields_name;
				}
        		break;
				case "cb":
				$db = JFactory::getDBO();
				$query = $db->getQuery(true);
				$sql = "DESC #__comprofiler";
				$db->setQuery($sql);
				$items = $db->loadObjectList();
				foreach($items as $index => $item)
				{
					$obj = new stdClass();
					$obj->id = 'cb_'.$item->Field;
					$obj->juserfields_name = $item->Field;
					$items[$index] = $obj;
				}
			break;
		}

		$standardFields = ['name', 'email', 'groups'];
		foreach($standardFields as $index => $sf)
		{
			$obj = new stdClass();
			$obj->id = 'sj_'.$sf;
			$obj->juserfields_name = $sf;
			$items[] = $obj;
		}

		$options = array();
		if ($items)
		{
			$options[] = JHtml::_('select.option', '', 'Select an option');
			foreach($items as $item)
			{
				$options[] = JHtml::_('select.option', $item->id, $item->juserfields_name);
			}
		}
		return $options;
	}
}
