<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		ajax.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Moojla Ajax Model
 */
class MoojlaModelAjax extends JModelList
{
	protected $app_params;
	
	public function __construct() 
	{		
		parent::__construct();		
		// get params
		$this->app_params	= JComponentHelper::getParams('com_moojla');
		
	}

	// Used in course

/***[JCBGUI.admin_view.php_ajaxmethod.129.$$$$]***/
public function shop_requirement($shop_name)
{
    $shop_integration = $shop_name;
    $res= [];
    if ($shop_integration == 'hk') {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        $query->select('extension_id, enabled, name');
        $query->from($db->quoteName('#__extensions'));
        $query->where('(' . $db->quoteName('folder') . '=' . $db->quote('editors-xtd') . ' and ' . $db->quoteName('element') . '=' . $db->quote('hikashopproduct') . ') or (' . $db->quoteName('folder') . '=' . $db->quote('system') . ' and ' . $db->quoteName('element') . '=' . $db->quote('hikashopproductinsert') . ')');

        $db->setQuery($query);
        $results = $db->loadObjectList('name');

        $required_plugins = ['Hikashop product tag insertion plugin', 'HikaShop product tag translation plugin'];

        foreach ($required_plugins as $required_plugin) {

            if ($results[$required_plugin]) {
                if ($results[$required_plugin]->enabled == 1)
                    $res['messages'][]=['message'=> $results[$required_plugin]->name . ' is installed and enabled', 'class'=>'success'];
                else
                    $res['messages'][]=['message'=> $results[$required_plugin]->name . ' is installed but not enabled', 'class'=>'error'];
            } else
                $res['messages'][]=['message'=> $results[$required_plugin]->name . ' is not installed', 'class'=>'error'];
        }
        $res['component']= 'hikashop';
        return $res;
    }
  
}/***[/JCBGUI$$$$]***/


	// Used in user_map

/***[JCBGUI.admin_view.php_ajaxmethod.130.$$$$]***/
  public function userbatch($users, $group, $op)
  {

    foreach($users as $user)
    {
      $user = JFactory::getUser(intval($user));
      $set_group = array();
      foreach($group as $gp)
      {
        switch($op[0])
        {
          case 'add':
            if(!in_array($gp, $user->groups))
            {
              $user->groups[] = intval($gp);
            }
            break;
          case 'del':
            if (($key = array_search($gp, $user->groups)) !== false) {
              unset($user->groups[$key]);
            }
            break;
          case 'set':
            if(!in_array($gp, $set_group))
            {
              $set_group[] = $gp;
            }
            $user->groups = $set_group;
            break;
        }
      }
      $user->save();
    }

    return array(
      'staus'	=>	true
    );
    // return array(
    // 'users'	=>	$users,
    // 'group'	=>	$group,
    // 'op'	=>	$op,
    // );
  }/***[/JCBGUI$$$$]***/


	// Used in user_field_map

/***[JCBGUI.admin_view.php_ajaxmethod.134.$$$$]***/
  public function addMapperRows($ads)
  {
    JLoader::register('MoojlaModelUser_field_map', JPATH_ADMINISTRATOR.'/components/com_moojla/models/user_field_map.php');
    JLoader::register('MoojlaModelUser_fields_map', JPATH_ADMINISTRATOR.'/components/com_moojla/models/user_fields_map.php');
    JLoader::register('MoojlaTableUser_field_map', JPATH_ADMINISTRATOR.'/components/com_moojla/tables/user_fields_map.php');
    $ufsmModel = new MoojlaModelUser_fields_map;
    $mappings = $ufsmModel->getItems();
    foreach($mappings as $map)
    {
      $ufmModel = new MoojlaModelUser_field_map;
      $pk = array($map->id);
      $ufmModel->publish($pk, -2);
      $ufmModel->delete($pk);
    }
    if($ads == 'cb')
    {
      $firstnameMapArray = array(
        'juserfields'		=>	'cb_firstname',
        'muserfields'		=>	'sm_firstname'
      );
      $lastnameMapArray = array(
        'juserfields'		=>	'cb_lastname',
        'muserfields'		=>	'sm_lastname'
      );

      
      $ufmModel = new MoojlaModelUser_field_map;
      $ufmModel->save($firstnameMapArray);
      $ufmModel = new MoojlaModelUser_field_map;
      $ufmModel->save($lastnameMapArray);
      
    }
    $emailMapArray = array(
      'juserfields'		=>	'sj_email',
      'muserfields'		=>	'sm_email'
    );
    $ufmModel = new MoojlaModelUser_field_map;
    $ufmModel->save($emailMapArray);
    return array();
  }
/***[/JCBGUI$$$$]***/

}
