<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		courses.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Courses Controller
 */
class MoojlaControllerCourses extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_MOOJLA_COURSES';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Course', $prefix = 'MoojlaModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	public function exportData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if export is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('course.export', 'com_moojla') && $user->authorise('core.export', 'com_moojla'))
		{
			// Get the input
			$input = JFactory::getApplication()->input;
			$pks = $input->post->get('cid', array(), 'array');
			// Sanitize the input
			$pks = ArrayHelper::toInteger($pks);
			// Get the model
			$model = $this->getModel('Courses');
			// get the data to export
			$data = $model->getExportData($pks);
			if (MoojlaHelper::checkArray($data))
			{
				// now set the data to the spreadsheet
				$date = JFactory::getDate();
				MoojlaHelper::xls($data,'Courses_'.$date->format('jS_F_Y'),'Courses exported ('.$date->format('jS F, Y').')','courses');
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_MOOJLA_EXPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_moojla&view=courses', false), $message, 'error');
		return;
	}


	public function importData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if import is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('course.import', 'com_moojla') && $user->authorise('core.import', 'com_moojla'))
		{
			// Get the import model
			$model = $this->getModel('Courses');
			// get the headers to import
			$headers = $model->getExImPortHeaders();
			if (MoojlaHelper::checkObject($headers))
			{
				// Load headers to session.
				$session = JFactory::getSession();
				$headers = json_encode($headers);
				$session->set('course_VDM_IMPORTHEADERS', $headers);
				$session->set('backto_VDM_IMPORT', 'courses');
				$session->set('dataType_VDM_IMPORTINTO', 'course');
				// Redirect to import view.
				$message = JText::_('COM_MOOJLA_IMPORT_SELECT_FILE_FOR_COURSES');
				$this->setRedirect(JRoute::_('index.php?option=com_moojla&view=import', false), $message);
				return;
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_MOOJLA_IMPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_moojla&view=courses', false), $message, 'error');
		return;
	}


/***[JCBGUI.admin_view.php_controller_list.129.$$$$]***/
  function uni2persian($uni_str) 
  {
    //strpos
    preg_match_all('/\\\u[[:xdigit:]]{4}/', $uni_str, $matches);
    if(isset($matches[0]) && $matches)
    {
      foreach($matches[0] as $word)
      {
        $p = strpos($uni_str, $word);
        $new="&#x".substr($uni_str,$p+2,4).";"; 
        $txt = html_entity_decode("$new", ENT_COMPAT, "UTF-8");
        $uni_str = str_replace($word, $txt, $uni_str);
      }
    }

    return $uni_str;
  }




  function fetchCourses()
  {
    require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/course.php";
    JLoader::register('MoojlaHelper', JPATH_ADMINISTRATOR.'/components/com_moojla/helpers/moojla.php');

    $user = JFactory::getUser();

    $dataObj = array(
      "wsfunction"          => "moojla_get_course_categories",
      "moodlewsrestformat"  => "json",
    );
    $course_cats = json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response);
    $catidmap = array();
    foreach($course_cats as $cc)
    {
      if($cc->depth == 1)
      {
        $parent_name = '';
      }
      else
      {
        $path = ltrim($cc->path, '/');
        $path = explode('/', $path);
        $mparent_id = $path[$cc->depth - 2];

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query
          ->select(array('c.title'))
          ->from($db->quoteName('#__moojla_category_map', 'cm'))
          ->join('INNER', $db->quoteName('#__categories', 'c') . ' ON ' . $db->quoteName('c.id') . ' = ' . $db->quoteName('cm.jcatid'))
          ->where($db->quoteName('c.extension') . ' = ' . $db->quote('com_moojla.course'))
          ->where($db->quoteName('cm.mcatid') . ' = ' . $db->quote($mparent_id))
          ->where($db->quoteName('cm.published') . ' = 1');
        $db->setQuery($query);
        $parent_name = $db->loadResult();
      }
      JPluginHelper::importPlugin("moojlaevents");
      $dispatcher = JEventDispatcher::getInstance();
      $args = array($cc->name, $cc->id, $parent_name, $cc->description);
      $catidmap[$cc->id] = $dispatcher->trigger("createMoojlaCategory", $args)[0];

    }

    $dataObj = array(
      "wsfunction"          => "moojla_get_courses",
      "moodlewsrestformat"  => "json",
    );
    $coursesReq = MoojlaHelper::sendRequestToMoodle($dataObj);
    $courses = json_decode($coursesReq->response);

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('id, remoteid');
    $query->from($db->quoteName('#__moojla_course'));
    $db->setQuery($query);
    $moojla_courses = $db->loadObjectList('remoteid');
    $courses = array_filter($courses, function($v) use(&$moojla_courses){
      return empty($moojla_courses[$v->id]);
    });
    // dump(array_values($courses),'the courses that to be saved');

    $check = true;
    if(is_object($courses))
    {
      if(property_exists($courses, 'exception') && $courses->exception)
        $check = false;
    }

    if ($check) {
      $updateCount = 0;
      $createCount = 0;
      $sample_size = count($courses);
      $chunk_size = 10;


      foreach ($courses as $c) {
        if (!trim($c->shortname))
          continue;

        $course = array();
        $course["shortname"] = stripslashes($c->shortname);
        $course["fullname"] = stripslashes($c->fullname);
        $course["cat_name"] = stripslashes($c->categoryname);
        $course["cat_id"] = stripslashes($c->categoryid);
        $course["summary"] = stripslashes($this->uni2persian(stripslashes($c->summary)));
        $course["summary_files"] = stripslashes($this->uni2persian(stripslashes($c->imgurl)));
        $course["teachers"] = $this->uni2persian(stripslashes(json_encode($c->teachers)));
        $course["startdate"] = $c->startdate;
        $course["endtdate"] = property_exists($c, 'endtdate') ? $c->endtdate : 0;
        $course["in_enrol_date"] = $c->in_enrol_date;
        $course["self_enrolment"] = $c->self_enrolment;
        $course["remoteid"] = $c->id;
        $course["currency"] = $c->currency;
        $course["cost"] = $c->cost;
        $course["created_by"] = $user->id;
        $course["guest"] = $c->guest;
        $course["catid"] = $catidmap[$course["cat_id"]];

        /*$db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->quoteName(array('id', 'permanent_fields')))
          ->from($db->quoteName('#__moojla_course'))
          ->where($db->quoteName('remoteid') . ' = ' . $db->quote($course["remoteid"]));
        $db->setQuery($query);
        $result = $db->loadAssocList();*/

        /*if (current($result)["id"]) {
          $course["id"] = current($result)["id"]; // for update rows
          if (current($result)["permanent_fields"] != "") {
            $permanent_fields = json_decode(current($result)["permanent_fields"], true);
            foreach ($permanent_fields as $field) {
              unset($course[$field]);
            }
            $course["permanent_fields"] = current($result)["permanent_fields"];
          }
          $updateCount += 1;
        } else {*/
          $createCount += 1;
        /*}*/

        $courseModel = new MoojlaModelCourse;
        $courseModel->save($course);

        $customfields = $c->customfields;

        $cfs = array();
        foreach ($customfields as $index => $cf) {
          $cfs['cm_' . $cf->shortname] = $cf->value;
        }

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query
          ->select(array('cf.coursefield', 'cf.mcoursefields', 'f.name'))
          ->from($db->quoteName('#__moojla_course_field_mapper', 'cf'))
          ->join('INNER', $db->quoteName('#__fields', 'f') . ' ON ' . $db->quoteName('f.id') . ' = ' . $db->quoteName('cf.coursefield'))
          ->where($db->quoteName('f.context') . ' = ' . $db->quote('com_moojla.course'))
          ->where($db->quoteName('cf.published') . ' = 1');
        $db->setQuery($query);
        $mappings = $db->loadRowList(1);

        $itemId = $courseModel->getItem()->id;

        foreach ($mappings as $index => $mapping) {
          $fieldId = $mapping[0];
          $value = $cfs[$index];
          define('JPATH_COMPONENT', JPATH_ADMINISTRATOR);
          $courseModel->setFieldValue($fieldId, $itemId, $value);
        }

        $params = JComponentHelper::getParams('com_moojla');
        $fetch_course_contents = $params->get('fetch_course_contents', 0);

        if ($fetch_course_contents == 1) {
          $dataObj = array(
            "wsfunction" => "moojla_get_course_contents",
            "moodlewsrestformat" => "json",
            "courseid" => $course["remoteid"]
          );
          $sections = json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response);
          MoojlaHelper::updateCourseContents($sections, $course["remoteid"]);
        }

      }

 
      $app = JFactory::getApplication();
      $message = JText::_('COM_MOOJLA_COM_MOOJLA_COMPLETELY_FETCHED'); // translate_need
      if ($updateCount != 0) {
        $message .= '<br>' . $updateCount . ' ' . JText::_('COM_MOOJLA_COM_MOOJLA_COURSES_UPDATED'); // translate_need
      }
      if ($createCount != 0) {
        $message .= '<br>' . $createCount . ' ' . JText::_('COM_MOOJLA_COM_MOOJLA_COURSES_CREATED'); // translate_need
      }

    }
    else {
      $app = JFactory::getApplication();
      $message = JText::_('COM_MOOJLA_COM_MOOJLA_FETCHING_ERROR'); // translate_need
      $message .= '<br>' . $courses->exception;
      $message .= '<br>' . $courses->errorcode;
      $app->redirect(JRoute::_("index.php?option=com_moojla&view=courses", false), $message, 'error');
      return false;
    }


    $app->redirect(JRoute::_("index.php?option=com_moojla&view=courses", false), $message, 'message');
    return true;
  }



  function updateCourse()
  {
    require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/course.php";
    JLoader::register('MoojlaHelper', JPATH_ADMINISTRATOR.'/components/com_moojla/helpers/moojla.php');
    $cid = $this->input->get('cid', array(), 'array');
    $cid = ArrayHelper::toInteger($cid);

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('remoteid')));
    $query->from($db->quoteName('#__moojla_course'));
    $query->where($db->quoteName('id') . ' IN (' . implode(',', $cid ) . ')');
    $db->setQuery($query);
    $results = $db->loadColumn();


    $dataObj = array(
      "wsfunction"          => "moojla_get_courses",
      "moodlewsrestformat"  => "json",
      "options"				=> array(
        "ids"				=> $results
      )
    );
    $coursesReq = MoojlaHelper::sendRequestToMoodle($dataObj);
    $courses = json_decode($coursesReq->response);
    if(!$courses->exception)
    {
      $updateCount = 0;
      $user = JFactory::getUser();
      foreach($courses as $index => $c)
      {
        if(!trim($c->shortname))
          continue;

        $course = array();
        $course["shortname"]		= stripslashes($c->shortname);
        $course["fullname"]			= stripslashes($c->fullname);
        $course["cat_name"]			= stripslashes($c->categoryname);
        $course["cat_id"]			= stripslashes($c->categoryid);
        $course["summary"]			= stripslashes($this->uni2persian(stripslashes($c->summary)));
        $course["summary_files"]	= stripslashes($this->uni2persian(stripslashes($c->imgurl)));
        $course["teachers"]			= $this->uni2persian(stripslashes(json_encode($c->teachers)));
        $course["startdate"]		= $c->startdate;
        $course["endtdate"]			= $c->endtdate;
        $course["in_enrol_date"]	= $c->in_enrol_date;
        $course["self_enrolment"]	= $c->self_enrolment;
        $course["remoteid"]			= $c->id;
        $course["currency"]			= $c->currency;
        $course["cost"]				= $c->cost;
        $course["created_by"]		= $user->id;
        $course["guest"]			= $c->guest;
        $course["published"]		= $c->visible;

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->quoteName(array('id', 'permanent_fields')))
          ->from($db->quoteName('#__moojla_course'))
          ->where($db->quoteName('remoteid') . ' = ' . $db->quote($course["remoteid"]));
        $db->setQuery($query);
        $result = $db->loadAssocList();

        if(current($result)["id"])
        {
          $course["id"] = current($result)["id"]; // for update rows
          if(current($result)["permanent_fields"] != "")
          {
            $permanent_fields = json_decode(current($result)["permanent_fields"], true);
            foreach($permanent_fields as $field)
            {
              unset($course[$field]);
            }
            $course["permanent_fields"] = current($result)["permanent_fields"];
          }
          $updateCount += 1;
        }
        else
        {
          $createCount += 1;
        }

        $courseModel = new MoojlaModelCourse;
        $courseModel->save($course);

        $customfields = $c->customfields;

        $cfs = array();
        foreach($customfields as $index => $cf)
        {
          $cfs['cm_' . $cf->shortname] = $cf->value;
        }

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query
          ->select(array('cf.coursefield', 'cf.mcoursefields', 'f.name'))
          ->from($db->quoteName('#__moojla_course_field_mapper', 'cf'))
          ->join('INNER', $db->quoteName('#__fields', 'f') . ' ON ' . $db->quoteName('f.id') . ' = ' . $db->quoteName('cf.coursefield'))
          ->where($db->quoteName('f.context') . ' = ' . $db->quote('com_moojla.course'))
          ->where($db->quoteName('cf.published') . ' = 1');
        $db->setQuery($query);
        $mappings = $db->loadRowList(1);

        // $itemId = $courseModel->getItem()->id;
        $itemId = current($result)["id"];

        foreach($mappings as $index => $mapping)
        {
          $fieldId	=	$mapping[0];
          $value		=	$cfs[$index];
          define('JPATH_COMPONENT', JPATH_ADMINISTRATOR);
          $courseModel->setFieldValue($fieldId, $itemId, $value);
        }

        $params = JComponentHelper::getParams('com_moojla');
        $fetch_course_contents= $params->get('fetch_course_contents', 0);

        if($fetch_course_contents == 1)
        {
          $dataObj = array(
            "wsfunction"          	=> "moojla_get_course_contents",
            "moodlewsrestformat"  	=> "json",
            "courseid"				=> $course["remoteid"]
          );
          $sections = json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response);
          //dump($sections, "sections");
          MoojlaHelper::updateCourseContents($sections, $course["remoteid"]);
        }
      }
      $message = JText::_('COM_MOOJLA_COM_MOOJLA_COMPLETELY_FETCHED'); // translate_need
      if($updateCount != 0)
      {
        $message .= '<br>' . $updateCount . ' ' . JText::_('COM_MOOJLA_COM_MOOJLA_COURSES_UPDATED'); // translate_need
      }
      if($createCount != 0)
      {
        $message .= '<br>' . $createCount . ' ' . JText::_('COM_MOOJLA_COM_MOOJLA_COURSES_CREATED'); // translate_need
      }
      // dump($courses, "courses");
    }
    else
    {
      $app = JFactory::getApplication();
      $message = JText::_('COM_MOOJLA_COM_MOOJLA_FETCHING_ERROR'); // translate_need
      $message .= '<br>' . $courses->exception;
      $message .= '<br>' . $courses->errorcode;
      $app->redirect(JRoute::_("index.php?option=com_moojla&view=courses", false), $message, 'error');
      return false;
    }



    $app = JFactory::getApplication();
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=courses", false), $message, 'message');
    return true;
  }

  function goToSections()
  {
    $app = JFactory::getApplication();
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=sections", false));
    return true;
  }
  function goToModules()
  {
    $app = JFactory::getApplication();
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=modules", false));
    return true;
  }
  function goToContents()
  {
    $app = JFactory::getApplication();
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=contents", false));
    return true;
  }

  function syncTags()
  {
    require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/tag_instance.php";
    require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/tag.php";
    require_once JPATH_ADMINISTRATOR . "/components/com_tags/models/tag.php";
    require_once JPATH_ADMINISTRATOR . "/components/com_tags/tables/tag.php";


    JLoader::register('MoojlaHelper', JPATH_ADMINISTRATOR.'/components/com_moojla/helpers/moojla.php');
    $cid = $this->input->get('cid', array(), 'array');
    $cid = ArrayHelper::toInteger($cid);
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('remoteid')));
    $query->from($db->quoteName('#__moojla_course'));
    $query->where($db->quoteName('id') . ' IN (' . implode(',', $cid ) . ')');
    $db->setQuery($query);
    $remoteids = $db->loadColumn();

    $dataObj = array(
      "wsfunction"          => "moojla_get_course_tags",
      "moodlewsrestformat"  => "json",
    );
    foreach($remoteids as $id)
    {
      $dataObj['courseids'][] = array('id' => $id);
    }



    // dump($dataObj, "dataObj");
    $coursesReq = MoojlaHelper::sendRequestToMoodle($dataObj);
    $tags = json_decode($coursesReq->response);

    $unique_tags = array();
    $unique_tags_id = array();
    foreach($tags as $tag)
    {
      if(!in_array(array('tagid' => $tag->tagid, 'tagname' => $tag->tagname, 'isstandard' => $tag->isstandard), $unique_tags))
      {
        $unique_tags[] = array('tagid' => $tag->tagid, 'tagname' => $tag->tagname, 'isstandard' => $tag->isstandard);
        $unique_tags_id[] = $tag->tagid;
      }
    }
    $tag_row_ids = array();

    if(!empty($unique_tags_id))
    {
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select($db->quoteName(array('id', 'tagid','tagname')));
      $query->from($db->quoteName('#__moojla_tag'));
      $query->where($db->quoteName('tagid') . ' IN (' . implode(',', $unique_tags_id ) . ')');
      $db->setQuery($query);
      $tag_row_ids = $db->loadAssocList('tagid');
    }

    foreach($unique_tags as $ut)
    {
      $tagObj = array();
      $tagObj["tagid"] = $ut['tagid'];
      $tagObj["tagname"] = $ut['tagname'];
      $tagObj["isstandard"] = $ut['isstandard'];
      if(isset($tag_row_ids[$ut['tagid']]))
      {
        $tagObj["id"] = $tag_row_ids[$ut['tagid']]['id'];

        if($ut['tagname'] != $tag_row_ids[$ut['tagid']]['tagname'])
        {
          $db= JFactory::getDbo();
          $query= $db->getQuery(true)
            ->select($db->quoteName('id'))
            ->from($db->quoteName('#__tags',''))
            ->where($db->quoteName('title').'='.$db->quote($tag_row_ids[$ut['tagid']]['tagname']));

          $db->setQuery($query);
          $result= $db->loadObject();

          $tagModel= new TagsModelTag;
          $tagModel->save(['title'=>$ut['tagname'],'alias'=>$ut['tagname'],'id'=>$result->id]);

        }

      }

      $tagModel = new MoojlaModelTag();
      $tagModel->save($tagObj);

    }
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('id', 'moojlacourse', 'moodletag')));
    $query->from($db->quoteName('#__moojla_tag_instance'));
    $query->where($db->quoteName('moojlacourse') . ' IN (' . implode(',', $remoteids ) . ')');
    $db->setQuery($query);
    $tag_instances = $db->loadAssocList();
    

    foreach($tags as $tag)
    {
      $tagins = array();
      foreach($tag_instances as $ti)
      {
        if($ti['moodletag'] == $tag->tagid && $ti['moojlacourse'] == $tag->courseid)
        {
          $tagins['id'] = $ti['id'];
          break;
        }
      }
      $tagins['moodletag'] = $tag->tagid;
      $tagins['moojlacourse'] = $tag->courseid;
      $tagincModel = new MoojlaModelTag_instance();
      if(!$tagincModel->save($tagins))
      {
        //dump($tagincModel->getError(), "error");
      } 
    }
    $app = JFactory::getApplication();
    $message .= 'tag fetched'; // need translate
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=courses", false), $message, 'success');
  }

  function fetchQuizAttempts()
  {
    $quizType = $this->input->get('quizType', '', 'string');
    $cids = $this->input->get('quizzes_list', array(), 'array');
    $cids = ArrayHelper::toInteger($cids);
    $finalres = array();
    foreach($cids as $cid)
    {
      $dataObj = array(
        "wsfunction"          =>	"get_{$quizType}_result",
        "moodlewsrestformat"  =>	"json",
        "quizid"							=>	$cid
      );
      // print_r($dataObj);
      $results = json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response);
      // print_r($results);
      foreach($results as $result)
      {
        JPluginHelper::importPlugin("moojlaquiz");
        $dispatcher = JEventDispatcher::getInstance();
        $dispatcher->trigger("addQuizAttempt", array($quizType, $result, $cid));
      }
      $finalres[]  = $results;
    }

    echo json_encode($finalres);
    die();
  }

  function getCalendarEvents()
  {
    $json = '[{"title": "جشن تولد","start": "2021-03-13T07:00:00"},{"title": "کلیک برای باز کردن گوگل","url": "http://google.com/","start": "2021-03-28"}]';
    echo $json;
    die();
  }

  function migrateFromJoomdle()
  {
    require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/course.php";
    JLoader::register('MoojlaHelper', JPATH_ADMINISTRATOR.'/components/com_moojla/helpers/moojla.php');
    $cid = $this->input->get('cid', array(), 'array');
    $cid = ArrayHelper::toInteger($cid);


    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('remoteid')));
    $query->from($db->quoteName('#__moojla_course'));
    $query->where($db->quoteName('id') . ' IN (' . implode(',', $cid ) . ')');
    $db->setQuery($query);
    $remoteids = $db->loadColumn();
    $counter = 0;
    foreach($remoteids as $remoteid)
    {
      $dataObj = array(
        "wsfunction"          =>	"moojla_migrate_enrolment_method",
        "moodlewsrestformat"  =>	"json",
        "courseid"						=>	$remoteid
      );
      $results = json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response);
      if($results->status)
        $counter += 1;
    }
    $message = JText::sprintf('COM_MOOJLA_S_COURSES_MIGRATED_SUCCESSFULLY', $counter);
    $app = JFactory::getApplication();
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=courses", false), $message, 'message');

  }

  function fetchMoojlaEnrolment()
  {
    $cid = $this->input->get('cid', array(), 'array');
    $cid = ArrayHelper::toInteger($cid);

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('remoteid')));
    $query->from($db->quoteName('#__moojla_course'));
    $query->where($db->quoteName('id') . ' IN (' . implode(',', $cid ) . ')');
    $db->setQuery($query);
    $remoteids = $db->loadColumn();

    $ids = array();
    foreach($remoteids as $remoteid)
    {
      $ids[] = ['id' => $remoteid];
    }

    $dataObj = array(
      "wsfunction"          =>	"moojla_trigger_update_enrolment_method",
      "moodlewsrestformat"  =>	"json",
      "courseids"						=>	$ids
    );

    $results = json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response, true);
    $outputs = array_column($results, 'status');
    $updated = array_sum($outputs);
    $app = JFactory::getApplication();
    $message = "";
    $message .= $updated;
    $message .= ' enrolment method fetched'; // need translate
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=courses", false), $message, 'success');
  }
/***[/JCBGUI$$$$]***/

}
