<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		course_fields_mapper.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Course_fields_mapper Controller
 */
class MoojlaControllerCourse_fields_mapper extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_MOOJLA_COURSE_FIELDS_MAPPER';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Course_field_mapper', $prefix = 'MoojlaModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	public function exportData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if export is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('course_field_mapper.export', 'com_moojla') && $user->authorise('core.export', 'com_moojla'))
		{
			// Get the input
			$input = JFactory::getApplication()->input;
			$pks = $input->post->get('cid', array(), 'array');
			// Sanitize the input
			$pks = ArrayHelper::toInteger($pks);
			// Get the model
			$model = $this->getModel('Course_fields_mapper');
			// get the data to export
			$data = $model->getExportData($pks);
			if (MoojlaHelper::checkArray($data))
			{
				// now set the data to the spreadsheet
				$date = JFactory::getDate();
				MoojlaHelper::xls($data,'Course_fields_mapper_'.$date->format('jS_F_Y'),'Course fields mapper exported ('.$date->format('jS F, Y').')','course fields mapper');
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_MOOJLA_EXPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_moojla&view=course_fields_mapper', false), $message, 'error');
		return;
	}


	public function importData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if import is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('course_field_mapper.import', 'com_moojla') && $user->authorise('core.import', 'com_moojla'))
		{
			// Get the import model
			$model = $this->getModel('Course_fields_mapper');
			// get the headers to import
			$headers = $model->getExImPortHeaders();
			if (MoojlaHelper::checkObject($headers))
			{
				// Load headers to session.
				$session = JFactory::getSession();
				$headers = json_encode($headers);
				$session->set('course_field_mapper_VDM_IMPORTHEADERS', $headers);
				$session->set('backto_VDM_IMPORT', 'course_fields_mapper');
				$session->set('dataType_VDM_IMPORTINTO', 'course_field_mapper');
				// Redirect to import view.
				$message = JText::_('COM_MOOJLA_IMPORT_SELECT_FILE_FOR_COURSE_FIELDS_MAPPER');
				$this->setRedirect(JRoute::_('index.php?option=com_moojla&view=import', false), $message);
				return;
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_MOOJLA_IMPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_moojla&view=course_fields_mapper', false), $message, 'error');
		return;
	}
}
