<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$params = JComponentHelper::getParams( 'com_invoices' );

?>

<div v-pre>

  <div class="well well-small ">
    <h4><?php echo JText::_('TEXT_LABELS_VUE'); ?></h4>
    <?php echo JText::_('TEXT_LABELS_EXPLANATION_VUE'); ?>
  </div>

  <div class="row">
    <div class="col-md-6">

      <div class="well well-small ">
        <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?></h4>
        <?php echo JText::_('TOKENS_EXPLANATION'); ?>
        <hr>
        <strong>{company_logo}</strong> <span class="item_desc"><?php echo JText::_('THE_COMPANY_LOGO'); ?></span><br />
        <strong>{{ invoice.from_name }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_NAME'); ?></span><br />
        <strong>{{ invoice.from_address }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_ADDRESS'); ?></span><br />
        <strong>{{ invoice.from_num }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_FISCAL_NUMBER'); ?></span><br />
        <strong>{{ invoice.from_phone }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_PHONE_NUMBER'); ?></span><br />
        <strong>{{ invoice.from_url }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_URL'); ?></span><br />
        <strong>{{ invoice.from_email }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_EMAIL'); ?></span><br />
        <strong>{{ invoice.to_name }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_NAME'); ?></span><br />
        <strong>{{ invoice.to_company }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_COMPANY'); ?></span><br />
        <strong>{{ invoice.to_email }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_EMAIL'); ?></span><br />
        <strong>{{ invoice.to_address }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_ADDRESS'); ?></span><br />
        <strong>{{ invoice.to_zipcode }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_ZIPCODE'); ?></span><br />
        <strong>{{ invoice.to_city }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_CITY'); ?></span><br />
        <strong>{{ invoice.to_state }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_STATE'); ?></span><br />
        <strong>{{ invoice.to_country }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_COUNTRY'); ?></span><br />
        <strong>{{ invoice.to_vatid }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_VATID'); ?></span><br />
        <strong>{{ invoice.to_phone }}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_PHONE'); ?></span><br />
        <strong>{{ invoice.invoice_date }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_DATE'); ?></span><br />
        <strong>{{ invoice.invoice_duedate }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_DUEDATE'); ?></span><br />
        <strong>{{ invoice.invoice_num }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_NUMBER'); ?></span><br />
        <strong>{{ invoice.notes }}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_NOTES'); ?></span><br />

        <strong>{{ invoice.external_ref }}</strong> <span class="item_desc"><?php echo JText::_('EXTERNAL_REF'); ?></span><br />

        <strong>{{ invoice.discount }}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_DISCOUNT'); ?></span><br />
        <strong>{{ invoice.subtotal() }}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL'); ?></span><br />

        <strong>{{ invoice.thetotal() }}</strong> <span class="item_desc"><?php echo JText::_('TOTAL'); ?></span><br />

        <strong>{{ total_payments }}</strong> <span class="item_desc"><?php echo JText::_('TEMPLATE_AMOUNT_PAID'); ?></span><br />
        <strong>{{ invoice.total_unpaid }}</strong> <span class="item_desc"><?php echo JText::_('TEMPLATE_AMOUNT_LEFT'); ?></span><br />
        <strong>{{ status_name }}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_STATUS'); ?></span><br />
        <strong>{{ invoice.invoice_link }}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_LINK'); ?></span><br />
        <strong>{{ invoice.invoice_unlogged_link }}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_UNLOGGED_LINK'); ?></span><br />

        <strong>{{ invoice.subtotal_items() }}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL_ITEMS'); ?></span><br />
        <strong>{{ total_items_tax }}</strong> <span class="item_desc"><?php echo JText::_('TOTAL_ITEMS_TAX'); ?></span><br />
        <strong>{{ subtotal_items_no_discount }}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL_ITEMS_NO_DISCOUNT'); ?></span><br />
        <strong>{{ subtotal_items_less_total_discount }}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL_ITEMS_LESS_TOTAL_DISCOUNT'); ?></span><br />
        <strong>{{ total_items_discount }}</strong> <span class="item_desc"><?php echo JText::_('TOTAL_ITEMS_DISCOUNT'); ?></span><br />
        <strong>{{ accept_button }}</strong> <span class="item_desc"><?php echo JText::_('ACCEPT_BUTTON'); ?></span><br />
        <strong>{{ reject_button }}</strong> <span class="item_desc"><?php echo JText::_('REJECT_BUTTON'); ?></span><br />
        <strong>{{ paynow_button }}</strong> <span class="item_desc"><?php echo JText::_('PAYNOW_BUTTON'); ?></span><br />
      </div>

    </div>
    <div class="col-md-6">

      <div class="well well-small ">
        <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('ITEMS_ITERATION_AREA'); ?></h4>
        <?php echo JText::_('ITEMS_ITERATION_AREA_EXPLANATION_VUE'); ?>
        <hr>
        <strong>{{ item.sku }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_SKU'); ?></span><br />
        <strong>{{ item.name }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_NAME'); ?></span><br />
        <strong>{{ item.desc }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_DESCRIPTION'); ?></span><br />
        <strong>{{ item.value }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_VALUE'); ?></span><br />
        <strong>{{ item.amount }}</strong> <span class="item_desc"><?php echo JText::_('THE_NUMBER_OF_TIMES'); ?></span><br />
        <strong>{{ item.discount }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_DISCOUNT'); ?></span><br />
        <strong>{{ item.tax }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TAX'); ?></span><br />
        <strong>{{ item_tax_value }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TAX_VALUE'); ?></span><br />
        <strong>{{ item_with_tax }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_WITH_TAX'); ?></span><br />
        <strong>{{ tax_name }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TAX_NAME'); ?></span><br />
        <strong>{{ item_subtotal_no_discount }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_SUBTOTAL_NO_DISCOUNT'); ?></span><br />
        <strong>{{ item_subtotal }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_SUBTOTAL'); ?></span><br />
        <strong>{{ invoice.totalItem(index) }}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TOTAL'); ?></span><br />

      </div>

      <div class="well well-small ">
        <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('TAXES_ITERATION_AREA'); ?></h4>
        <?php echo JText::_('TAXES_ITERATION_AREA_EXPLANATION'); ?>
        <hr>
        <strong>{{ tax.name }}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_NAME'); ?></span><br />
        <strong>{{ tax.value }}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_VALUE'); ?></span><br />
        <strong>{{ tax.percent_value }}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_PERCENT_VALUE'); ?></span><br />
        <strong>{{ tax.calculated_on_amount }}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_CALCULATED_ON'); ?></span><br />
      </div>

      <div class="well well-small ">
        <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('PAYMENTS_ITERATION_AREA'); ?></h4>
        <?php echo JText::_('PAYMENTS_ITERATION_AREA_EXPLANATION'); ?>
        <hr>
        <strong>{{ payment.description }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DESCRIPTION'); ?></span><br />
        <strong>{{ payment.duedate }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DUEATE'); ?></span><br />
        <strong>{{ payment.payment_datetime }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DATETIME'); ?></span><br />
        <strong>{{ payment.payment_amount }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_AMOUNT'); ?></span><br />
        <strong>{{ payment.payment_status }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_STATUS'); ?></span><br />
      </div>

      <div class="well well-small ">
        <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('PAYMENTS2_ITERATION_AREA'); ?></h4>
        <?php echo JText::_('PAYMENTS2_ITERATION_AREA_EXPLANATION'); ?>
        <hr>
        <strong>{{ payment.description }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DESCRIPTION'); ?></span><br />
        <strong>{{ payment.duedate }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DUEATE'); ?></span><br />
        <strong>{{ payment.payment_datetime }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DATETIME'); ?></span><br />
        <strong>{{ payment.payment_amount }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_AMOUNT'); ?></span><br />
        <strong>{{ payment.payment_link }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_LINK'); ?></span><br />
        <strong>{{ payment.payment_status }}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_STATUS'); ?></span><br />
      </div>

    </div>
  </div>
</div>
