<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$params = JComponentHelper::getParams( 'com_invoices' );

?>

<div class="well well-small ">
  <h4><?php echo JText::_('TEXT_LABELS'); ?></h4>
  <?php echo JText::_('TEXT_LABELS_EXPLANATION'); ?>
</div>

<div class="row">
  <div class="col-md-6">

    <div class="well well-small ">
      <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?></h4>
      <?php echo JText::_('TOKENS_EXPLANATION'); ?>
      <hr>
      <strong>{company_logo}</strong> <span class="item_desc"><?php echo JText::_('THE_COMPANY_LOGO'); ?></span><br />
      <strong>{from_name}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_NAME'); ?></span><br />
      <strong>{from_address}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_ADDRESS'); ?></span><br />
      <strong>{from_num}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_FISCAL_NUMBER'); ?></span><br />
      <strong>{from_phone}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_PHONE_NUMBER'); ?></span><br />
      <strong>{from_url}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_URL'); ?></span><br />
      <strong>{from_email}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICER_EMAIL'); ?></span><br />
      <strong>{to_name}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_NAME'); ?></span><br />
      <strong>{to_company}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_COMPANY'); ?></span><br />
      <strong>{to_email}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_EMAIL'); ?></span><br />
      <strong>{to_address}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_ADDRESS'); ?></span><br />
      <strong>{to_zipcode}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_ZIPCODE'); ?></span><br />
      <strong>{to_city}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_CITY'); ?></span><br />
      <strong>{to_state}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_STATE'); ?></span><br />
      <strong>{to_country}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_COUNTRY'); ?></span><br />
      <strong>{to_vatid}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_VATID'); ?></span><br />
      <strong>{to_phone}</strong> <span class="item_desc"><?php echo JText::_('THE_RECIPIENT_PHONE'); ?></span><br />
      <strong>{invoice_date}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_DATE'); ?></span><br />
      <strong>{invoice_duedate}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_DUEDATE'); ?></span><br />
      <strong>{invoice_num}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_NUMBER'); ?></span><br />
      <strong>{notes}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_NOTES'); ?></span><br />

      <strong>{external_ref}</strong> <span class="item_desc"><?php echo JText::_('EXTERNAL_REF'); ?></span><br />

      <strong>{discount}</strong> <span class="item_desc"><?php echo JText::_('THE_INVOICE_DISCOUNT'); ?></span><br />
      <strong>{subtotal}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL'); ?></span><br />

      <strong>{total}</strong> <span class="item_desc"><?php echo JText::_('TOTAL'); ?></span><br />

      <strong>{total_payments}</strong> <span class="item_desc"><?php echo JText::_('TEMPLATE_AMOUNT_PAID'); ?></span><br />
      <strong>{amount_outstanding}</strong> <span class="item_desc"><?php echo JText::_('TEMPLATE_AMOUNT_LEFT'); ?></span><br />
      <strong>{status}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_STATUS'); ?></span><br />
      <strong>{invoice_link}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_LINK'); ?></span><br />
      <strong>{invoice_unlogged_link}</strong> <span class="item_desc"><?php echo JText::_('INVOICE_UNLOGGED_LINK'); ?></span><br />

      <strong>{subtotal_items}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL_ITEMS'); ?></span><br />
      <strong>{total_items_tax}</strong> <span class="item_desc"><?php echo JText::_('TOTAL_ITEMS_TAX'); ?></span><br />
      <strong>{subtotal_items_no_discount}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL_ITEMS_NO_DISCOUNT'); ?></span><br />
      <strong>{subtotal_items_less_total_discount}</strong> <span class="item_desc"><?php echo JText::_('SUBTOTAL_ITEMS_LESS_TOTAL_DISCOUNT'); ?></span><br />
      <strong>{total_items_discount}</strong> <span class="item_desc"><?php echo JText::_('TOTAL_ITEMS_DISCOUNT'); ?></span><br />
      <strong>{accept_button}</strong> <span class="item_desc"><?php echo JText::_('ACCEPT_BUTTON'); ?></span><br />
      <strong>{reject_button}</strong> <span class="item_desc"><?php echo JText::_('REJECT_BUTTON'); ?></span><br />
      <strong>{paynow_button}</strong> <span class="item_desc"><?php echo JText::_('PAYNOW_BUTTON'); ?></span><br />
    </div>

  </div>
  <div class="col-md-6">

    <div class="well well-small ">
      <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('ITEMS_ITERATION_AREA'); ?></h4>
      <?php echo JText::_('ITEMS_ITERATION_AREA_EXPLANATION'); ?>
      <hr>
      <strong>{sku}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_SKU'); ?></span><br />
      <strong>{name}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_NAME'); ?></span><br />
      <strong>{desc}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_DESCRIPTION'); ?></span><br />
      <strong>{value}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_VALUE'); ?></span><br />
      <strong>{amount}</strong> <span class="item_desc"><?php echo JText::_('THE_NUMBER_OF_TIMES'); ?></span><br />
      <strong>{discount}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_DISCOUNT'); ?></span><br />
      <strong>{tax}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TAX'); ?></span><br />
      <strong>{item_tax_value}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TAX_VALUE'); ?></span><br />
      <strong>{item_with_tax}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_WITH_TAX'); ?></span><br />
      <strong>{tax_name}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TAX_NAME'); ?></span><br />
      <strong>{item_subtotal_no_discount}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_SUBTOTAL_NO_DISCOUNT'); ?></span><br />
      <strong>{item_subtotal}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_SUBTOTAL'); ?></span><br />
      <strong>{item_total}</strong> <span class="item_desc"><?php echo JText::_('THE_ITEM_TOTAL'); ?></span><br />

    </div>

    <div class="well well-small ">
      <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('TAXES_ITERATION_AREA'); ?></h4>
      <?php echo JText::_('TAXES_ITERATION_AREA_EXPLANATION'); ?>
      <hr>
      <strong>{name}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_NAME'); ?></span><br />
      <strong>{value}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_VALUE'); ?></span><br />
      <strong>{tax_value}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_PERCENT_VALUE'); ?></span><br />
      <strong>{calculated_on_amount}</strong> <span class="item_desc"><?php echo JText::_('THE_TAX_CALCULATED_ON'); ?></span><br />
    </div>

    <div class="well well-small ">
      <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('PAYMENTS_ITERATION_AREA'); ?></h4>
      <?php echo JText::_('PAYMENTS_ITERATION_AREA_EXPLANATION'); ?>
      <hr>
      <strong>{description}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DESCRIPTION'); ?></span><br />
      <strong>{duedate}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DUEATE'); ?></span><br />
      <strong>{payment_datetime}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DATETIME'); ?></span><br />
      <strong>{amount}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_AMOUNT'); ?></span><br />
      <strong>{payment_status}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_STATUS'); ?></span><br />
    </div>

    <div class="well well-small ">
      <h4><?php echo JText::_('AVAILABLE_TOKENS'); ?> - <?php echo JText::_('PAYMENTS2_ITERATION_AREA'); ?></h4>
      <?php echo JText::_('PAYMENTS2_ITERATION_AREA_EXPLANATION'); ?>
      <hr>
      <strong>{description}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DESCRIPTION'); ?></span><br />
      <strong>{duedate}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DUEATE'); ?></span><br />
      <strong>{payment_datetime}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_DATETIME'); ?></span><br />
      <strong>{amount}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_AMOUNT'); ?></span><br />
      <strong>{payment_link}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_LINK'); ?></span><br />
      <strong>{payment_status}</strong> <span class="item_desc"><?php echo JText::_('THE_PAYMENT_STATUS'); ?></span><br />
    </div>

  </div>
</div>
