<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$params = JComponentHelper::getParams( 'com_invoices' );

?>
<div class=" invoice-manager" id="im-app">
  <form action="index.php" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data" class="form-horizontal">

    <div class="row">
      <div class="col-md-6" >

        <div class="form-group">
          <label class="control-label col-md-3" for="name"> <?php echo JText::_( 'NAME' ); ?> </label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="name"
                    id="name"
                    maxlength="255"
                    v-model="template.name" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3"><?php echo JText::_( 'COMPANY_LOGO' );?> </label>
          <div class="controls col-md-9">
            <div class="input-group">
              <input class="form-control" id="attachment_file_display" type="text" readonly="readonly" value="<?php echo $this->template->company_logo;?>">
              <span class="input-group-btn">
                <button class="btn btn-default" onclick="jQuery('#attachment_file').click();" type="button"><?php echo JText::_( 'TEMPLATE_LOGO_BUTTON' ); ?></button>
              </span>
            </div>
            <input class="hidden" style="display:none" type="file" name="attachment_file" id="attachment_file" onchange="jQuery('#attachment_file_display').val(this.value)"/>
          </div>
        </div>

        <ul class="nav nav-tabs" id="myTab">
          <li class="active"><a data-toggle="tab" href="#online" @click="changeTab('online')"><?php echo JText::_( 'ONLINE_VERSION' ); ?></a></li>
          <li><a data-toggle="tab" href="#pdf" @click="changeTab('pdf')"><?php echo JText::_( 'PDF_VERSION' ); ?></a></li>
          <li><a data-toggle="tab" href="#email" @click="changeTab('email')"><?php echo JText::_( 'EMAIL_VERSION' ); ?></a></li>
        </ul>

        <?php

        echo JHtml::_('bootstrap.startPane', 'myTab', array('active' => 'online'));
        echo JHtml::_('bootstrap.addPanel', 'myTab', 'online');

        ?>

        <textarea class="form-control col-md-12"
                  name="thecontent"
                  id="thecontent"
                  cols="100"
                  rows="30"
                  v-model="template.content"></textarea>

        <?php
        echo JHtml::_('bootstrap.endPanel');
        echo JHtml::_('bootstrap.addPanel', 'myTab', 'pdf');
        ?>

        <textarea class=" form-control col-md-12"
                  name="content_pdf"
                  id="content_pdf"
                  cols="100"
                  rows="30"
                  v-model="template.content_pdf"></textarea>

        <h3><?php echo JText::_( 'STYLES' ); ?></h3>

        <textarea class=" form-control col-md-12 form-"
                  name="styles"
                  id="styles"
                  cols="200"
                  rows="40"
                  v-model="template.styles"></textarea>

        <?php
        echo JHtml::_('bootstrap.endPanel');
        echo JHtml::_('bootstrap.addPanel', 'myTab', 'email');
        ?>

        <textarea class=" form-control col-md-12"
                  name="content_email"
                  id="content_email"
                  cols="100"
                  rows="30"
                  v-model="template.content_email"></textarea>

        <?php
        echo JHtml::_('bootstrap.endPanel');
        echo JHtml::_('bootstrap.endPane', 'myTab');
        ?>

      </div>

      <div class="col-md-6">

        <div v-show="tab != 'vue'">
          <?php echo $this->loadTemplate('tokens'); ?>
        </div>

      </div>
    </div>

    <input type="hidden" name="option" value="com_invoices" />
    <input type="hidden" name="id" v-model="template.id" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="controller" value="template" />
    <input type="hidden" name="layout" value="form" />
  </form>
</div>

<script>

  var vm = {
    tab: "online",
    template: <?php echo json_encode($this->template); ?>,
  };

  new Vue({
    el: '#im-app',
    data: vm,
    methods: {
      changeTab: function(tab){
        this.tab = tab;
      }
    }

  });

</script>
