<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

$params = JComponentHelper::getParams( 'com_invoices' );
?>
<div class=" invoice-manager">
  <form action="index.php" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data" class="form-horizontal">

    <div class="form-group">
      <label class="control-label col-md-3" for="name"> <?php echo JText::_( 'NAME' ); ?></label>
      <div class="controls col-md-9">
        <input class="form-control" type="text" name="name" id="name" size="80" maxlength="250" value="<?php echo $this->tax->name;?>" />
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="type"> <?php echo JText::_( 'TYPE' ); ?></label>
      <div class="controls col-md-9">
        <select name="type" id="type" class="form-control">
          <?php
          for ($i=0, $n=count( $this->types );$i < $n; $i++)  {
            $row = &$this->types[$i];
            $selected = ""; 
            if($row == $this->tax->type) $selected = "selected";?>
            <option <?php echo $selected;?> value="<?php echo $row;?>"><?php echo JText::_($row); ?></option>
            <?php } ?>
          </select>
        </div>
      </div>
      <div class="form-group">
        <label class="control-label col-md-3" for="value"> <?php echo JText::_( 'DEFAULT_VALUE' ); ?> </label>
        <div class="controls col-md-9">
          <input class="form-control" type="text" name="value" id="value" size="6" maxlength="14" value="<?php echo $this->tax->value;?>" />
        </div>
      </div>
      <div class="form-group">
        <label class="control-label col-md-3" for="ordering"> <?php echo JText::_( 'GROUP' ); ?></label>
        <div class="controls col-md-9">

          <div class="btn-group" id="sign_group">

            <label class="btn" for="ordering_0" >1
              <input class="radio_toggle" type="radio" value="1" name="ordering" id="ordering_0" <?php if($this->tax->ordering == 1) echo "checked='checked'";?> />
            </label>
            <label class="btn" for="ordering_1">2
              <input class="radio_toggle" type="radio" value="2" name="ordering" id="ordering_1" <?php if($this->tax->ordering == 2) echo "checked='checked'";?> /> </label>

            </div>

            <span class="help-block"><?php echo JText::_( 'EXPLAIN_TAX_GROUP' ); ?></span>

          </div>
        </div>
        <div class="form-group">
          <label class="control-label col-md-3" for="calculate_on"> <?php echo JText::_( 'CALCULATE_ON' ); ?></label>
          <div class="controls col-md-9">

            <div class="btn-group" id="">

              <label class="btn" for="calculate_on_0" ><?php echo JText::_( 'BEFORE_ITEMS_TAXES' ); ?>
                <input class="radio_toggle" type="radio" value="1" name="calculate_on" id="calculate_on_0" <?php if($this->tax->calculate_on == 1) echo "checked='checked'";?> />
              </label>
              <label class="btn" for="calculate_on_1"><?php echo JText::_( 'AFTER_ITEMS_TAXES' ); ?>
                <input class="radio_toggle" type="radio" value="2" name="calculate_on" id="calculate_on_1" <?php if($this->tax->calculate_on == 2 || $this->tax->calculate_on == "") echo "checked='checked'";?> /> </label>
              </div>

              <span class="help-block"><?php echo JText::_( 'EXPLAIN_TAX_CALCULATE_ON' ); ?></span>

            </div>
          </div>
          <div class="form-group">
            <label class="control-label col-md-3" for="show_column"> <?php echo JText::_( 'SHOW_COLUMN_ON_INVOICES_LIST' ); ?> </label>
            <div class="controls col-md-9">

              <?php
              $publish = ""; 
              $unpublish = ""; 
              if($this->tax->show_column) $publish = "checked='checked'"; 
              else $unpublish = "checked='checked'"; 

              ?>

              <div class="btn-group" id="">

                <label class="btn" for="show_column_0" ><?php echo JText::_( 'JYES' ); ?>
                  <input class="radio_toggle" type="radio" value="1" name="show_column" id="show_column_0" <?php echo $publish;?> />
                </label>
                <label class="btn" for="show_column_1"><?php echo JText::_( 'JNO' ); ?>
                  <input class="radio_toggle" type="radio" value="0" name="show_column" id="show_column_1" <?php echo $unpublish;?> /> </label>

                </div>

              </div>
            </div>

            <div class="form-group">
              <label class="control-label col-md-3" for="checked"> <?php echo JText::_( 'TAX_CHECKED' ); ?> </label>
              <div class="controls col-md-9">

                <?php
                $publish = ""; 
                $unpublish = ""; 
                if($this->tax->checked) $publish = "checked='checked'"; 
                else $unpublish = "checked='checked'"; 

                ?>

                <div class="btn-group" >

                  <label class="btn" for="checked_0" ><?php echo JText::_( 'JYES' ); ?>
                    <input class="radio_toggle" type="radio" value="1" name="checked" id="checked_0" <?php echo $publish;?> />
                  </label>
                  <label class="btn" for="checked_1"><?php echo JText::_( 'JNO' ); ?>
                    <input class="radio_toggle" type="radio" value="0" name="checked" id="checked_1" <?php echo $unpublish;?> /> </label>

                  </div>

                </div>
              </div>


              <input type="hidden" name="option" value="com_invoices" />
              <input type="hidden" name="id" value="<?php echo $this->tax->id; ?>" />
              <input type="hidden" name="task" value="" />
              <input type="hidden" name="controller" value="tax" />
            </form>
          </div>
