<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );

class PaymentsViewPayments extends JViewLegacy
{

	protected $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

	}

	function display($tpl = null)
	{
	    
		JToolbarHelper::title(JText::_( 'PAYMENT_MANAGER' ), 'payments' );
		JToolbarHelper::addNew();
		JToolbarHelper::deleteList(JText::_( 'SURE_PAYMENTS' ));
		JToolbarHelper::preferences( 'com_invoices' , '500', '700');

		InvoicesHelper::addSubmenu('payments');
		$this->sidebar = JHtmlSidebar::render();

		$document	= JFactory::getDocument();

		$this->params = JComponentHelper::getParams( 'com_invoices' );

		// Get data from the model
		$this->pagination = $this->get('Pagination');
		$this->keywords = $this->get('keywords');
		$this->cal_start = $this->get('Calstart');
		$this->cal_end = $this->get('Calend');
		$this->status = InvoicesHelper::getStatusPaymentFilters();
		$this->status_id = $this->get('StatusId');
		$this->invoice_id = $this->get('InvoiceId');
		$this->currencies		= InvoicesHelper::getCurrencies();
		$this->currency_id = $this->get('CurrencyId');

		$lists['order_Dir'] = $this->get('FilterOrderDir') ;
		$lists['order']     = $this->get('FilterOrder') ;

		$document->addScript('components/com_invoices/assets/js/payments.js');
		$document->addScript('components/com_invoices/assets/libs/jquery.form.min.js');
		$document->addScript('components/com_invoices/assets/js/ajax_submit_payment.js');

		//MODELS
		$document->addScript('components/com_invoices/assets/js/models/Payment.js');

		$this->lists = $lists;

		//load language strings
		InvoicesHelper::loadStatusLanguageStrings();

		parent::display($tpl);
	}

}
