<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); ?>

<div class="row form-inline filter-form " id="filter-contents">
  <div class="col-sm-12">

      <div class="form-group">
        <label class="sr-only" for="keywords"><?php echo JText::_('TYPE_TO_SEARCH'); ?></label>
        <input  type="text"
                name="keywords"
                id="keywords"
                v-model.trim="keywords"
                class="form-control keywords"
                placeholder="<?php echo JText::_( 'TYPE_TO_SEARCH' ); ?>" />
      </div>
      <div class="form-group">
        <label class="sr-only" for="status_id"><?php echo JText::_('STATUS'); ?></label>
        <select v-model='status_id'
                class='form-control'
                name='status_id'
                id='status_id'>
          <option value="">-- <?php echo JText::_( 'SELECT_STATUS' ); ?> --</option>
          <option v-for="status in statuses"
                  :value="status.id">{{ status.name }}</option>
        </select>
      </div>

      <div class="form-group">
        <label class="sr-only" for="cal_start"> <?php echo JText::_( 'FROM'); ?> </label>

         <div class="input-group" >
            <input  class="form-control "
                    type="text"
                    name="cal_start"
                    id="cal_start"
                    v-model="cal_start"
                    placeholder="<?php echo JText::_( 'FROM' ); ?>"/>

              <span class="input-group-btn">
                <span class="btn btn-default" id="cal_start_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
              </span>
          </div>

      </div>

      <div class="form-group">
        <label class="sr-only" for="cal_end"> <?php echo JText::_( 'TO'); ?> </label>

         <div class="input-group" >
            <input  class="form-control "
                    type="text"
                    name="cal_end"
                    id="cal_end"
                    v-model="cal_end"
                    placeholder="<?php echo JText::_( 'TO' ); ?>"/>

              <span class="input-group-btn">
                <span class="btn btn-default" id="cal_end_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
              </span>
          </div>

      </div>

      <input  placeholder="<?php echo JText::_( 'INVOICE_ID' ); ?>"
              type="text"
              name="invoice_id"
              id="invoice_id"
              v-model="invoice_id"
              class="form-control"  />

      <button class="btn btn-default "
              type="button"
              @click.prevent="clearFilters()" ><?php echo JText::_('CLEAR_FILTERS'); ?></button>

      <a class="btn btn-warning navbar-btn pull-right" href="<?php echo JRoute::_('index.php?option=com_invoices&controller=payments&task=export'); ?>"><?php echo JText::_('EXPORT_CSV'); ?> (<span class="total_payments">{{ summary.num_payments }}</span> <?php echo JText::_('ROWS'); ?>)</a>

  </div>
</div>
