<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view' );

class InvoicesViewInvoices extends JViewLegacy
{

	public $layout_type = "INVOICE" ;
	public $strings = array();

	protected $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

	}

	function display($tpl = null)
	{
		$user  = JFactory::getUser();

		JToolbarHelper::title(   JText::_( 'INVOICE_MANAGER' ), 'invoices' );

		if ($user->authorise('core.create', 'com_invoices')){
			JToolbarHelper::addNew();
		}

		if ($user->authorise('core.delete', 'com_invoices')){
			JToolbarHelper::deleteList(JText::_( 'SURE_INVOICES' ));
		}

		if ($user->authorise('core.edit.state', 'com_invoices')){
			JToolbarHelper::publishList();
			JToolbarHelper::unpublishList();
		}

		if ($user->authorise('core.create', 'com_invoices')){
			JToolbarHelper::custom( 'duplicate', 'copy', 'publish_f2.png', 'DUPLICATE_INVOICES' );
		}

		JToolbarHelper::custom( 'send_email', 'envelope', 'publish_f2.png', 'SEND_INVOICES' );
		JToolbarHelper::custom( 'create_recurring', 'refresh', '', 'GENERATE_RECURRING', false );

		if ($user->authorise('core.admin', 'com_invoices') || $user->authorise('core.options', 'com_invoices'))
		{
			JToolbarHelper::preferences('com_invoices');
		}

		InvoicesHelper::addSubmenu('invoices');
		$this->sidebar = JHtmlSidebar::render();

		$document	= JFactory::getDocument();

		$this->params = JComponentHelper::getParams( 'com_invoices' );

		// Get data from the model
		$this->pagination = $this->get('Pagination');
		$this->keywords = $this->get('keywords');
		$this->cal_start = $this->get('Calstart');
		$this->cal_end = $this->get('Calend');
		$this->taxes = InvoicesHelper::getTaxes();
		$this->alltaxes = InvoicesHelper::getAllTaxes();
		$this->status = $this->get('Status');
		$this->status_id = $this->get('StatusId');
		$this->templates		= InvoicesHelper::getTemplatesData();
		$this->currencies		= InvoicesHelper::getCurrencies();
		$this->currency_id = $this->get('CurrencyId');

		//cridem els JavaScript
		$document->addScript('components/com_invoices/assets/js/invoices.js');
    $document->addScript('components/com_invoices/assets/js/items.js');
    $document->addScript('components/com_invoices/assets/js/users.js');
		$document->addScript('components/com_invoices/assets/libs/jquery.tablednd.js');
		$document->addScript('components/com_invoices/assets/libs/jquery.form.min.js');
		$document->addScript('components/com_invoices/assets/js/ajax_submit_invoice.js');
		$document->addScript("components/com_invoices/assets/libs/floatThead/jquery.floatThead.min.js");

		//JS models
		//$document->addScript('components/com_invoices/assets/js/models/Invoice.js');
		$document->addScript('components/com_invoices/assets/js/models/Invoice.js');

		$lists['order_Dir'] = $this->get('FilterOrderDir') ;
		$lists['order']     = $this->get('FilterOrder') ;

		$this->lists = $lists;

		//load language strings
		InvoicesHelper::loadStatusLanguageStrings();

		$lang = JFactory::getLanguage();
		$langs = $lang->getKnownLanguages(JPATH_SITE) ;

		foreach($langs as $language){
			$this->load('com_invoices', JPATH_SITE, $language['tag'], true);
		}

		$document->addScriptDeclaration('var strings = '.json_encode($this->strings).'; ');

		parent::display($tpl);
	}

	//as taken from the JLanguage file
	//but some things taken out
	public function load($extension = 'joomla', $basePath = JPATH_BASE, $lang = null, $reload = false, $default = true)
	{

		$path = $this->getLanguagePath($basePath, $lang);

		$internal = $extension == 'joomla' || $extension == '';
		$filename = $internal ? $lang : $lang . '.' . $extension;
		$filename = "$path/$filename.ini";

		// Load the language file
		$result = $this->loadLanguage($filename, $extension, $lang);

		return $result;
	}

	protected function loadLanguage($filename, $extension = 'unknown', $lang)
	{

		$result = false;
		$strings = false;

		if (file_exists($filename))
		{
			$strings = $this->parse($filename);
		}

		if ($strings)
		{
			if (is_array($strings) && count($strings))
			{
				//$this->strings = array_replace($this->strings, $strings, false);
				$this->strings[$lang] = $strings;

				$result = true;
			}
		}

		return $result;
	}

	protected function parse($filename)
	{

		$contents = file_get_contents($filename);
		$contents = str_replace('_QQ_', '"\""', $contents);
		$strings = @parse_ini_string($contents);

		if (!is_array($strings))
		{
			$strings = array();
		}

		return $strings;
	}

	public static function getLanguagePath($basePath = JPATH_BASE, $language = null)
	{
		$dir = $basePath . '/language';

		if (!empty($language))
		{
			$dir .= '/' . $language;
		}

		return $dir;
	}

}
