<?php
/**
 * -----------------------------------------------------------------------------
 * com_papershape   Project management component for Joomla
 * -----------------------------------------------------------------------------
 *
 * @package     Papershape
 * @copyright   Copyright (C) 2016 JoomlaThat!. All rights reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL v2 or later
 * @author      JoomlaThat!
 * website      http://www.joomlathat.com
 * support      support@joomlathat.com
 */

// No direct access
defined('_JEXEC') or die('Restricted Access');

$params = JComponentHelper::getParams( 'com_invoices' );

$items = JHtmlSidebar::getEntries();

$icons =  array(  'list',
                  'list',
                  'usd',
                  'user',
                  'transfer',
                  'duplicate',
                  'list',
                  'credit-card',
                  'cog',
                  'eur'
                );

?>

<nav id="invoiceManagerMenu" class="panel-slide col-xs-2 " role="navigation">
    <ul>
        <?php foreach ($items as $key => $item): ?>

        <li class="menuLi <?php if ($item[2] == 1) echo 'active'; ?> <?php if ($key == 7 || $key == 8) echo "separatorTop"; ?>">
            <a class="btn-block" href="<?php echo JRoute::_($item[1]); ?>">
                <div class="visibleThin"><span class="glyphicon glyphicon-<?php echo $icons[$key]; ?>"></span></div>
                <div class="hiddenThin"><span> <?php echo $item[0]; ?></span></div>
            </a>
        </li>

        <?php endforeach ?>

    </ul>


    <?php if($params->get('systeminfo', 1)){ ?>

    <div class="hiddenThin">
        <?php echo InvoicesHelper::versionBox(); ?>
    </div>

    <?php } ?>

    <script>

    //change button bar
    jQuery('#toolbar').addClass('invoice-manager');
    jQuery('#toolbar .btn').addClass('btn-default btn-sm');

    jQuery(document).ready(function() {

        /* ---------------------- INITIALIZATION ---------------------- */

        jQuery('#system-message-container').addClass('wrap push shrink').css({'padding': '0 15px'});
        jQuery('#system-message-container .alert').css({'margin-bottom': '0'});

        var menuButton = '<a class="btn btn-small btn-sm pull-left" href="#invoiceManagerMenu" id="menu-link"><span class="glyphicon glyphicon-menu-hamburger"></span></a>';
        if (jQuery('#toolbar').length) {
            // User views buttons
            jQuery('#toolbar').prepend(menuButton);
        } else {
            // The user doesn't view buttons
            jQuery('#toolbar').prepend('<div id="toolbar-options" class="btn-wrapper">' + menuButton + '</div>');
            jQuery('a.btn.btn-subhead').click(function() {
                jQuery('.subhead-collapse').removeClass('collapse subhead-collapse');
            });
        }

        jQuery('#menu-link').bigSlide({
            menu: ('#invoiceManagerMenu'),
            saveState: true,
            semiOpenStatus: true
        });

        // set the menu height
        // FIXME: This can't be done like this 150 is arbitrary
        jQuery(window).scroll(function() {
            jQuery('.panel-slide').height(jQuery(document).height()-150);
        });

    });

    <?php if($params->get('systeminfo', 1)){ ?>

    jQuery( document ).ready(function() {
      jQuery('#sidebar').append("<?php echo InvoicesHelper::versionBox(); ?>");
      var version = null;
      var url = 'index.php?option=com_installer&view=update&task=update.ajax&<?php echo JSession::getFormToken(); ?>=1&eid=0&skip=700';
      jQuery.ajax({
        url: url,
        dataType: 'json',
        success: function (result) {
          var trobat = false;
          var i = 0;
          while (!trobat && i < result.length) {
            if (result[i].element == 'com_invoices') {
              version = result[i].version;
              trobat = true;
            }
            i++;
          }
          if (version != null) {
            jQuery('#latest-version').html('<strong>' + version + '</strong>');
            jQuery('#update-info').html('<?php echo JText::_('SYSTEM_NEEDS_UPDATE'); ?><div class="row-fluid"><a class="btn btn-info btn-get-updates" href="http://www.joomlathat.com/account/downloads" target="_blank"><?php echo JText::_('UPDATE_CLICK_DOWNLOAD'); ?></a></div>');
          } else {
            jQuery('#update-info').html('<?php echo JText::_('SYSTEM_UP_TO_DATE'); ?>');
          }
        }
      });
    });
    <?php } ?>
    </script>


</nav>
