<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');
?>

<div id="filter-page-header" class="visible-xs">
  <button onclick="showFilters();return false;" class="btn btn-link"><span>&nbsp;<strong><?php echo JText::_('FILTER_RESULTS'); ?></strong></span><span id="filter-icon-down" class="glyphicon glyphicon-menu-down visible-xs pull-left"></span></button>
</div>

<div class="row form-inline filter-form hidden-xs" id="filter-contents">
  <div class="col-sm-12">

      <div class="form-group">
        <label class="sr-only" for="keywords"><?php echo JText::_('TYPE_TO_SEARCH'); ?></label>
        <input  type="text"
                name="keywords"
                id="keywords"
                v-model.trim="keywords"
                class="form-control keywords"
                placeholder="<?php echo JText::_( 'TYPE_TO_SEARCH' ); ?>" />
      </div>
      <div class="form-group">
        <label class="sr-only" for="status_id"><?php echo JText::_('STATUS'); ?></label>
        <select v-model='status_id'
                class='form-control'
                name='status_id'
                id='status_id'>
          <option value="">-- <?php echo JText::_( 'SELECT_STATUS' ); ?> --</option>
          <option v-for="status in statuses"
                  :value="status.id">{{ status.name }}</option>
        </select>
      </div>

      <div class="form-group">

        <div class="input-group input-daterange cs-date" id="daterange">
      		<input  class="form-control"
      						type="text"
                  name="cal_start"
                  id="cal_start"
      						maxlength="10"
      						v-model="cal_start"
      						placeholder="<?php echo JText::_( 'FROM' ); ?>"
      		/>
          <div class="input-group-addon"><span class="glyphicon glyphicon-arrow-right"></span></div>
      		<input  class="form-control"
      						type="text"
                  name="cal_end"
                  id="cal_end"
      						maxlength="10"
      						v-model="cal_end"
      						placeholder="<?php echo JText::_( 'TO' ); ?>"
      		/>
      	</div>

      	<div class="daterange_container" id="container_datepicker">

      	</div>

      </div>

      <div class="form-group">

    		<div class="btn-group">
    			<button type="button"
    							class="btn btn-default"
    							:class="{active: time == 'MTD'}"
    							@click="time = 'MTD'"><?php echo JText::_( 'MTD' ); ?></button>
    			<button type="button"
    							class="btn btn-default"
    							:class="{active: time == 'QTD'}"
    							@click="time = 'QTD'"><?php echo JText::_( 'QTD' ); ?></button>
    			<button type="button"
    							class="btn btn-default"
    							:class="{active: time == 'YTD'}"
    							@click="time = 'YTD'"><?php echo JText::_( 'YTD' ); ?></button>
    		</div>

      </div>

      <div class="form-group">

    		<div class="btn-group">
      		<button type="button"
      						class="btn btn-default"
      						@click="periodOffset--"
                  :disabled="!time"><span class="glyphicon glyphicon-chevron-left"></span></button>
      		<button type="button"
      						class="btn btn-default"
      						@click="periodOffset++"
                  :disabled="!time"><span class="glyphicon glyphicon-chevron-right"></span></button>
    		</div>

      </div>

      <!-- <div class="form-group">
        <label class="sr-only" for="cal_start"> <?php echo JText::_( 'FROM'); ?> </label>

         <div class="input-group" >
            <input  class="form-control "
                    type="text"
                    name="cal_start"
                    id="cal_start"
                    data-date-format="yyyy-mm-dd"
                    v-model="cal_start"
                    placeholder="<?php echo JText::_( 'FROM' ); ?>"/>

              <span class="input-group-btn">
                <span class="btn btn-default" id="cal_start_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
              </span>
          </div>

      </div>

      <div class="form-group">
        <label class="sr-only" for="cal_end"> <?php echo JText::_( 'TO'); ?> </label>

         <div class="input-group" >
            <input  class="form-control "
                    type="text"
                    name="cal_end"
                    id="cal_end"
                    data-date-format="yyyy-mm-dd"
                    v-model="cal_end"
                    placeholder="<?php echo JText::_( 'TO' ); ?>"/>

              <span class="input-group-btn">
                <span class="btn btn-default" id="cal_end_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
              </span>
          </div>

      </div> -->

      <?php if($this->params->get('multiple_currency', false)){ ?>
      <div class="form-group">
        <label class="sr-only" for="currency_id"><?php echo JText::_('CURRENCY'); ?></label>
        <select class="form-control"
                name="filter_currency_id"
                id="filter_currency_id"
                v-model="filter_currency_id">
                <option value="0">-- <?php echo JText::_( 'ALL_CURRENCIES' ); ?> --</option>
                <option v-for="currency in currencies"
                        :value="currency.id">{{ currency.currency_code }}</option>

        </select>
      </div>
      <?php } ?>

      <button class="btn btn-default " type="button" @click.prevent="clearFilters()" ><?php echo JText::_('CLEAR_FILTERS'); ?></button>

      <div class="pull-right">
        <?php if($this->params->get('multiple_currency', false)){ ?>
        <label ><?php echo JText::_('SHOW_TOTALS_FOR'); ?> </label>
        <div class="btn-group">
          <button type="button"
                  class="btn btn-default dropdown-toggle "
                  data-toggle="dropdown"
                  aria-haspopup="true"
                  aria-expanded="false">
            {{ currencies[currency_id].currency_code }} <span class="caret"></span>
          </button>
          <ul class="dropdown-menu">
            <li v-for="currency in currencies" @click="currency_id = currency.id"><a href="#">{{ currency.currency_code }}</a></li>
          </ul>
        </div>
        <?php } ?>
        <?php
        if($this->layout_type == 'INVOICE') $export_link = JRoute::_('index.php?option=com_invoices&controller=invoices&task=export');
        elseif($this->layout_type == 'QUOTE') $export_link = JRoute::_('index.php?option=com_invoices&controller=quotes&task=export');
        ?>
        <div class="btn-group ">
          <a class="btn btn-warning navbar-btn"
              href="<?php echo $export_link; ?>"><?php echo JText::_('EXPORT_CSV'); ?> (<span class="total_invoices">{{ summary.num_invoices }}</span> <?php echo JText::_('ROWS'); ?>)</a>
        </div>

      </div>

  </div>
</div>
