<?php
/*------------------------------------------------------------------------
# com_finances - Expense Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2015 joomlathat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');
?>

<!-- Modal -->
<div class="modal fade invoice-manager" id="detailsModal" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <invoicepreview
                        v-show="current_action == 'preview'"
                        v-if="!isSplitView()"
                        :invoice="current_invoice"
                        >
        </invoicepreview>
      </div>
      <div class="modal-footer">

        <div class="btn-group pull-left">
      	  	<button @click.prevent="edit_invoice(current_invoice.id)"
      	  			class="btn btn-primary maineditbutton"
      	  			data-loading-text="<?php echo JText::_('LOADING'); ?>" >
      	  		<span class="glyphicon glyphicon-edit"></span> <?php echo JText::_('EDIT'); ?>
      	   	</button>
      	</div>

        <div class="btn-group pull-right">
          <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('CLOSE'); ?></button>
        </div>

        <div class="btn-group pull-right">

      	  <a :href="current_invoice.pdf_link"
      	  	 class="btn btn-default"
      	  	 v-show="current_invoice.pdf_link"
      	  >
      	  	<span class="glyphicon glyphicon-download-alt"></span> <?php echo JText::_('PDF'); ?>
      	  </a>

          <button 	class="btn btn-default mainsendbutton"
                @click.prevent="email_invoice(current_invoice.id)"
                v-show="current_invoice.to_email"
                :id="'mainsendbutton' + current_invoice.id"
                data-loading-text="<?php echo JText::_('SENDING'); ?>"
          >
            <span class="glyphicon glyphicon-envelope"></span> <?php echo JText::_('SEND'); ?>
          </button>

        </div>

        <div class="btn-group pull-right">
      	  <a :href="current_invoice.public_link"
      	  	 target="_blank"
      	  	 class="btn btn-default"
      	  >
      	  	<span class="glyphicon glyphicon-share-alt"></span> <?php echo JText::_('OPEN_LINK'); ?>
      	  </a>
      	</div>

      </div>
    </div>
  </div>
</div>
