<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');
$params = JComponentHelper::getParams( 'com_invoices' );
$document = JFactory::getDocument();
$display_taxes = array();
if(isset($layout_type) && $layout_type == "QUOTE") $type = 2;
else $type = 1;

$this->cs_modules = array();

?>
<style>
@media (min-width: 1200px) and (min-height: 800px){
  body{
      overflow-x: hidden;
      overflow-y: hidden!important;
  }
}
</style>

<?php include(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'invoices'.DS.'tmpl'.DS.'default_menu.php'); ?>

<div id="im-app" class="wrap push shrink invoice-manager <?php if($params->get('instant_preview')) echo 'instant_preview'; ?>">

  <?php echo $this->loadTemplate('totals'); ?>

  <?php
    $modules = JModuleHelper::getModules("invoices_backend");
    $document = JFactory::getDocument();
    $renderer = $document->loadRenderer('module');
    $attribs  = array();
    $attribs['style'] = 'xhtml';
    foreach ( @$modules as $mod )
    {
      if($mod->module == "mod_content_statistics_compare"){
        $this->cs_modules[] = $mod;
      }
      echo $renderer->render($mod, $attribs);
    }
    ?>

  <form action="index.php" method="post" name="adminForm" id="adminForm" class="">

    <?php echo $this->loadTemplate('filter'); ?>

    <input type="hidden" name="option" value="com_invoices" />
    <input type="hidden" name="status_to" value="" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="controller" value="invoice" />
    <input type="hidden" name="filter_order" id="filter_order" value="<?php echo $this->lists['order']; ?>" />
    <input type="hidden" name="filter_order_Dir" id="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>" />

    <div class="row">
      <?php if($params->get('list_view', 1)){
        $theclass= " detail-view";}
        else $theclass = "col-lg-12 nodetail-view"; ?>
      <div  class="container-wrapper <?php echo $theclass; ?> col-md-12 invoices-transition "
            :class="{'col-lg-6': current_action == 'edit' && split_view == 1,
                    'col-lg-7': current_action != 'edit' && split_view == 1,
                    'col-lg-2': current_action == 'edit' && split_view == 1 && instant_preview == 1}"
            id="invoices-wrapper">

          <table class="table table-hover items_table_responsive" id="invoices-table">
            <thead>
              <tr>

                <th width="20" class="hidden-xs"> <input type="checkbox" name="checkall-toggle" value="" onclick="Joomla.checkAll(this);" /></th>
                <th><?php echo InvoicesHelper::build_order_header('ID', 'i.id', $this->lists['order'], $this->lists['order_Dir']); ?></th>
                <th><?php echo InvoicesHelper::build_order_header($this->layout_type.'_NUM', 'i.invoice_num', $this->lists['order'], $this->lists['order_Dir']); ?></th>
                <th class=" hidden-xs"><?php echo InvoicesHelper::build_order_header('RECIPIENT_NAME', 'i.to_name', $this->lists['order'], $this->lists['order_Dir']); ?></th>
                <th class="hidden-xs"></th>
                <th colspan="2" class=" hidden-xs"><?php echo InvoicesHelper::build_order_header('STATUS', 'i.status', $this->lists['order'], $this->lists['order_Dir']); ?></th>
                <?php if($this->params->get('sourcecolumn')){ ?>
                <th class="hidden-xs"><?php echo JText::_('EXTERNAL_TYPE'); ?></th>
                <?php } ?>
                <th class="hidden-xs text-right"><?php echo JText::_('SUBTOTAL'); ?></th>

                <th class="hidden-xs text-right"
                    v-for="thetax in alltaxes"
                    v-show="display_tax(thetax.id)"> {{ thetax.name }}</th>

                <th class=" text-right "><?php echo InvoicesHelper::build_order_header('TOTAL', 'i.computed_total', $this->lists['order'], $this->lists['order_Dir']); ?></th>
                <th></th>
                <?php if(InvoicesHelper::pdf_enabled()){?>
                <th class="hidden-xs"></th>
                <?php } ?>

              </tr>
            </thead>
            <tbody id="invoices-body">

              <tr
                v-for="invoice in invoices"
                is="invoice"
                :invoice="invoice"
                :id="'row' + invoice.id"
                :data-value="invoice.amount"
                :class="{'item-row': true, 'active': current_invoice.id == invoice.id}"
              >
              </tr>

            </tbody>

          </table>

          <div id="loadmoreajaxloader_invoices" class="text-muted clear_row text-center" v-show="isLoading">
            <div class="mdl-spinner mdl-spinner--single-color mdl-js-spinner is-active"></div>
          </div>

          <div class="no-more-entries text-muted clear_row text-center" v-show="!more_items"><?php echo JText::_('NO_MORE_ENTRIES'); ?></div>

          <div id="end_container_invoices" class="clear_row"></div>


      </div>
      <?php if($params->get('list_view', 1)){ ?>
      <div  class=" invoice-outer-wrapper container-wrapper invoices-transition "
            :class="{'col-lg-6': current_action == 'edit' && split_view == 1,
                    'col-lg-5': (current_action != 'edit' && split_view == 1) || (current_action == 'edit' && split_view == 1 && instant_preview == 1),
                    'norightpadding': instant_preview && current_action == 'edit'
                    }"
            v-show="current_action == 'edit'"
            id="invoice-wrapper">

        <div id="invoice-buttonbar" class="invoice-options">

          <?php echo $this->loadTemplate('editbuttonbar'); ?>

        </div>

        <div class="invoice-container scroll-y">

          <invoiceform  class="invoice-edit-container"
                        id="invoice-edit-container"
                        v-if="isSplitView()"
                        v-show="current_action == 'edit'"
                        :invoice="current_invoice"
                        >
          </invoiceform>

        </div>

      </div>

      <div  class=" invoice-outer-wrapper container-wrapper invoices-transition col-lg-5"
            id="invoice-wrapper"
            v-show="current_action != 'edit' || (current_action == 'edit' && instant_preview)">

        <div id="invoice-buttonbar" class="invoice-options">

          <?php echo $this->loadTemplate('buttonbar'); ?>

        </div>

        <div class="invoice-container scroll-y">

          <div  class="material-card material-shadow-z1 invoice-inner-container"
                >
            <div id="loader_preview" class="text-muted clear_row text-center " style="display:none;">
              <div class="mdl-spinner mdl-spinner--single-color mdl-js-spinner is-active"></div>
            </div>
            <div id="invoice-paper" class="invoice-paper-inline">
              <div class="no-more-entries text-muted clear_row text-center "
                   v-show="(current_action != 'preview' && instant_preview) && !(current_action == 'edit' && instant_preview)">
                   <?php echo JText::_('SELECT_'.$this->layout_type.'_FOR_PREVIEW'); ?></div>

              <invoicepreview
                              v-show="current_action == 'preview' || (current_action == 'edit' && instant_preview)"
                              v-if="isSplitView()"
                              :invoice="current_invoice"
                              >
              </invoicepreview>

            </div>
          </div>

        </div>

      </div>

      <?php } ?>
    </div>

    </form>

    <?php echo $this->loadTemplate('modal'); ?>

</div>

<div align="center" class="footer-sticky hidden-xs"><?php echo InvoicesHelper::showInvoicesFooter(); ?></div>

<template id="invoice-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'invoice.php'); ?>
</template>

<template id="invoiceform-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'invoice'.DS.'form.php'); ?>
</template>

<template id="preview-vue-template" >
  <div>
  <?php foreach ($this->templates as $template) {
    $search = array("{company_logo}");
    $replace = array(JURI::root().'media'.DS.'com_invoices'.DS.$template->company_logo);
    echo "<div v-if='invoice.template_id == ".$template->id."'>".str_replace($search, $replace, InvoicesHelper::templateToVue($template->content))."</div>";
  } ?>
  </div>
</template>

<template id="statusoptions-template" >
<?php echo $this->loadTemplate('statusoptions'); ?>
</template>
<template id="contact-suggestion-template" >
<?php echo $this->loadTemplate('contact_result_template'); ?>
</template>
<template id="item-suggestion-template" >
<?php echo $this->loadTemplate('item_result_template'); ?>
</template>
<template id="user-suggestion-template" >
<?php echo $this->loadTemplate('user_result_template'); ?>
</template>

<?php if(file_exists(JPATH_SITE.DS.'modules'.DS.'mod_content_statistics_compare'.DS.'tmpl'.DS.'components'.DS.'template.php')){ ?>
<template id="cschart-template" >
<?php include(JPATH_SITE.DS.'modules'.DS.'mod_content_statistics_compare'.DS.'tmpl'.DS.'components'.DS.'template.php'); ?>
</template>
<?php } ?>

<script type="text/javascript">

var type = <?php echo $type; ?> ;

var pagination_step = 20;
var start = 0;
var split_view = <?php echo $params->get('list_view', 1); ?>;
var instant_preview = <?php echo $params->get('instant_preview', 0); ?>;
var display_taxes = [<?php echo implode(",", $display_taxes); ?>];
var cs_installed = <?php echo (int)file_exists(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'helpers'.DS.'helpers.php'); ?>;
var pendingKeyword = null;
var component = "<?php echo $this->input->get('option'); ?>";
var appId = "<?php echo $this->input->get('appId'); ?>";
var clearingFilters = false;
var access_key = "<?php echo $params->get('vatkey'); ?>";

//http://www.sitepoint.com/jquery-infinite-scrolling-demos/
jQuery( document ).ready(function() {

  jQuery('#invoices-wrapper').scroll(function()
  {
    if(!is_mobile()){
      if(jQuery(window).scrollTop() >= jQuery('#end_container_invoices').offset().top + jQuery('#end_container_invoices').height() - jQuery(window).height())
      {
        if(!vm.isLoading && vm.more_items){
          vm.isLoading = true;
          load_more_items();
        }
      }
    }

  });

  jQuery(window).scroll(function()
  {
    if(is_mobile()){
      if(jQuery(window).scrollTop() >= jQuery('#end_container_invoices').offset().top + jQuery('#end_container_invoices').height() - jQuery(window).height())
      {
        if(!vm.isLoading && vm.more_items){
          vm.isLoading = true;
          load_more_items();
        }
      }
    }

  });

  <?php
  $do = $this->input->getCmd('do');
  if($do){
    switch($do){
      case "new_invoice":
      echo "new_invoice(".$this->input->getInt('from').");" ;
      break;

    }
  }
  ?>

});
</script>

<script>

  var vm = {
    summary : {
      num_invoices: 0,
      total_invoices: [],
      total_income: [],
      pending_income: [],
      taxes: {
        <?php foreach($this->taxes as $tax){ ?>
          <?php echo $tax->id ?>: {
            computed_value: 0
          },
        <?php } ?>
      },
      update: 0
    },
    animatedSummary : {
      num_invoices: 0,
      total_invoices: 0,
      total_income: 0,
      pending_income: 0,
      taxes: {
        <?php foreach($this->taxes as $tax){ ?>
          <?php echo $tax->id ?>: 0,
        <?php } ?>
      }
    },
    invoices: [],
    current_action: '',
    current_invoice: new Invoice({id:0,
                      items:[],
                      payments:[],
                      taxes:{

                        <?php foreach($this->alltaxes as $tax){ ?>
                          <?php echo $tax->id ?>: <?php echo json_encode($tax) ?>,
                        <?php } ?>

                      },
                      history: [],
                      language: 'en-GB'
    }),
    format: {
      before : "<?php echo $params->get('currency_before', ''); ?>",
      after : "<?php echo $params->get('currency_after', ''); ?>",
      currency_before : "<?php echo $params->get('currency_before', ''); ?>",
      currency_after : "<?php echo $params->get('currency_after', ''); ?>",
      currency_id : "<?php echo $params->get('currency_id', '1'); ?>",
      noMoreEntriesText : "<?php echo JText::_('NO_MORE_ENTRIES'); ?>",
      decimals : "<?php echo $params->get('decimals', '2'); ?>",
      number_decimals : "<?php echo $params->get('decimals', '2'); ?>",
      decpoint : "<?php echo $params->get('decpoint', '.'); ?>",
      thousands : "<?php echo $params->get('thousands', ','); ?>",
      minus_format : "<?php echo $params->get('minus_format', 'minus'); ?>",
      decimals_tax : "<?php echo $params->get('decimals_tax', 0); ?>",
    },
    alltaxes: {
      <?php foreach($this->alltaxes as $tax){ ?>
        <?php echo $tax->id ?>: <?php echo json_encode($tax) ?>,
      <?php } ?>
    },
    type: type,
    split_view: split_view,
    instant_preview: instant_preview,
    isLoading: true,
    more_items: true,
    cal_start: "<?php echo $this->cal_start ?>",
    cal_end: "<?php echo $this->cal_end ?>",
    time: "",
    periodOffset: 0,
    status_id: "<?php echo $this->status_id ?>",
    keywords: "<?php echo $this->keywords ?>",
    filter_currency_id: "<?php echo $this->currency_id ?>",
    filter_order: "<?php echo $this->lists['order'] ?>",
    filter_order_Dir: "<?php echo $this->lists['order_Dir'] ?>",
    currencies: {<?php foreach($this->currencies as $currency_id => $currency){ ?>
                  <?php if($currency->id) { echo $currency->id; ?>: <?php echo json_encode($currency); ?>,<?php } ?>
                <?php } ?>},
    currency_id: "<?php echo $this->currency_id ? $this->currency_id : $params->get('currency_id', '1'); ?>",
    default_currency_id: "<?php echo $params->get('currency_id', '1'); ?>",
    autosave: <?php echo $params->get('autosave', '1'); ?>,
    instantpreview: <?php echo $params->get('instantpreview', '1'); ?>,
    defaults:{
      tax_id: <?php echo $params->get('tax_id', 0); ?>,
      tax: "<?php echo $params->get('tax', ""); ?>",
      currency_id: "<?php echo $params->get('currency_id', '1'); ?>",
    },
    statuses: {
      <?php
      if($this->layout_type == "INVOICE") $statuses = InvoicesHelper::getStatus();
      else $statuses = InvoicesHelper::getQuoteStatus();
      foreach($statuses as $status){
        $thestatus = new stdClass();
        $thestatus->id = $status;
        $thestatus->name = JText::_($status); ?>
        <?php echo $status ?>: <?php echo json_encode($thestatus) ?>,
      <?php } ?>
    },
    cs_charts: {
      <?php foreach($this->cs_modules as $cs_module){ ?>
        cs_chart_<?php echo $cs_module->id; ?>: cs_chart_<?php echo $cs_module->id; ?>,
      <?php } ?>
    }
  };

  /* INVOICE COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'invoice.js'); ?>

  /* FORM COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'invoiceform.js'); ?>

  /* PREVIEW COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'invoicepreview.js'); ?>

  Vue.component('invoiceform', invoiceform_component);
  Vue.component('invoice', invoice_component);
  Vue.component('invoicepreview', invoicepreview_component);

  new Vue({
    el: '#im-app',
    data: vm,
    computed: {
      currency: function () {
        return this.currencies[this.currency_id];
      },
    },
    methods: {
      edit_invoice: function (invoice_id) {
        edit_invoice(invoice_id)
      },
      email_invoice: function (invoice_id) {
        email_invoice(invoice_id, false)
      },
      print_invoice: function (invoice_id) {
        print_invoice(invoice_id)
      },
      delete_invoice: function () {
        delete_invoice(this.current_invoice.id, false)
      },
      saveInvoice: function () {
        save_invoice()
      },
      save_and_preview: function () {
        save_and_preview()
      },
      display_tax: function(tax_id){
        return display_tax(tax_id);
      },
      isSplitView: function(){
        if(is_mobile() || !split_view) return false;
        else return true;
      },
      clearFilters: function(){
        clearingFilters = true;
        clearFilters();

        reset_list_fields();
        load_more_items();

      },
      total_invoices: function(){
        if(typeof this.summary.total_invoices[this.currency_id] !== 'undefined'){
          return this.summary.total_invoices[this.currency_id].total;
        }
        return 0;
      },
      subtotal_invoices: function(){
        if(typeof this.summary.total_invoices[this.currency_id] !== 'undefined'){
          return this.summary.total_invoices[this.currency_id].subtotal;
        }
        return 0;
      },
      total_income: function(){
        if(typeof this.summary.total_income[this.currency_id] !== 'undefined'){
          return this.summary.total_income[this.currency_id].total;
        }
        return 0;
      },
      pending_income: function(){
        if(typeof this.summary.pending_income[this.currency_id] !== 'undefined'){
          return this.summary.pending_income[this.currency_id].total;
        }
        return 0;
      },
      total_tax: function(tax_id){
        if(typeof this.summary.taxes[tax_id][this.currency_id] !== 'undefined'){
          return this.summary.taxes[tax_id][this.currency_id];
        }
        return 0;
      },
      preview_next: function(){
        indexes = jQuery.map(this.invoices, function(obj, index) {
          if(obj.id == vm.current_invoice.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.invoices[index - 1] !== "undefined") preview_invoice(this.invoices[index - 1].id, this.invoices[index - 1]);
      },
      preview_prev: function(){
        indexes = jQuery.map(this.invoices, function(obj, index) {
          if(obj.id == vm.current_invoice.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.invoices[index + 1] !== "undefined") preview_invoice(this.invoices[index + 1].id, this.invoices[index + 1]);
      },
      exists_next: function(){
        indexes = jQuery.map(this.invoices, function(obj, index) {
          if(obj.id == vm.current_invoice.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.invoices[index - 1] !== "undefined") return true;
        return false
      },
      exists_prev: function(){
        indexes = jQuery.map(this.invoices, function(obj, index) {
          if(obj.id == vm.current_invoice.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.invoices[index + 1] !== "undefined") return true;
        return false
      }

    },
    watch: {

      status_id: function (val) {

        if(!clearingFilters){
          reset_list_fields();
          load_more_items();
        }
      },
      cal_start: function (val) {
        if(!clearingFilters){
          reset_list_fields();
          load_more_items();
        }
      },
      cal_end: function (val) {
        if(!clearingFilters){
          reset_list_fields();
          load_more_items();
        }
      },
      filter_currency_id: function (val) {
        if(!clearingFilters){
          if(val == 0) {
            //this.currency_id = this.default_currency_id;
          }
          else this.currency_id = val;
          reset_list_fields();
          load_more_items();
        }
      },
      keywords: function (val) {

        if(!clearingFilters){
          if (!this.isLoading) {
            doKeywordSearch();
            // if (val == pendingKeyword) pendingKeyword = null;
            // reset_list_fields();
            // load_more_items();
          } else {
            pendingKeyword = val;
          }
        }
      },

      time: function(newVal, oldVal) {

        if(!clearingFilters){

          clearingFilters = true;

          this.periodOffset = 0;

  				switch (this.time) {
  					case 'MTD':
  						jQuery('#cal_start').datepicker('setDate', moment().startOf('month').format('YYYY-MM-DD'));
              jQuery('#cal_end').datepicker('setDate', moment().endOf('month').format('YYYY-MM-DD')).datepicker('hide');

              this.cal_start = moment().startOf('month').format('YYYY-MM-DD');
              this.cal_end = moment().endOf('month').format('YYYY-MM-DD');
  						break;
  					case 'QTD':
  						jQuery('#cal_start').datepicker('setDate', moment().startOf('quarter').format('YYYY-MM-DD'));
              jQuery('#cal_end').datepicker('setDate', moment().endOf('quarter').format('YYYY-MM-DD')).datepicker('hide');

              this.cal_start = moment().startOf('quarter').format('YYYY-MM-DD');
              this.cal_end = moment().endOf('quarter').format('YYYY-MM-DD');
  						break;
  					case 'YTD':
  						jQuery('#cal_start').datepicker('setDate', moment().startOf('year').format('YYYY-MM-DD'));
              jQuery('#cal_end').datepicker('setDate', moment().endOf('year').format('YYYY-MM-DD')).datepicker('hide');

              this.cal_start = moment().startOf('year').format('YYYY-MM-DD');
              this.cal_end = moment().endOf('year').format('YYYY-MM-DD');
  						break;
  				}

          reset_list_fields();
          load_more_items();
        }

      },
      periodOffset: function(newVal, oldVal) {

        if(!clearingFilters){

          clearingFilters = true;

  				switch (this.time) {

  					case 'MTD':
  						jQuery('#cal_start').datepicker('setDate', moment().subtract(-this.periodOffset, 'M').startOf('month').format('YYYY-MM-DD'));
  						jQuery('#cal_end').datepicker('setDate', moment().subtract(-this.periodOffset, 'M').endOf('month').format('YYYY-MM-DD')).datepicker('hide');

              this.cal_start = moment().subtract(-this.periodOffset, 'M').startOf('month').format('YYYY-MM-DD');
              this.cal_end = moment().subtract(-this.periodOffset, 'M').endOf('month').format('YYYY-MM-DD');
  						break;
  					case 'QTD':
  						jQuery('#cal_start').datepicker('setDate', moment().subtract(-this.periodOffset, 'Q').startOf('quarter').format('YYYY-MM-DD'));
  						jQuery('#cal_end').datepicker('setDate', moment().subtract(-this.periodOffset, 'Q').endOf('quarter').format('YYYY-MM-DD')).datepicker('hide');

              this.cal_start = moment().subtract(-this.periodOffset, 'Q').startOf('quarter').format('YYYY-MM-DD');
              this.cal_end = moment().subtract(-this.periodOffset, 'Q').endOf('quarter').format('YYYY-MM-DD');
  						break;
  					case 'YTD':
  						jQuery('#cal_start').datepicker('setDate', moment().subtract(-this.periodOffset, 'Y').startOf('year').format('YYYY-MM-DD'));
  						jQuery('#cal_end').datepicker('setDate', moment().subtract(-this.periodOffset, 'Y').endOf('year').format('YYYY-MM-DD')).datepicker('hide');

              this.cal_start = moment().subtract(-this.periodOffset, 'Y').startOf('year').format('YYYY-MM-DD');
              this.cal_end = moment().subtract(-this.periodOffset, 'Y').endOf('year').format('YYYY-MM-DD');
  						break;

  				}

          reset_list_fields();
          load_more_items();

        }

			}

    },
    mounted: function(){
      //initial load
      jQuery( document ).ready(function() {
        jQuery('#daterange').datepicker({
  				autoclose: true,
  				format: 'yyyy-mm-dd',
  				orientation: 'bottom',
  				container: '#container_datepicker'
  			});

  			jQuery('#cal_start').datepicker({}).on('changeDate', function(ev) {
          if (!vm.isLoading && !clearingFilters) {
              vm.cal_start = moment(ev.date).format('YYYY-MM-DD');
              jQuery(this).datepicker('hide');

              jQuery('#cal_end').datepicker('setStartDate', moment(ev.date).format('YYYY-MM-DD'));
    					jQuery('#cal_end').datepicker('show');
    					jQuery('#cal_end').focus();
          }

  			});

  			jQuery('#cal_end').datepicker({}).on('changeDate', function(ev) {
          if (!vm.isLoading && !clearingFilters) {
              vm.cal_end = moment(ev.date).format('YYYY-MM-DD');
              jQuery(this).datepicker('hide');
          }
  			});

      });

      vm.isLoading = true;
      load_more_items();
      set_height();
    }
  });

</script>
