<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

if(file_exists(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'helpers'.DS.'helpers.php')){

$statsparams = JComponentHelper::getParams( 'com_contentstats' );

require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'helpers'.DS.'helpers.php' );
require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'models'.DS.'items.php' );
require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_contentstats'.DS.'views'.DS.'items'.DS.'view.html.php');

$statsmodel = new StatsModelItems;
$statsview = new StatsViewItems;

$statsitems = ContentstatsHelper::getItems("com_invoices", $this->invoice->id);

$statsview->types = $statsmodel->getTypes();
$statsview->icons = $statsmodel->getIcons();
$statsview->countrynames = $statsview->countries() ;

?>
<table class="table table-striped">
  <thead>
    <tr>
      <th width="5" class="hidden-phone"> </th>
      <th > <?php echo JText::_('USER'); ?> | <?php echo JText::_('TYPE_OF_ACTION'); ?> | <?php echo JText::_('ITEM'); ?> </th>
      <th class=""> <?php echo JText::_('DATE'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('IP'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('COUNTRY'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('STATE'); ?> </th>
      <th class="hidden-phone"> <?php echo JText::_('CITY'); ?> </th>
    </tr>
  </thead>
  <tbody>
    <?php

    $hours = $statsparams->get('hours', '+00:00');

    if(count( $statsitems )){

    for ($i=0, $n=count( $statsitems ); $i < $n; $i++) {
      $row = &$statsitems[$i];


      if(isset($statsview->countrynames[$row->country])) $countryname = $statsview->countrynames[$row->country] ;
      else $countryname = "";

      $date = JFactory::getDate($row->date_event);
      $date_format = $date->toISO8601();
      $date_format = substr($date_format, 0, strpos($date_format, "+")) . $hours;

    ?>
    <tr >
      <td class="hidden-phone">
        <?php if(isset($statsview->icons[$row->component][$row->type])): ?> 
          <span class="glyphicon glyphicon-<?php echo $statsview->icons[$row->component][$row->type]; ?>"></span>
        <?php endif; ?>
      </td>
      <td class="" ><?php if($row->user_id){ ?>
        <strong><?php echo $row->username; ?></strong>
        <?php } else { echo JText::_('UNREGISTERED'); } ?> 
     <?php echo $statsview->types[$row->component][$row->type] ? str_replace("invoice", strtolower($this->layout_type), $statsview->types[$row->component][$row->type]) : $row->type ; ?> 
      <strong><?php echo $statsview->item_name($row->component, $row->type, $row->reference_id, $row->id); ?></strong>
      
      </td>
      <td >
      <span class=""><time class="timeago" datetime="<?php echo $date_format; ?>"><?php echo JHTML::_('date', $row->date_event, JText::_('DATE_FORMAT_LC2')); ?></time></span>
      </td>

      <td class="hidden-phone muted"><?php if($row->ip == "::1" || $row->ip == "127:0:0:1") echo JText::_('localhost'); else echo $row->ip; ?></td>
      <td class="hidden-phone"><?php if($row->country) echo JHTML::image('administrator/components/com_contentstats/assets/images/flags/'.strtolower($row->country).'.png', $row->country); ?> <?php echo ucwords(strtolower($countryname)); ?></td>
      <td class="hidden-phone"><?php echo ucwords(strtolower($row->state)); ?></td>
      <td class="hidden-phone"><?php echo ucwords(strtolower($row->city)); ?></td>
    </tr>
    <?php } 
     } ?>
  </tbody>
</table>

<?php if (!count($statsitems)): ?>
  <p class="text-center text-muted"><?php echo JText::_('NO_HISTORY_YET_'.$this->layout_type); ?></p>
<?php endif ?>

<?php }
else{
  //no CS installed
?>
<div class="alert alert-info"><?php echo JText::_('ONLY_WITH_CONTENT_STATISTICS'); ?></div>

<?php } ?>