<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

$params = JComponentHelper::getParams( 'com_invoices' );
$document	= JFactory::getDocument();

$tab = $this->input->getString('tab', 'recipient');

$modalname = "";
$task = "";
$modal = false;

if($this->input->getInt('modal')){
  $modal = true;
  $modalname = "_modal";
  $task = "save";
}

?>
<?php if($modal){ ?>
<script type="text/javascript">

  jQuery(document).ready(function() {
      var options = {
          //target:        '#output1',   // target element(s) to be updated with server response
          beforeSubmit:  showRequest<?php echo $modalname; ?>,  // pre-submit callback
          success:       showResponse<?php echo $modalname; ?>  // post-submit callback

          // other available options:
          //url:       url         // override for form's 'action' attribute
          //type:      type        // 'get' or 'post', override for form's 'method' attribute
          //dataType:  null        // 'xml', 'script', or 'json' (expected server response type)
          //clearForm: true        // clear all form fields after successful submit
          //resetForm: true        // reset the form after successful submit

          // $.ajax options can be used here too, for example:
          //timeout:   3000
      };

      // bind form using 'ajaxForm'
      jQuery('#adminForm<?php echo $modalname; ?>').ajaxForm(options);
  });

clearInterval(autosave_interval_id);

<?php if($params->get('autosave', 1) && $this->invoice->id){ ?>
if(!is_mobile()){
  autosave_interval_id = window.setInterval("save_invoice()", 10000);
}
<?php } ?>

</script>
<?php } ?>

<script type="text/javascript">
var numtaxes = <?php echo count($this->taxes); ?>;
</script>
<form action="index.php" method="post" name="adminForm<?php echo $modalname; ?>" id="adminForm<?php echo $modalname; ?>" enctype="multipart/form-data" class="form-horizontal">

  <?php echo $this->loadTemplate('tabs'); ?>

  <input type="hidden" name="option" value="com_invoices" />
  <input type="hidden" name="id" id="invoice_id" value="<?php echo $this->invoice->id; ?>" />
  <input type="hidden" name="task" value="<?php echo $task; ?>" />
  <input type="hidden" name="controller" value="invoice" />
  <input type="hidden" name="frominvoice" value="<?php echo $this->invoice->id; ?>" />
  <input type="hidden" name="tab" value="<?php echo $tab; ?>" /> 
  <?php if($modal){ ?>
  <input type="hidden" name="ajax" id="ajaxfield" value="1" />
  <?php } ?>

</form>