<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$params = JComponentHelper::getParams( 'com_invoices' );
?>
<div class=" invoice-manager" id="im-app">
  <form action="index.php" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data" class="form-horizontal">

    <div class="col-md-6">

      <fieldset>
        <legend><?php echo JText::_( 'DETAILS' ); ?></legend>

        <div class="form-group">
          <label class="control-label col-md-3" for="currency_name"> <?php echo JText::_( 'NAME' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="currency_name"
                    id="currency_name"
                    maxlength="255"
                    value="<?php echo $this->item->currency_name;?>" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="currency_code"> <?php echo JText::_( 'CURRENCY_CODE' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="currency_code"
                    id="currency_code"
                    maxlength="255"
                    <?php if($this->item->id){ ?>disabled="disabled"<?php } ?>
                    value="<?php echo $this->item->currency_code;?>" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="currency_symbol"> <?php echo JText::_( 'CURRENCY_SYMBOL' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="currency_symbol"
                    id="currency_symbol"
                    maxlength="255"
                    value="<?php echo $this->item->currency_symbol;?>" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="currency_published"> <?php echo JText::_( 'PUBLISHED' ); ?> </label>
          <div class="controls col-md-9">

            <?php
            $publish = "";
            $unpublish = "";
            if($this->item->currency_published) $publish = "checked='checked'";
            else $unpublish = "checked='checked'";

            ?>

            <div class="btn-group" >

              <label class="btn" for="checked_0" ><?php echo JText::_( 'JYES' ); ?>
                <input class="radio_toggle" type="radio" value="1" name="currency_published" id="checked_0" <?php echo $publish;?> />
              </label>
              <label class="btn" for="checked_1"><?php echo JText::_( 'JNO' ); ?>
                <input class="radio_toggle" type="radio" value="0" name="currency_published" id="checked_1" <?php echo $unpublish;?> /> </label>
              </div>

            </div>
          </div>

      </fieldset>

    </div>

    <div class="col-md-6">

      <fieldset>
        <legend><?php echo JText::_( 'DISPLAY_OPTIONS' ); ?></legend>

        <div class="form-group">
          <label class="control-label col-md-3" for="symbol_before"> <?php echo JText::_( 'DISPLAY_BEFORE' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="symbol_before"
                    id="symbol_before"
                    maxlength="255"
                    v-model="symbol_before" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="symbol_after"> <?php echo JText::_( 'DISPLAY_AFTER' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="symbol_after"
                    id="symbol_after"
                    maxlength="255"
                    v-model="symbol_after" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="decimals"> <?php echo JText::_( 'NUM_DECIMALS' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="number"
                    name="decimals"
                    id="decimals"
                    maxlength="255"
                    v-model="decimals" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="decpoint"> <?php echo JText::_( 'DECIMAL_POINT' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="decpoint"
                    id="decpoint"
                    maxlength="255"
                    v-model="decpoint" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="thousands"> <?php echo JText::_( 'THOUSANDS' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="thousands"
                    id="thousands"
                    maxlength="255"
                    v-model="thousands" />
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="negative_position"> <?php echo JText::_( 'NEGATIVE_POSITION' ); ?></label>
          <div class="controls col-md-9">
            <select  class="form-control"
                    type="text"
                    name="negative_position"
                    id="negative_position"
                    maxlength="255"
                    v-model="negative_position" >
              <option value="0"><?php echo JText::_( 'AFTER_SYMBOL' ); ?></option>
              <option value="1"><?php echo JText::_( 'BEFORE_SYMBOL' ); ?></option>
            </select>
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3"> <?php echo JText::_( 'FORMAT_EXAMPLE' ); ?></label>
          <div class="controls col-md-9">
            <p class="form-control-static">{{ 1234567.89 | currency }} | {{ -1234567.89 | currency }}</p>
          </div>
        </div>

      </fieldset>

    </div>

    <input type="hidden" name="option" value="com_invoices" />
    <input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="controller" value="currency" />
  </form>
</div>

<script>

  var vm = {
    symbol_before: "<?php echo $this->item->symbol_before;?>",
    symbol_after: "<?php echo $this->item->symbol_after;?>",
    decimals: "<?php echo $this->item->decimals;?>",
    decpoint: "<?php echo $this->item->decpoint;?>",
    thousands: "<?php echo $this->item->thousands;?>",
    negative_position: "<?php echo $this->item->negative_position;?>",
  };

  Vue.filter('currency', function (value) {
    return format_number_free(value, vm.symbol_before, vm.symbol_after, vm.decimals, vm.decpoint, vm.thousands, vm.negative_position);
  });

  new Vue({
    el: '#im-app',
    data: vm,

  });

</script>
