<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

$params = JComponentHelper::getParams( 'com_invoices' );

$modalname = "";
$task = "";
$modal = false;

if($this->input->getInt('modal')){
  $modal = true;
  $modalname = "_modal";
  $task = "save";
}

?>
<?php if($modal){ ?>
<script type="text/javascript">

jQuery(document).ready(function() {
  var options = {
          //target:        '#output1',   // target element(s) to be updated with server response
          beforeSubmit:  showRequest<?php echo $modalname; ?>,  // pre-submit callback
          success:       showResponse<?php echo $modalname; ?>  // post-submit callback

          // other available options:
          //url:       url         // override for form's 'action' attribute
          //type:      type        // 'get' or 'post', override for form's 'method' attribute
          //dataType:  null        // 'xml', 'script', or 'json' (expected server response type)
          //clearForm: true        // clear all form fields after successful submit
          //resetForm: true        // reset the form after successful submit

          // $.ajax options can be used here too, for example:
          //timeout:   3000
        };

      // bind form using 'ajaxForm'
      jQuery('#adminForm<?php echo $modalname; ?>').ajaxForm(options);
    });

</script>
<?php } ?>

<div class=" invoice-manager">
  <form action="index.php" method="post" name="adminForm<?php echo $modalname; ?>" id="adminForm<?php echo $modalname; ?>" enctype="multipart/form-data" class="form-horizontal">

    <div class="form-group">
      <label class="control-label col-md-3" for="name"> <?php echo JText::_( 'NAME' ); ?> </label>
      <div class="controls col-md-9">
        <input class="form-control" type="text" name="name" id="name" maxlength="250" value="<?php echo $this->contact->name;?>" <?php if(!$this->contact->id) echo "autofocus='autofocus'"; ?> />
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="company"> <?php echo JText::_( 'COMPANY' ); ?> </label>
      <div class="controls col-md-9">
        <input class="form-control" type="text" name="company" id="company" maxlength="250" value="<?php echo $this->contact->company;?>" />
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="address"> <?php echo JText::_( 'ADDRESS' ); ?> </label>
      <div class="controls col-md-9">
        <textarea class="form-control" name="address" id="address" cols="40" rows="4"><?php echo $this->contact->address; ?></textarea>
      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="email"> <?php echo JText::_( 'EMAIL' ); ?> </label>
      <div class="controls col-md-9">
        <input class="form-control" type="text" name="email" id="email"  maxlength="250" value="<?php echo $this->contact->email;?>" />
      </div>
    </div>

    <div class="form-group">
      <label class="control-label col-md-3" for="city"> <?php echo JText::_( 'LOCATION_CITY' ); ?> </label>
      <div class="controls col-md-9">

        <div class="row">
          <div class="col-xs-6">
            <input class="form-control " type="text" name="zipcode" id="zipcode" maxlength="250" value="<?php echo $this->contact->zipcode;?>" placeholder="<?php echo JText::_( 'RECIPIENT_ZIPCODE_PLACEHOLDER' ); ?>" />
          </div>
          <div class="col-xs-6">
            <input class="form-control " type="text" name="city" id="city"  maxlength="250" value="<?php echo $this->contact->city;?>" placeholder="<?php echo JText::_( 'RECIPIENT_CITY_PLACEHOLDER' ); ?>" />
          </div>
        </div>

      </div>
    </div>
    <div class="form-group">
      <label class="control-label col-md-3" for="country"> <?php echo JText::_( 'LOCATION_COUNTRY' ); ?> </label>
      <div class="controls col-md-9">
       <div class="row">
        <div class="col-xs-6">
          <input class="form-control " type="text" name="state" id="state" maxlength="250" value="<?php echo $this->contact->state;?>" placeholder="<?php echo JText::_( 'RECIPIENT_STATE_PLACEHOLDER' ); ?>" />
        </div>
        <div class="col-xs-6">
          <input class="form-control " type="text" name="country" id="country" maxlength="250" value="<?php echo $this->contact->country;?>" placeholder="<?php echo JText::_( 'RECIPIENT_COUNTRY_PLACEHOLDER' ); ?>" />
        </div>
      </div>
    </div>
  </div>
  <div class="form-group">
    <label class="control-label col-md-3" for="vatid"> <?php echo JText::_( 'VATID' ); ?> </label>
    <div class="controls col-md-9">
      <input class="form-control" type="text" name="vatid" id="vatid" maxlength="250" value="<?php echo $this->contact->vatid;?>" />
    </div>
  </div>
  <div class="form-group">
    <label class="control-label col-md-3" for="phone"> <?php echo JText::_( 'PHONE' ); ?> </label>
    <div class="controls col-md-9">
      <input class="form-control" type="text" name="phone" id="phone" maxlength="250" value="<?php echo $this->contact->phone;?>" />
    </div>
  </div>

  <hr />

  <div class="form-group">
    <label class="control-label col-md-3" > <?php echo JText::_( 'LINK_TO_JOOMLA_USER' ); ?> </label>
    <div class="controls col-md-9">

      <div class="btn-group" id="sign_group" data-toggle="buttons">

        <label class="btn btn-default <?php if($this->contact->user_id) echo "active"; ?>" for="vincular_cliente_checkbox" id="label_user"><?php echo JText::_( 'LINK_TO_JOOMLA_USER' ); ?>
          <input class="radio_toggle" type="radio" value="1" name="vincular_cliente_checkbox" id="vincular_cliente_checkbox" <?php if($this->contact->user_id) echo "checked='checked'"; ?> />
        </label>
        <label class="btn btn-default <?php if(!$this->contact->user_id) echo "active"; ?>" for="vincular_cliente_checkbox4"><?php echo JText::_( 'DO_NOT_LINK_TO_JOOMLA_USER' ); ?>
          <input class="radio_toggle" type="radio" value="0" name="vincular_cliente_checkbox" id="vincular_cliente_checkbox4" <?php if(!$this->contact->user_id) echo "checked='checked'"; ?> /> </label>

        </div>

      </div>
    </div>

    <div class="form-group">
      <label class="control-label col-md-3" > </label>

      <div class="controls col-md-9">
        <div class="row">

          <div class="col-md-4">

            <input type="text" class="form-control disabled" disabled="disabled" id="vincular_cliente" size="40" value="<?php if($this->contact->user_id) echo $this->contact->username . " [".$this->contact->user_id."]"; ?>" placeholder="<?php echo JText::_( 'JOOMLA_USERNAME_PLACEHOLDER' ); ?>" />
            <input class="inputbox input-mini small-margin-top" type="hidden" name="user_id" id="user_id" size="4" maxlength="11" value="<?php echo $this->contact->user_id;?>" />

          </div>

          <div class="col-md-8">

            <div class="controls">
              <input class="form-control" type="text" name="search_user" id="search_user"  value="" size="30" placeholder="<?php echo JText::_('TYPE_TO_SEARCH_USER'); ?>" />
            </div>

          </div>
        </div>
      </div>

    </div>

    <input type="hidden" name="option" value="com_invoices" />
    <input type="hidden" name="id" value="<?php echo $this->contact->id; ?>" />
    <input type="hidden" name="task" value="save" />
    <input type="hidden" name="controller" value="contact" />
    <?php if($modal){ ?>
    <input type="hidden" name="ajax" id="ajaxfield" value="1" />
    <?php } ?>
  </form>
</div>

<script type="text/javascript">

var usersBloodhound = new Bloodhound({
  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('name'),
  queryTokenizer: Bloodhound.tokenizers.whitespace,
  limit: 10,

  remote: {
    url: 'index.php?option=com_invoices&controller=contact&task=search_user&searchword=%QUERY',
    wildcard: '%QUERY'
  }
});

/**
 * Initializes the typeahead
 */
 function initializeUsernameTypeahead() {
  usersBloodhound.initialize();

  jQuery('#search_user').typeahead(null, {
    name: 'users',
    displayKey: 'thename',
    source: usersBloodhound.ttAdapter()
  }).on('typeahead:select', function(ev, suggestion) {

    load_user(suggestion);
  });
}

initializeUsernameTypeahead();

</script>
