<?php
//no direct access
defined('_JEXEC') or die('Restricted access.'); ?>
<div>

<div style="font-family: Helvetica;" v-if="invoice.template_id == 1">
  <div class="row-fluid">
    <div class="span6"><img :src="invoice.company_logo" alt="" /><br /> <br />
      <dl class="dl-horizontal">
        <dt>{{ 'FROM' | translate }}</dt>
        <dd><strong>{{ invoice.from_name }}</strong></dd>
        <dt>{{ 'ADDRESS' | translate }}</dt>
        <dd><address>{{ invoice.from_address }}</address></dd>
        <dt>{{ 'EMAIL' | translate }}</dt>
        <dd>{{ invoice.from_email }}</dd>
        <dt>{{ 'FISCAL_NUMBER' | translate }}</dt>
        <dd>{{ invoice.from_num }}</dd>
      </dl>
      <br />
      <div v-html="paynow_button"></div>
    </div>
    <div class="span6">
      <div class="well well-small" style="overflow: hidden;">
        <dl class="dl-horizontal">
          <dt>{{ 'INVOICE_NUM' | translate }}</dt>
          <dd>{{ invoice.invoice_num }}</dd>
          <dt>{{ 'INVOICE_DATE' | translate }}</dt>
          <dd>{{ invoice.invoice_date | date('D MMMM YYYY', undefined, invoice.language) }}</dd>
          <dt>{{ 'DUE_DATE' | translate }}</dt>
          <dd>{{ invoice.invoice_duedate | date('D MMMM YYYY', undefined, invoice.language) }}</dd>
          <dt>{{ 'INVOICE_TOTAL' | translate }}</dt>
          <dd>{{ total() | currency(invoice.currency_before, invoice.currency_after) }}</dd>
          <dt>{{ 'STATUS' | translate }}</dt>
          <dd><span :class="'label label-' + status_class">{{ status_name }}</span></dd>
        </dl>
      </div>
      <div class="well well-small" style="overflow: hidden;">
        <dl class="dl-horizontal">
          <dt>{{ 'BILL_TO' | translate }}</dt>
          <dd><strong>{{ invoice.to_name }}</strong></dd>
          <dt>{{ 'ADDRESS' | translate }}</dt>
          <dd><address>{{ invoice.to_company }} <br /> {{ invoice.to_address }} <br /> {{ invoice.to_zipcode }} {{ invoice.to_city }} <br /> {{ invoice.to_state }} {{ invoice.to_country }}</address></dd>
          <dt>{{ 'EMAIL' | translate }}</dt>
          <dd>{{ invoice.to_email }}</dd>
          <dt>{{ 'VATID' | translate }}</dt>
          <dd>{{ invoice.to_vatid }}</dd>
          <dt>{{ 'PHONE' | translate }}</dt>
          <dd>{{ invoice.to_phone }}</dd>
        </dl>
      </div>
    </div>
  </div>
  <h2 class="invoice_header">{{ 'ITEMS' | translate }}</h2>
  <table class="table table-striped" width="100%">
    <thead>
      <tr>
        <th align="left">{{ 'SKU' | translate }}</th>
        <th align="left">{{ 'DESCRIPTION' | translate }}</th>
        <th style="text-align: right;" align="right">{{ 'UNIT_COST' | translate }}</th>
        <th style="text-align: right;" align="right">{{ 'QUANTITY' | translate }}</th>
        <th style="text-align: right;" align="right">{{ 'DISCOUNT' | translate }}</th>
        <th style="text-align: right;" align="right">{{ 'TAX' | translate }}</th>
        <th style="text-align: right;" align="right">{{ 'PRICE' | translate }}</th>
      </tr>
    </thead>
    <tbody>
      <!--ITEMS-->
      <tr v-for="(item, index) in invoice.items">
        <td>{{ item.sku }}</td>
        <td><strong>{{ item.name }}</strong><br /> {{ item.desc }}</td>
        <td style="text-align: right;" align="right">{{ item.value | currency(invoice.currency_before, invoice.currency_after) }}</td>
        <td style="text-align: right;" align="right">{{ item.amount }}</td>
        <td style="text-align: right;" align="right">{{ item.discount | currency(invoice.currency_before, invoice.currency_after) }}</td>
        <td style="text-align: right;" align="right">{{ item.tax | currency(invoice.currency_before, invoice.currency_after) }}</td>
        <td style="text-align: right;" align="right">{{ totalItem(index) | currency(invoice.currency_before, invoice.currency_after) }}</td>
      </tr>
      <!--/ITEMS-->
    </tbody>
    <tfoot>
      <tr>
        <td colspan="4"> </td>
        <td style="text-align: right;" colspan="2" align="right">{{ 'DISCOUNT' | translate }}</td>
        <td style="text-align: right;" align="right">{{ invoice.discount | currency(invoice.currency_before, invoice.currency_after) }}</td>
      </tr>
      <tr>
        <td colspan="4"> </td>
        <td style="text-align: right;" colspan="2" align="right">{{ 'SUBTOTAL' | translate }}</td>
        <td style="text-align: right;" align="right">{{ subtotal_items() | currency(invoice.currency_before, invoice.currency_after) }}</td>
      </tr>
      <!--GROUPED_TAXES-->
      <tr v-for="(tax, index) in individualTaxes()">
        <td colspan="4"> </td>
        <td style="text-align: right;" colspan="2" align="right">{{ tax.name | translate }} ({{ tax.percent_value | taxpercentage }} {{ 'OF' | translate }} {{ tax.calculated_on_amount | currency(invoice.currency_before, invoice.currency_after) }})</td>
        <td style="text-align: right;" align="right">{{ tax.value | currency(invoice.currency_before, invoice.currency_after) }}</td>
      </tr>
      <!--/GROUPED_TAXES-->
      <!--GROUPED_TAXES_TOTAL-->
      <tr v-for="(tax, index) in invoice.individual_taxes_totals">
        <td colspan="4"></td>
        <td style="text-align: right;" colspan="2" align="right">{{ tax.name | translate }}</td>
        <td style="text-align: right;" align="right">{{ tax.value | currency(invoice.currency_before, invoice.currency_after) }}</td>
      </tr>
      <!--/GROUPED_TAXES_TOTAL-->
      <!--TAXES-->
      <tr v-for="(tax, index) in invoice.taxes" v-show="tax.active">
        <td colspan="4"> </td>
        <td style="text-align: right;" colspan="2" align="right">{{ tax.name }} ({{ tax.tax_value | taxpercentage }})</td>
        <td style="text-align: right;" align="right">{{ globaltax(tax.id) | currency(invoice.currency_before, invoice.currency_after) }}</td>
      </tr>
      <!--/TAXES-->
      <tr>
        <td colspan="4"> </td>
        <td style="text-align: right;" colspan="2" align="right"><strong>{{ 'TOTAL' | translate }}</strong></td>
        <td style="text-align: right;" align="right"><strong>{{ total() | currency(invoice.currency_before, invoice.currency_after) }}</strong></td>
      </tr>
    </tfoot>
  </table>
  <ul class="nav nav-tabs">
    <li><a href="#payments_received" data-toggle="tab">{{ 'PAYMENTS_RECEIVED' | translate }} {{ invoice.num_payments_received }}</a></li>
    <li class="active"><a href="#pending_payments" data-toggle="tab">{{ 'PENDING_PAYMENTS' | translate }} {{ invoice.num_pending_payments }}</a></li>
  </ul>
  <div class="tab-content">
    <div id="payments_received" class="tab-pane ">
      <table class="table table-striped " style="table-layout: fixed;" width="100%">
        <thead>
          <tr>
            <th align="left">{{ 'PAYMENT_DATE' | translate }}</th>
            <th align="left">{{ 'DESCRIPTION' | translate }}</th>
            <th align="left">{{ 'STATUS' | translate }}</th>
            <th align="left"> </th>
            <th style="text-align: right;" align="right">{{ 'AMOUNT' | translate }}</th>
          </tr>
        </thead>
        <tbody><!--PAYMENTS-->
          <tr v-for="(payment, index) in getPaidPayments()">
            <td>{{ payment.payment_datetime | date('D MMMM YYYY', undefined, invoice.language) }}</td>
            <td>{{ payment.payment_description }}</td>
            <td>{{ payment.payment_status }}</td>
            <td style="text-align: right;" align="right"><a class="btn btn-mini btn-default btn-xs" :href="invoice.payment_link"> {{ 'VIEW_DETAILS' | translate }}</a></td>
            <td style="text-align: right;" align="right">{{ payment.payment_amount | currency(invoice.currency_before, invoice.currency_after) }}</td>
          </tr>
          <!--/PAYMENTS-->
        </tbody>
        <tfoot>
          <tr>
            <td> </td>
            <td> </td>
            <td> </td>
            <td style="text-align: right;" align="right"><strong>{{ 'TOTAL_AMOUNT_PAID' | translate }}</strong></td>
            <td style="text-align: right;" align="right"><strong>{{ invoice.total_payments }}</strong></td>
          </tr>
        </tfoot>
      </table>
    </div>
    <div id="pending_payments" class="tab-pane active">
      <table class="table table-striped table-hover" style="table-layout: fixed;" width="100%">
        <thead>
          <tr>
            <th align="left">{{ 'DUE_DATE' | translate }}</th>
            <th align="left">{{ 'DESCRIPTION' | translate }}</th>
            <th align="left">{{ 'STATUS' | translate }}</th>
            <th align="left"> </th>
            <th style="text-align: right;" align="right">{{ 'AMOUNT' | translate }}</th>
          </tr>
        </thead>
        <tbody><!--PAYMENTS2-->
          <tr v-for="(payment, index) in getUnpaidPayments()">
            <td>{{ payment.payment_duedate | date('D MMMM YYYY', undefined, invoice.language) }}</td>
            <td>{{ payment.payment_description }}</td>
            <td>{{ payment.payment_status }}</td>
            <td style="text-align: right;" align="right"><a class="btn btn-info btn-mini btn-xs" :href="invoice.payment_link" target="_parent"> {{ 'PAY_NOW' | translate }}</a></td>
            <td style="text-align: right;" align="right">{{ payment.payment_amount | currency(invoice.currency_before, invoice.currency_after) }}</td>
          </tr>
          <!--/PAYMENTS2--></tbody>
          <tfoot>
            <tr>
              <td> </td>
              <td> </td>
              <td> </td>
              <td style="text-align: right;" align="right"><strong>{{ 'AMOUNT_OUTSTANDING' | translate }}</strong></td>
              <td style="text-align: right;" align="right"><strong>{{ invoice.total_unpaid | currency(invoice.currency_before, invoice.currency_after) }}</strong></td>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
    <div style="padding: 2px;">{{ 'NOTES' | translate }}</div>
    <div class="muted" style="border-top: 1px solid #000; padding: 2px;" ><small v-html="invoice.notes"></small></div>
  </div>


  <!--  SECOND TEMPLATE -->

  <div style="font-family: Helvetica;" v-if="invoice.template_id == 2">
    <div class="row-fluid">
      SECOND TEMPLATE
      <div class="span6"><img :src="invoice.company_logo" alt="" /><br /> <br />
        <dl class="dl-horizontal">
          <dt>{{ 'FROM' | translate }}</dt>
          <dd><strong>{{ invoice.from_name }}</strong></dd>
          <dt>{{ 'ADDRESS' | translate }}</dt>
          <dd><address>{{ invoice.from_address }}</address></dd>
          <dt>{{ 'EMAIL' | translate }}</dt>
          <dd>{{ invoice.from_email }}</dd>
          <dt>{{ 'FISCAL_NUMBER' | translate }}</dt>
          <dd>{{ invoice.from_num }}</dd>
        </dl>
      </div>

    </div>

  </div>

</div>
