<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$params = JComponentHelper::getParams( 'com_invoices' );

?>

<div>

  <form action="index.php"
        method="post"
        name="adminForm_modal"
        id="adminForm_modal"
        enctype="multipart/form-data"
        class="form-horizontal">

  <div class="form-group">
    <label class="control-label col-md-3" for="payment_amount"> <?php echo JText::_( 'AMOUNT' ); ?> </label>
    <div class="controls col-md-9">

      <div class="input-group">
        <span class="input-group-addon currency_before">{{ payment.currency_id | symbol_before }}</span>
        <input  class="form-control "
                type="number"
                name="payment_amount"
                id="payment_amount"
                size="10"
                maxlength="250"
                v-model="payment.payment_amount" />
        <span class="input-group-addon currency_after">{{ payment.currency_id | symbol_after }}</span>
      </div>

    </div>
  </div>
  <div class="form-group">
    <label class="control-label col-md-3" for="created_datetime"> <?php echo JText::_( 'PAYMENT_CREATION' ); ?> </label>
    <div class="controls col-md-9">

      <div class="input-group" >
        <input  class="form-control "
                type="text"
                name="created_datetime"
                id="created_datetime"
                data-date-format="yyyy-mm-dd"
                v-model="payment.created_datetime"
                placeholder="<?php echo JText::_( 'PAYMENT_CREATION' ); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="created_datetime_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
      </div>
    </div>
  </div>

  <div class="form-group">
    <label class="control-label col-md-3" for="payment_duedate"> <?php echo JText::_( 'DUE_DATE' ); ?> </label>
    <div class="controls col-md-9">

      <div class="input-group" >
        <input  class="form-control "
                type="text"
                name="payment_duedate"
                id="payment_duedate"
                data-date-format="yyyy-mm-dd"
                v-model="payment.payment_duedate"
                placeholder="<?php echo JText::_( 'DUE_DATE' ); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="payment_duedate_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
      </div>
    </div>
  </div>

  <div class="form-group">
    <label class="control-label col-md-3" for="payment_datetime"> <?php echo JText::_( 'PAYMENT_DATETIME' ); ?> </label>
    <div class="controls col-md-9">

      <div class="input-group" >
        <input  class="form-control "
                type="text"
                name="payment_datetime"
                id="payment_datetime"
                data-date-format="yyyy-mm-dd"
                v-model="payment.payment_datetime"
                placeholder="<?php echo JText::_( 'PAYMENT_DATETIME' ); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="payment_datetime_btn"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
      </div>
    </div>
  </div>

  <div class="form-group">
    <label class="control-label col-md-3" > <?php echo JText::_( 'PAID' ); ?> </label>
    <div class="controls col-md-9">
      <div class=" btn-group" data-toggle="buttons">
        <label  class="btn btn-default"
                :class="{active: payment.payment_status == 1}"
                for="publish1"
                @click="togglePublish(1)"> <?php echo JText::_('JYES'); ?>
          <input  class="radio_toggle"
                  type="radio"
                  :checked="payment.payment_status == 1"
                  value="1"
                  name="payment_status"
                  id="publish1"
                  autocomplete="off" /></label>
        <label  class="btn btn-default"
                :class="{active: payment.payment_status == 0}"
                for="publish0"
                @click="togglePublish(0)"> <?php echo JText::_('JNO'); ?>
          <input  class="radio_toggle"
                  type="radio"
                  :checked="payment.payment_status == 0"
                  value="0"
                  name="payment_status"
                  id="publish0"
                  autocomplete="off" /></label>
        <label  class="btn btn-default"
                :class="{active: payment.payment_status == 2}"
                for="publish2"
                @click="togglePublish(2)"> <?php echo JText::_('PENDING'); ?>
          <input  class="radio_toggle"
                  type="radio"
                  :checked="payment.payment_status == 2"
                  value="0"
                  name="payment_status"
                  id="publish2"
                  autocomplete="off" /></label>

            </div>
          </div>
        </div>

        <div class="form-group">
          <label class="control-label col-md-3" for="payment_description"> <?php echo JText::_( 'PAYMENT_DESCRIPTION' ); ?></label>
          <div class="controls col-md-9">
            <textarea name="payment_description"
                      id="payment_description"
                      class="form-control"
                      cols="40"
                      rows="4"
                      v-model="payment.payment_description"></textarea>
          </div>
        </div>
        <div class="form-group">
          <label class="control-label col-md-3" for="payment_type"> <?php echo JText::_( 'PAYMENT_METHOD' ); ?></label>
          <div class="controls col-md-9">
            <input  class="form-control"
                    type="text"
                    name="payment_type"
                    id="payment_type"
                    size="40"
                    maxlength="250"
                    v-model="payment.payment_type" />
          </div>
        </div>
        <div class="form-group">
          <label class="control-label col-md-3" for="payment_details"> <?php echo JText::_( 'PAYMENT_DETAILS' ); ?></label>
          <div class="controls col-md-9">
            <textarea name="payment_details"
                      id="payment_details"
                      class="form-control"
                      cols="40"
                      rows="10"
                      v-model="payment.payment_details"
                      ></textarea>
          </div>
        </div>
        <div class="form-group">
          <label class="control-label col-md-3" for="vincular_cliente_checkbox"> <?php echo JText::_( 'INVOICE' ); ?></label>
          <div class="controls col-md-3">
            <input  type="text"
                    class=" form-control disabled"
                    disabled="disabled"
                    id="name_invoice"
                    size="40"
                    :value="payment.invoice_id + ' [' + payment.invoice_num + '] ' + payment.to_name + ' (' + payment.username + ')'" />

          </div>
          <div class="controls col-md-2">
            <input  class="form-control"
                    type="text"
                    name="invoice_id"
                    id="invoice_id"
                    size="4"
                    maxlength="11"
                    v-model="payment.invoice_id" />
          </div>

          <div class="controls col-md-4">

            <input  class="form-control"
                    type="text"
                    name="search_invoice"
                    id="search_invoice"
                    value=""
                    placeholder="<?php echo JText::_('TYPE_TO_SEARCH'); ?>" />

          </div>

        </div>

        <input type="hidden" name="type" v-model="$parent.type" />

        <input type="hidden" name="option" value="com_invoices" />
        <input type="hidden" name="id" v-model="payment.id" />
        <input type="hidden" name="task" value="save" />
        <input type="hidden" name="controller" value="payment" />
        <input type="hidden" name="from" value="<?php echo $this->input->get('from'); ?>" />
        <input type="hidden" name="ajax" id="ajaxfield" value="1" />

      </form>

    </div>
