<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$params = JComponentHelper::getParams( 'com_invoices' );

?>

<div class="inner-buttonbar">
  <button class="btn btn-primary "
          @click.prevent="newPayment()" ><span class="glyphicon glyphicon-plus"></span> <?php echo JText::_('ADD_NEW_PAYMENT'); ?></button>
  <button class="btn btn-danger  pull-right"
          :disabled="!numSelectedPayments()"
          @click.prevent="deletePayments()"
          id="delete_payments_button" ><span class="glyphicon glyphicon-trash"></span> <?php echo JText::_('DELETE_SELECTED_PAYMENTS'); ?></button>
</div>
<table class="table table-striped" id="payments_table">
  <thead>
    <tr class="nodrag">
      <th width="20"></th>
      <th> <?php echo JText::_( 'DESCRIPTION' ); ?> </th>
      <th class="inputduedate"> <?php echo JText::_( 'DUE_DATE' ); ?> </th>
      <th class="hidden-sm"> <?php echo JText::_( 'PAYMENT_DATETIME' ); ?> </th>
      <th width="110"> <?php echo JText::_( 'PAID' ); ?> </th>
      <th width="20"> <?php echo JText::_( 'VALUE' ); ?> </th>
    </tr>
  </thead>
  <tbody id="payments-body">

      <tr :id="'paymentrow' + payment.id" v-for="(payment, index) in invoice.payments">
        <td>
          <input  type="checkbox"
                  :id="payment.prefix + 'pcb' + payment.id"
                  name="pid[]"
                  v-model="payment.selected"
                  :value="payment.id" />
        </td>
        <td>
          <input  class="form-control"
                  type="text"
                  :name="payment.prefix + 'payment_description_' + payment.id"
                  :id="payment.prefix + 'payment_description_' + payment.id"
                  placeholder="<?php echo JText::_('PAYMENT_DESCRIPTION');?>"
                  maxlength="255"
                  v-model="payment.payment_description" />
        </td>
        <td class="inputduedate">

          <div class="input-group" >
            <input  class="form-control "
                    type="text"
                    :name="payment.prefix + 'payment_duedate_' + payment.id"
                    :id="payment.prefix + 'payment_duedate_' + payment.id"
                    data-date-format="yyyy-mm-dd"
                    v-model="payment.payment_duedate"
                    :data-index="index"
                    placeholder="<?php echo JText::_('NOT_SETTED'); ?>"/>

            <span class="input-group-btn">
              <span class="btn btn-default"
                    :data-index="index"
                    :id="payment.prefix + 'payment_duedate_btn_' + payment.id"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
            </span>
          </div>

        </td>
        <td class="hidden-sm inputpaymentdate">

          <div class="input-group" >
            <input  class="form-control "
                    type="text"
                    :name="payment.prefix + 'payment_datetime_' + payment.id"
                    :id="payment.prefix + 'payment_datetime_' + payment.id"
                    data-date-format="yyyy-mm-dd"
                    v-model="payment.payment_datetime"
                    :data-index="index"
                    placeholder="<?php echo JText::_('NOT_SETTED'); ?>"/>

            <span class="input-group-btn">
              <span class="btn btn-default"
                    :data-index="index"
                    :id="payment.prefix + 'payment_datetime_btn_' + payment.id"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
            </span>
          </div>

        </td>
        <td>
          <div class="btn-group">
            <button type="button"
                    class="btn"
                    :class="{'btn-success active': payment.payment_status, 'btn-default': !payment.payment_status}"
                    @click="togglePaymentStatus(index,1)"><?php echo JText::_('JYES'); ?></button>
            <button type="button"
                    class="btn"
                    :class="{'btn-danger active': !payment.payment_status, 'btn-default': payment.payment_status}"
                    @click="togglePaymentStatus(index,0)"><?php echo JText::_('JNO'); ?></button>
          </div>
          <input  type="hidden"
                  :name="payment.prefix + 'payment_status_' + payment.id"
                  :value="payment.payment_status">
        </td>
        <td><div class="input-group"> <span class="input-group-addon currency_before" v-if="$options.filters.symbol_before(invoice.currency_id)">{{ invoice.currency_id | symbol_before }}</span>
          <input  class="form-control input-mini payments_amount"
                  type="number"
                  :name="payment.prefix + 'payment_value_' + payment.id"
                  :id="payment.prefix + 'payment_value_' + payment.id"
                  size="10"
                  maxlength="10"
                  v-model.number="payment.payment_amount" />
          <span class="input-group-addon currency_after" v-if="$options.filters.symbol_after(invoice.currency_id)">{{ invoice.currency_id | symbol_after }}</span> </div></td>
        </tr>

    </tbody>
    <tfoot>
      <tr class="nodrag">
        <td ></td>
        <td class="hidden-sm"></td>

        <td  class="invoice_total" colspan="3"><?php echo JText::_( 'PAYMENTS_TOTAL' ); ?></td>
        <td><div class="input-group"> <span class="input-group-addon currency_before" v-if="$options.filters.symbol_before(invoice.currency_id)">{{ invoice.currency_id | symbol_before }}</span>
          <input  class="form-control input-mini "
                  readonly
                  type="text"
                  id="payments_total"
                  size="4"
                  maxlength="10"
                  :value="invoice.totalPayments() | roundnumber" />
          <span class="input-group-addon currency_after" v-if="$options.filters.symbol_after(invoice.currency_id)">{{ invoice.currency_id | symbol_after }}</span> </div></td>
        </tr>
      </tfoot>
    </table>
    <div class="bs-callout bs-callout-info"><span class="label label-info"><?php echo JText::_('TIP'); ?></span>
      <label for="automatic_payment" class="">
        <input  type="checkbox" value="1" name="automatic_payment" id="automatic_payment" :checked="!invoice.id" />
        <? echo JText::_('CHECKBOX_AUTOMATIC_PAYMENT'); ?></label>
      </div>
