<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');
?>

<div class="inner-buttonbar" >
  <button class="btn btn-primary "
          type="button"
          @click.prevent="newItem()" >
    <span class="glyphicon glyphicon-plus"></span> <?php echo JText::_('ADD_NEW_ITEM'); ?></button>
  <button class="btn btn-danger pull-right "
          type="button"
          @click.prevent="deleteItems()"
          :disabled="!numSelectedItems()"
          id="delete_items_button" >
    <span class="glyphicon glyphicon-trash"></span> <?php echo JText::_('DELETE_SELECTED_ITEMS'); ?></button>
</div>

<div id="showalerts">
<?php foreach($this->taxes as $tax){ ?>
  <div  class="alert alert-warning"
        id="tax_alert_<?php echo $tax->id; ?>"
        v-show="showAlert(<?php echo $tax->id; ?>)">
    <strong><?php echo JText::_( 'WARNING' ); ?></strong> <?php echo JText::sprintf( 'WARNING_DUPLICITY', $tax->name ); ?></div>
<?php } ?>
</div>

<table class="table table-striped table-hover" id="items_table">
  <thead>
    <tr class="nodrag">
      <th width="20"></th>
      <th width="" > <span class="th_value"><?php echo JText::_( 'VALUE' ); ?></span> <span class="th_qty"><?php echo JText::_( 'QUANTITY' ); ?></span> <span class="th_discount"><?php echo JText::_( 'DISCOUNT' ); ?></span> <span class="th_tax"><?php echo JText::_( 'TAX' ); ?></span> </th>
      <th width="160"> <?php echo JText::_( 'TOTAL' ); ?> </th>
    </tr>
  </thead>

  <tfoot>

    <tr class="nodrag">
      <td></td>
      <td class="invoice_discount"><?php echo JText::_( $this->layout_type.'_DISCOUNT' ); ?></td>
      <td>
        <div class="input-group">
          <span class="input-group-addon currency_before" v-if="$options.filters.symbol_before(invoice.currency_id)">{{ invoice.currency_id | symbol_before }}</span>
          <input  class="form-control input-mini "
                  placeholder="<?php echo JText::_( 'ZERO_AMOUNT' ); ?>"
                  type="number"
                  id="discount"
                  name="discount"
                  maxlength="10"
                  v-model="invoice.discount" />
          <span class="input-group-addon currency_after" v-if="$options.filters.symbol_after(invoice.currency_id)">{{ invoice.currency_id | symbol_after }}</span>
        </div>
      </td>
    </tr>

    <tr class="nodrag">
      <td></td>
      <td class="invoice_subtotal"><?php echo JText::_( $this->layout_type.'_SUBTOTAL' ); ?></td>
      <td>
        <div class="input-group">
          <span class="input-group-addon currency_before" v-if="$options.filters.symbol_before(invoice.currency_id)">{{ invoice.currency_id | symbol_before }}</span>
          <input  class="form-control input-mini "
                  readonly
                  type="text"
                  id="invoice_subtotal"
                  maxlength="10"
                  :value="invoice.subtotal() | roundnumber" />
          <span class="input-group-addon currency_after" v-if="$options.filters.symbol_after(invoice.currency_id)">{{ invoice.currency_id | symbol_after }}</span>
        </div>
      </td>
    </tr>

    <?php
    for ($i=0, $n=count( $this->alltaxes );$i < $n; $i++)	{
      $row = &$this->alltaxes[$i];

      if($row->type == "percent") $percent = "%" ;
      else $percent = "";

      ?>
      <tr class="nodrag">
        <td></td>
        <td class="invoice_tax">

          <div class="row">
            <div class="col-xs-8">
              <label for="tax_<?php echo $row->id;?>" class="control-label"><?php echo $row->name;?></label>
            </div>
            <div class="col-xs-4">
              <div class="input-group">
                <span class="input-group-addon">
                  <input  type="checkbox"
                          class="checkbox_tax"
                          name="taxes[]"
                          value="<?php echo $row->id;?>"
                          v-model="invoice.taxes[<?php echo $row->id;?>].active"
                          id="tax_<?php echo $row->id;?>"
                          data-type="<?php echo $row->type;?>" />
                </span>
                <input  class="form-control input-mini"
                        type="number"
                        id="tax_value_<?php echo $row->id;?>"
                        name="tax_value_<?php echo $row->id;?>"
                        maxlength="10"
                        v-model="invoice.taxes[<?php echo $row->id;?>].tax_value"
                        placeholder="<?php echo JText::_( 'ZERO_AMOUNT' ); ?>" />
                <span class="input-group-addon"><?php echo $percent ? $percent : "&nbsp;" ?></span>
              </div>
            </div>
          </div>

        </td>
       <td>
        <div class="input-group">
          <span class="input-group-addon currency_before" v-if="$options.filters.symbol_before(invoice.currency_id)">{{ invoice.currency_id | symbol_before }}</span>
          <input  class="form-control input-mini "
                  readonly
                  type="text"
                  id="tax_display_<?php echo $row->id;?>"
                  maxlength="10"
                  :value="invoice.globaltax(<?php echo $row->id;?>) | roundnumber" />
          <span class="input-group-addon currency_after" v-if="$options.filters.symbol_after(invoice.currency_id)">{{ invoice.currency_id | symbol_after }}</span>
        </div>
      </td>
  </tr>

  <?php } ?>

    <tr class="nodrag">
      <td></td>
      <td class="invoice_total"><?php echo JText::_( $this->layout_type.'_TOTAL' ); ?></td>
      <td>
        <div class="input-group">
          <span class="input-group-addon currency_before" v-if="$options.filters.symbol_before(invoice.currency_id)">{{ invoice.currency_id | symbol_before }}</span>
          <input  class="form-control input-mini "
                  readonly
                  type="text"
                  id="invoice_total"
                  maxlength="10"
                  :value="invoice.thetotal() | roundnumber" />
          <span class="input-group-addon currency_after" v-if="$options.filters.symbol_after(invoice.currency_id)">{{ invoice.currency_id | symbol_after }}</span>
        </div>
      </td>
    </tr>
  </tfoot>

<tbody id="items-body">

    <tr :id="'itemrow' + item.id" v-for="(item, index) in invoice.items" :data-id="item.id">

      <td>
        <div class="checkbox">
          <input  type="checkbox"
                  :id="item.prefix + 'icb' + item.id"
                  name="iid[]"
                  v-model="item.selected"
                  @click="numSelectedItems()"
                  :value="item.id" />
        </div>

        <input  type="hidden"
                :name="item.prefix + 'external_type_' + item.id"
                :id="item.prefix + 'external_type_' + item.id"
                v-model="item.external_type" />
        <input  type="hidden"
                :name="item.prefix + 'product_id_' + item.id"
                :id="item.prefix + 'product_id_' + item.id"
                v-model="item.product_id" />
        <input  type="hidden"
                class="tax_id_input"
                :name="item.prefix + 'tax_id_' + item.id"
                :id="item.prefix + 'tax_id_' + item.id"
                v-model="item.tax_id" />
      </td>

      <td class="form-horizontal">

        <div class="input-group">
         <input class="form-control input-mini items_value"
                type="number"
                placeholder="<?php echo JText::_('VALUE');?>"
                :name="item.prefix + 'value_' + item.id"
                :id="item.prefix + 'value_' + item.id"
                maxlength="10"
                v-model.number="item.value" />
         <span class="input-group-addon ">x</span>
         <input class="form-control input-mini items_amount"
                type="number"
                placeholder="<?php echo JText::_('QTY');?>"
                :name="item.prefix + 'amount_' + item.id"
                :id="item.prefix + 'amount_' + item.id"
                maxlength="10"
                v-model.number="item.amount" />
         <span class="input-group-addon ">-</span>
         <input class="form-control input-mini items_discount"
                type="number"
                placeholder="<?php echo JText::_('DISCOUNT');?>"
                :name="item.prefix + 'discount_' + item.id"
                :id="item.prefix + 'discount_' + item.id"
                maxlength="10"
                v-model.number="item.discount" />
         <span class="input-group-addon ">+</span>

         <div class="input-group-btn tax-selector-dropdown">
            <button type="button"
                    class="btn btn-default dropdown-toggle"
                    data-toggle="dropdown"
                    aria-haspopup="true"
                    aria-expanded="false">
                    <span class="tax-selector-title">{{ item.tax_id | taxname }}</span> <span class="caret"></span></button>
            <ul class="dropdown-menu">
              <li>
                <a  class="noHrefLink"
                    @click="set_item_tax(item.id,0,index)"
                    href="#"><?php echo JText::_('JNO');?></a></li>
              <li v-for="tax in $parent.alltaxes">
                <a  class="noHrefLink"
                    @click="set_item_tax(item.id,tax.id,index)"
                    href="#"
                >{{ tax.name }}</a>
              </li>
            </ul>
          </div>

         <input class="form-control input-mini items_tax"
                type="number"
                placeholder="<?php echo JText::_('TAX');?>"
                :name="item.prefix + 'tax_' + item.id"
                :id="item.prefix + 'tax_' + item.id"
                maxlength="10"
                v-model.number="item.tax" />
         <span class="input-group-addon ">%</span>
       </div>

       <div class="row">
         <div class="form-group ">

          <div class="col-xs-9 name-container">
            <input  class="form-control input-name"
                    type="text"
                    placeholder="<?php echo JText::_('NAME');?>"
                    :name="item.prefix + 'name_' + item.id"
                    :id="item.prefix + 'name_' + item.id"
                    maxlength="255"
                    :data-index="index"
                    v-model="item.name" />
          </div>

          <div class="col-xs-3 sku-container">
            <input  class="form-control input-mini input-sku "
                    type="text"
                    placeholder="<?php echo JText::_('SKU');?>"
                    :name="item.prefix + 'sku_' + item.id"
                    :id="item.prefix + 'sku_' + item.id"
                    maxlength="255"
                    v-model="item.sku" />
          </div>

        </div>
      </div>

      <div class="form-group">
        <div class="col-xs-12 desc-container">
          <input  class="form-control input-desc"
                  type="text"
                  placeholder="<?php echo JText::_('DESCRIPTION');?>"
                  :name="item.prefix + 'description_' + item.id"
                  :id="item.prefix + 'description_' + item.id"
                  maxlength="255"
                  v-model="item.desc" />
        </div>

      </div>

    </td>

    <td>

      <div class="input-group">
        <span class="input-group-addon currency_before" v-if="$options.filters.symbol_before(invoice.currency_id)">{{ invoice.currency_id | symbol_before }}</span>
        <input  class="form-control input-mini items_total"
                readonly
                type="text"
                :name="item.prefix + 'total_' + item.id"
                :id="item.prefix + 'total_' + item.id"
                maxlength="10"
                :value="invoice.totalItem(index) | roundnumber" />
        <span class="input-group-addon currency_after" v-if="$options.filters.symbol_after(invoice.currency_id)">{{ invoice.currency_id | symbol_after }}</span>
      </div>

    </td>
  </tr>

</tbody>

</table>

<div class="bs-callout bs-callout-info"><span class="label label-info"><?php echo JText::_('TIP'); ?></span> <?php echo JText::_('DRAG_ROWS'); ?></div>
