<table class="table table-hover" v-if="contact.invoices.length">

  <tbody id="invoices-body">

    <thead>
      <tr>
        <th><?php echo JText::_('INVOICE_NUM'); ?></th>
        <th class="hidden-xs"><?php echo JText::_('RECIPIENT_NAME'); ?></th>
        <th colspan="2" class=" hidden-xs"><?php echo JText::_('STATUS'); ?></th>
        <?php if($this->params->get('sourcecolumn')){ ?>
        <th class="hidden-xs"><?php echo JText::_('EXTERNAL_TYPE'); ?></th>
        <?php } ?>
        <th class="hidden-xs text-right"><?php echo JText::_('SUBTOTAL'); ?></th>

        <th class="hidden-xs text-right"
            v-for="thetax in $root.alltaxes"
            v-show="$root.display_tax(thetax.id)"> {{ thetax.name }}</th>

        <th class=" text-right "><?php echo JText::_('TOTAL'); ?></th>
        <th></th>
        <?php if(InvoicesHelper::pdf_enabled()){?>
        <th class="hidden-xs"></th>
        <?php } ?>

      </tr>
    </thead>

    <tr
      v-for="invoice in contact.invoices"
      is="invoice"
      :invoice="invoice"
      :id="'row' + invoice.id"
      :data-value="invoice.amount"
      class='item-row'
      :extended="false"
    >
    </tr>

  </tbody>

</table>

<div class="muted center" v-else>
  <?php echo JText::_('NO_INVOICES_FOR_CONTACT'); ?>
  <br /><br />

  <a  :href="'index.php?option=com_invoices&controller=invoices&do=new_invoice&from=' + contact.id"
      class="btn btn-primary"
      title="<?php echo JText::_('CREATE_INVOICE_FOR_CONTACT');?>">
      <?php echo JText::_('CREATE_INVOICE_FOR_CONTACT');?>
  </a>
</div>
