<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport('joomla.filesystem.file');

class TableTemplate extends JTable
{

	var $id = null;

	var $name = null;
	var $content = null;
	var $taxes = null;
	var $items = null;
	var $payments = null;

	var $payments2 = null;
	var $styles = null;
	var $content_pdf = null;
	var $company_logo = null;
	var $content_email = null;
	var $content_vue = null;

	var $attachment_file = null;

	function __construct(& $db) {
		parent::__construct('#__invoices_templates', 'id', $db);
	}

	function check(){

		$app = JFactory::getApplication();

		/*Check if the company_logo is an allowed type*/
		$allowed_types = array("image/jpeg", "image/png", "image/gif", "image/jpg", "image/svg+xml");
		if($this->attachment_file["name"] != ""){
			if (in_array($this->attachment_file["type"], $allowed_types)){
				$success=false;
				$success = $this->saveAttachment($this->attachment_file);
				if($success) $this->company_logo = $success;
			}
			else {
				$msg = JText::sprintf("FILETYPE_NOT_ALLOWED", $this->attachment_file["name"]);
				$type = "message";
				$app->enqueueMessage($msg, $type);
			}
		}

		$this->attachment_file = null;

		return true;
	}

	private function saveAttachment($file)
	{
		$filename = $file["name"];

		if ($file["error"] > 0){
			return false;
		} else {
			if (file_exists(JPATH_SITE . "/media/com_invoices/" . $filename))
				$filename = time() . "_" . $filename;

			move_uploaded_file($file["tmp_name"], JPATH_SITE . "/media/com_invoices/" . $filename);
			return $filename;
		}
	}

}
