ALTER TABLE `#__invoices_templates` ADD `content_email` TEXT NOT NULL;

ALTER TABLE `#__invoices_invoices` ADD `currency_id` INT(11) NOT NULL;

ALTER TABLE `#__invoices_contacts` ADD `params` TEXT NOT NULL;

ALTER TABLE `#__invoices_tax_invoice` CHANGE `value` `value` DECIMAL(12,4) NOT NULL;

--
-- Estructura de la taula `jos_invoices_currencies`
--

CREATE TABLE IF NOT EXISTS `#__invoices_currencies` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `currency_symbol` varchar(255) NOT NULL,
  `currency_code` varchar(255) NOT NULL,
  `currency_format` char(10) NOT NULL DEFAULT '%i',
  `currency_name` varchar(255) NOT NULL,
  `currency_published` tinyint(4) NOT NULL DEFAULT '0',
  `currency_rate` decimal(16,5) NOT NULL DEFAULT '1.00000',
  `currency_locale` text NOT NULL,
  `currency_displayed` tinyint(4) NOT NULL DEFAULT '0',
  `currency_percent_fee` decimal(4,2) NOT NULL DEFAULT '0.00',
  `currency_modified` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `symbol_before` varchar(15) NOT NULL,
  `symbol_after` varchar(15) NOT NULL,
  `decimals` int(1) NOT NULL,
  `decpoint` varchar(7) NOT NULL,
  `thousands` varchar(7) NOT NULL,
  `negative_position` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `currency_code` (`currency_code`)
) ENGINE=MyISAM;

--
-- Bolcant dades de la taula `jos_invoices_currencies`
--

INSERT INTO `#__invoices_currencies` (`id`, `currency_symbol`, `currency_code`, `currency_format`, `currency_name`, `currency_published`, `currency_rate`, `currency_locale`, `currency_displayed`, `currency_percent_fee`, `currency_modified`, `symbol_before`, `symbol_after`, `decimals`, `decpoint`, `thousands`, `negative_position`) VALUES
(1, '€', 'EUR', '%n', 'Euro', 1, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\",\";s:17:\"mon_thousands_sep\";s:1:\".\";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:2;s:11:\"frac_digits\";i:2;s:13:\"p_cs_precedes\";i:0;s:14:\"p_sep_by_space\";i:1;s:13:\"n_cs_precedes\";i:0;s:14:\"n_sep_by_space\";i:1;s:11:\"p_sign_posn\";i:1;s:11:\"n_sign_posn\";i:1;}', 1, '0.00', 1467971879, '', '€', 2, ',', '.', 0),
(2, '$', 'USD', '%n', 'United States dollar', 1, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\".\";s:17:\"mon_thousands_sep\";s:1:\",\";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:2;s:11:\"frac_digits\";i:2;s:13:\"p_cs_precedes\";i:1;s:14:\"p_sep_by_space\";i:0;s:13:\"n_cs_precedes\";i:1;s:14:\"n_sep_by_space\";i:0;s:11:\"p_sign_posn\";i:4;s:11:\"n_sign_posn\";i:4;}', 1, '0.00', 0, '$', '', 2, '.', ',', 0),
(3, '¥', 'JPY', '%n', 'Japanese yen', 1, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\",\";s:17:\"mon_thousands_sep\";s:1:\" \";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:0;s:11:\"frac_digits\";i:0;s:13:\"p_cs_precedes\";i:0;s:14:\"p_sep_by_space\";i:1;s:13:\"n_cs_precedes\";i:0;s:14:\"n_sep_by_space\";i:1;s:11:\"p_sign_posn\";i:1;s:11:\"n_sign_posn\";i:1;}', 0, '0.00', 0, '¥', '', 2, '.', ',', 0),
(4, '£', 'GBP', '%n', 'British pound', 1, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\".\";s:17:\"mon_thousands_sep\";s:1:\",\";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:2;s:11:\"frac_digits\";i:2;s:13:\"p_cs_precedes\";i:1;s:14:\"p_sep_by_space\";i:1;s:13:\"n_cs_precedes\";i:1;s:14:\"n_sep_by_space\";i:1;s:11:\"p_sign_posn\";i:1;s:11:\"n_sign_posn\";i:1;}', 0, '0.00', 0, '£', '', 2, ',', '.', 1),
(5, '$', 'CAD', '%i', 'Canadian dollar', 0, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\".\";s:17:\"mon_thousands_sep\";s:1:\",\";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:2;s:11:\"frac_digits\";i:2;s:13:\"p_cs_precedes\";i:1;s:14:\"p_sep_by_space\";i:0;s:13:\"n_cs_precedes\";i:1;s:14:\"n_sep_by_space\";i:0;s:11:\"p_sign_posn\";i:4;s:11:\"n_sign_posn\";i:4;}', 0, '0.00', 0, '$', 'CAD', 2, '.', ',', 0),
(6, '$', 'AUD', '%i', 'Australian dollar', 0, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\".\";s:17:\"mon_thousands_sep\";s:1:\",\";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:2;s:11:\"frac_digits\";i:2;s:13:\"p_cs_precedes\";i:1;s:14:\"p_sep_by_space\";i:0;s:13:\"n_cs_precedes\";i:1;s:14:\"n_sep_by_space\";i:0;s:11:\"p_sign_posn\";i:4;s:11:\"n_sign_posn\";i:4;}', 0, '0.00', 0, '$', 'AUD', 2, '.', ',', 0),
(7, '$', 'NZD', '%i', 'New Zealand dollar', 0, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\",\";s:17:\"mon_thousands_sep\";s:1:\".\";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:2;s:11:\"frac_digits\";i:2;s:13:\"p_cs_precedes\";i:1;s:14:\"p_sep_by_space\";i:0;s:13:\"n_cs_precedes\";i:1;s:14:\"n_sep_by_space\";i:0;s:11:\"p_sign_posn\";i:4;s:11:\"n_sign_posn\";i:4;}', 0, '0.00', 0, '$', 'NZD', 2, '.', ',', 0),
(8, '؋', 'AFN', '%i', 'Afghan afghani', 0, '1.00000', '', 0, '0.00', 0, '؋', 'AFN', 2, '.', ',', 0),
(9, 'Lek', 'ALL', '%i', 'Albanian lek', 0, '1.00000', '', 0, '0.00', 0, 'Lek', 'ALL', 2, '.', ',', 0),
(10, 'د.ج', 'DZD', '%i', 'Algerian dinar', 0, '1.00000', '', 0, '0.00', 0, 'د.ج', 'DZD', 2, '.', ',', 0),
(11, 'Kz ', 'AOA', '%i', 'Angolan kwanza', 0, '1.00000', '', 0, '0.00', 0, 'Kz ', 'AOA', 2, '.', ',', 0),
(12, '$', 'ARS', '%i', 'Argentine peso', 0, '1.00000', '', 0, '0.00', 0, '$', 'ARS', 2, '.', ',', 0),
(13, 'դր.', 'AMD', '%i', 'Armenian dram', 0, '1.00000', '', 0, '0.00', 0, 'դր.', 'AMD', 2, '.', ',', 0),
(14, 'ƒ', 'AWG', '%i', 'Aruban florin', 0, '1.00000', '', 0, '0.00', 0, 'ƒ', 'AWG', 2, '.', ',', 0),
(15, 'ман', 'AZN', '%i', 'Azerbaijani manat', 0, '1.00000', '', 0, '0.00', 0, 'ман', 'AZN', 2, '.', ',', 0),
(16, '$', 'BSD', '%i', 'Bahamian dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'BSD', 2, '.', ',', 0),
(17, 'ب.د', 'BHD', '%i', 'Bahraini dinar', 0, '1.00000', '', 0, '0.00', 0, 'ب.د', 'BHD', 2, '.', ',', 0),
(18, '৳', 'BDT', '%i', 'Bangladeshi taka', 0, '1.00000', '', 0, '0.00', 0, '৳', 'BDT', 2, '.', ',', 0),
(19, '$', 'BBD', '%i', 'Barbadian dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'BBD', 2, '.', ',', 0),
(20, 'p.', 'BYR', '%i', 'Belarusian ruble', 0, '1.00000', '', 0, '0.00', 0, 'p.', 'BYR', 2, '.', ',', 0),
(21, 'BZ$', 'BZD', '%i', 'Belize dollar', 0, '1.00000', '', 0, '0.00', 0, 'BZ$', 'BZD', 2, '.', ',', 0),
(22, '$', 'BMD', '%i', 'Bermudian dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'BMD', 2, '.', ',', 0),
(23, 'BTN', 'BTN', '%i', 'Bhutanese ngultrum', 0, '1.00000', '', 0, '0.00', 0, 'BTN', 'BTN', 2, '.', ',', 0),
(24, '$b', 'BOB', '%i', 'Bolivian boliviano', 0, '1.00000', '', 0, '0.00', 0, '$b', 'BOB', 2, '.', ',', 0),
(25, 'XBA', 'XBA', '%i', 'Bond Markets', 0, '1.00000', '', 0, '0.00', 0, 'XBA', 'XBA', 2, '.', ',', 0),
(26, 'KM', 'BAM', '%i', 'Bosnia and Herzegovina convert', 0, '1.00000', '', 0, '0.00', 0, 'KM', 'BAM', 2, '.', ',', 0),
(27, 'P', 'BWP', '%i', 'Botswana pula', 0, '1.00000', '', 0, '0.00', 0, 'P', 'BWP', 2, '.', ',', 0),
(28, 'R$', 'BRL', '%i', 'Brazilian real', 0, '1.00000', '', 0, '0.00', 0, 'R$', 'BRL', 2, '.', ',', 0),
(29, '$', 'BND', '%i', 'Brunei dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'BND', 2, '.', ',', 0),
(30, 'лв', 'BGN', '%i', 'Bulgarian lev', 0, '1.00000', '', 0, '0.00', 0, 'лв', 'BGN', 2, '.', ',', 0),
(31, 'Fr ', 'BIF', '%i', 'Burundian franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'BIF', 2, '.', ',', 0),
(32, '៛', 'KHR', '%i', 'Cambodian riel', 0, '1.00000', '', 0, '0.00', 0, '៛', 'KHR', 2, '.', ',', 0),
(33, '$', 'CVE', '%i', 'Cape Verdean escudo', 0, '1.00000', '', 0, '0.00', 0, '$', 'CVE', 2, '.', ',', 0),
(34, '$', 'KYD', '%i', 'Cayman Islands dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'KYD', 2, '.', ',', 0),
(35, 'Fr ', 'XAF', '%i', 'Central African CFA franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'XAF', 2, '.', ',', 0),
(36, 'Fr ', 'XPF', '%i', 'CFP franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'XPF', 2, '.', ',', 0),
(37, '$', 'CLP', '%i', 'Chilean peso', 0, '1.00000', '', 0, '0.00', 0, '$', 'CLP', 2, '.', ',', 0),
(38, '元', 'CNY', '%i', 'Chinese renminbi yuan', 0, '1.00000', '', 0, '0.00', 0, '元', 'CNY', 2, '.', ',', 0),
(39, 'XTS', 'XTS', '%i', 'Codes specif', 0, '1.00000', '', 0, '0.00', 0, 'XTS', 'XTS', 2, '.', ',', 0),
(40, '$', 'COP', '%i', 'Colombian peso', 0, '1.00000', '', 0, '0.00', 0, '$', 'COP', 2, '.', ',', 0),
(41, 'Fr ', 'KMF', '%i', 'Comorian franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'KMF', 2, '.', ',', 0),
(42, 'Fr ', 'CDF', '%i', 'Congolese franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'CDF', 2, '.', ',', 0),
(43, '₡', 'CRC', '%i', 'Costa Rican colón', 0, '1.00000', '', 0, '0.00', 0, '₡', 'CRC', 2, '.', ',', 0),
(44, 'kn', 'HRK', '%i', 'Croatian kuna', 0, '1.00000', '', 0, '0.00', 0, 'kn', 'HRK', 2, '.', ',', 0),
(45, '₱', 'CUP', '%i', 'Cuban peso', 0, '1.00000', '', 0, '0.00', 0, '₱', 'CUP', 2, '.', ',', 0),
(46, 'Kč', 'CZK', '%i', 'Czech koruna', 0, '1.00000', '', 0, '0.00', 0, 'Kč', 'CZK', 2, '.', ',', 0),
(47, 'kr', 'DKK', '%i', 'Danish krone', 0, '1.00000', '', 0, '0.00', 0, 'kr', 'DKK', 2, '.', ',', 0),
(48, 'Fr ', 'DJF', '%i', 'Djiboutian franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'DJF', 2, '.', ',', 0),
(49, 'RD$', 'DOP', '%i', 'Dominican peso', 0, '1.00000', '', 0, '0.00', 0, 'RD$', 'DOP', 2, '.', ',', 0),
(50, '$', 'XCD', '%i', 'East Caribbean dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'XCD', 2, '.', ',', 0),
(51, '£', 'EGP', '%i', 'Egyptian pound', 0, '1.00000', '', 0, '0.00', 0, '£', 'EGP', 2, '.', ',', 0),
(52, 'Nfk ', 'ERN', '%i', 'Eritrean nakfa', 0, '1.00000', '', 0, '0.00', 0, 'Nfk ', 'ERN', 2, '.', ',', 0),
(53, 'kr', 'EEK', '%i', 'Estonian kroon', 0, '1.00000', '', 0, '0.00', 0, 'kr', 'EEK', 2, '.', ',', 0),
(54, 'ETB', 'ETB', '%i', 'Ethiopian birr', 0, '1.00000', '', 0, '0.00', 0, 'ETB', 'ETB', 2, '.', ',', 0),
(55, 'XBB', 'XBB', '%i', 'European Mon', 0, '1.00000', '', 0, '0.00', 0, 'XBB', 'XBB', 2, '.', ',', 0),
(56, 'XBD', 'XBD', '%i', 'European Uni', 0, '1.00000', '', 0, '0.00', 0, 'XBD', 'XBD', 2, '.', ',', 0),
(57, 'XBC', 'XBC', '%i', 'European Uni', 0, '1.00000', '', 0, '0.00', 0, 'XBC', 'XBC', 2, '.', ',', 0),
(58, '£', 'FKP', '%i', 'Falkland pound', 0, '1.00000', '', 0, '0.00', 0, '£', 'FKP', 2, '.', ',', 0),
(59, '$', 'FJD', '%i', 'Fijian dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'FJD', 2, '.', ',', 0),
(60, 'D ', 'GMD', '%i', 'Gambian dalasi', 0, '1.00000', '', 0, '0.00', 0, 'D ', 'GMD', 2, '.', ',', 0),
(61, 'ლ', 'GEL', '%i', 'Georgian lari', 0, '1.00000', '', 0, '0.00', 0, 'ლ', 'GEL', 2, '.', ',', 0),
(62, '₵', 'GHS', '%i', 'Ghanaian cedi', 0, '1.00000', '', 0, '0.00', 0, '₵', 'GHS', 2, '.', ',', 0),
(63, '£', 'GIP', '%i', 'Gibraltar pound', 0, '1.00000', '', 0, '0.00', 0, '£', 'GIP', 2, '.', ',', 0),
(64, 'Gold', 'XAU', '%i', 'Gold', 0, '1.00000', '', 0, '0.00', 0, 'Gold', 'XAU', 2, '.', ',', 0),
(65, 'Q', 'GTQ', '%i', 'Guatemalan quetzal', 0, '1.00000', '', 0, '0.00', 0, 'Q', 'GTQ', 2, '.', ',', 0),
(66, 'GWP', 'GWP', '%i', 'Guinea-Bissa', 0, '1.00000', '', 0, '0.00', 0, 'GWP', 'GWP', 2, '.', ',', 0),
(67, 'Fr ', 'GNF', '%i', 'Guinean franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'GNF', 2, '.', ',', 0),
(68, '$', 'GYD', '%i', 'Guyanese dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'GYD', 2, '.', ',', 0),
(69, 'G ', 'HTG', '%i', 'Haitian gourde', 0, '1.00000', '', 0, '0.00', 0, 'G ', 'HTG', 2, '.', ',', 0),
(70, 'L', 'HNL', '%i', 'Honduran lempira', 0, '1.00000', '', 0, '0.00', 0, 'L', 'HNL', 2, '.', ',', 0),
(71, '元', 'HKD', '%i', 'Hong Kong dollar', 0, '1.00000', '', 0, '0.00', 0, '元', 'HKD', 2, '.', ',', 0),
(72, 'Ft', 'HUF', '%i', 'Hungarian forint', 0, '1.00000', '', 0, '0.00', 0, 'Ft', 'HUF', 2, '.', ',', 0),
(73, 'kr', 'ISK', '%i', 'Icelandic króna', 0, '1.00000', '', 0, '0.00', 0, 'kr', 'ISK', 2, '.', ',', 0),
(74, '₨', 'INR', '%i', 'Indian rupee', 0, '1.00000', '', 0, '0.00', 0, '₨', 'INR', 2, '.', ',', 0),
(75, 'Rp', 'IDR', '%i', 'Indonesian rupiah', 0, '1.00000', '', 0, '0.00', 0, 'Rp', 'IDR', 2, '.', ',', 0),
(76, '﷼', 'IRR', '%i', 'Iranian rial', 0, '1.00000', '', 0, '0.00', 0, '﷼', 'IRR', 2, '.', ',', 0),
(77, 'ع.د', 'IQD', '%i', 'Iraqi dinar', 0, '1.00000', '', 0, '0.00', 0, 'ع.د', 'IQD', 2, '.', ',', 0),
(78, '₪', 'ILS', '%n', 'Israeli new sheqel', 0, '1.00000', 'a:13:{s:17:\"mon_decimal_point\";s:1:\",\";s:17:\"mon_thousands_sep\";s:0:\"\";s:12:\"mon_grouping\";s:1:\"3\";s:13:\"positive_sign\";s:0:\"\";s:13:\"negative_sign\";s:1:\"-\";s:15:\"int_frac_digits\";i:0;s:11:\"frac_digits\";i:0;s:13:\"p_cs_precedes\";i:0;s:14:\"p_sep_by_space\";i:1;s:13:\"n_cs_precedes\";i:0;s:14:\"n_sep_by_space\";i:1;s:11:\"p_sign_posn\";i:1;s:11:\"n_sign_posn\";i:1;}', 0, '0.00', 0, '₪', 'ILS', 2, '.', ',', 0),
(79, 'J$', 'JMD', '%i', 'Jamaican dollar', 0, '1.00000', '', 0, '0.00', 0, 'J$', 'JMD', 2, '.', ',', 0),
(80, 'د.ا', 'JOD', '%i', 'Jordanian dinar', 0, '1.00000', '', 0, '0.00', 0, 'د.ا', 'JOD', 2, '.', ',', 0),
(81, 'лв', 'KZT', '%i', 'Kazakhstani tenge', 0, '1.00000', '', 0, '0.00', 0, 'лв', 'KZT', 2, '.', ',', 0),
(82, 'Sh ', 'KES', '%i', 'Kenyan shilling', 0, '1.00000', '', 0, '0.00', 0, 'Sh ', 'KES', 2, '.', ',', 0),
(83, 'د.ك', 'KWD', '%i', 'Kuwaiti dinar', 0, '1.00000', '', 0, '0.00', 0, 'د.ك', 'KWD', 2, '.', ',', 0),
(84, 'лв', 'KGS', '%i', 'Kyrgyzstani som', 0, '1.00000', '', 0, '0.00', 0, 'лв', 'KGS', 2, '.', ',', 0),
(85, '₭', 'LAK', '%i', 'Lao kip', 0, '1.00000', '', 0, '0.00', 0, '₭', 'LAK', 2, '.', ',', 0),
(86, 'Ls', 'LVL', '%i', 'Latvian lats', 0, '1.00000', '', 0, '0.00', 0, 'Ls', 'LVL', 2, '.', ',', 0),
(87, '£', 'LBP', '%i', 'Lebanese pound', 0, '1.00000', '', 0, '0.00', 0, '£', 'LBP', 2, '.', ',', 0),
(88, 'L ', 'LSL', '%i', 'Lesotho loti', 0, '1.00000', '', 0, '0.00', 0, 'L ', 'LSL', 2, '.', ',', 0),
(89, '$', 'LRD', '%i', 'Liberian dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'LRD', 2, '.', ',', 0),
(90, 'ل.د', 'LYD', '%i', 'Libyan dinar', 0, '1.00000', '', 0, '0.00', 0, 'ل.د', 'LYD', 2, '.', ',', 0),
(91, 'Lt', 'LTL', '%i', 'Lithuanian litas', 0, '1.00000', '', 0, '0.00', 0, 'Lt', 'LTL', 2, '.', ',', 0),
(92, 'P ', 'MOP', '%i', 'Macanese pataca', 0, '1.00000', '', 0, '0.00', 0, 'P ', 'MOP', 2, '.', ',', 0),
(93, 'ден', 'MKD', '%i', 'Macedonian denar', 0, '1.00000', '', 0, '0.00', 0, 'ден', 'MKD', 2, '.', ',', 0),
(94, 'MGA', 'MGA', '%i', 'Malagasy ariary', 0, '1.00000', '', 0, '0.00', 0, 'MGA', 'MGA', 2, '.', ',', 0),
(95, 'MK ', 'MWK', '%i', 'Malawian kwacha', 0, '1.00000', '', 0, '0.00', 0, 'MK ', 'MWK', 2, '.', ',', 0),
(96, 'RM', 'MYR', '%i', 'Malaysian ringgit', 0, '1.00000', '', 0, '0.00', 0, 'RM', 'MYR', 2, '.', ',', 0),
(97, 'ރ.', 'MVR', '%i', 'Maldivian rufiyaa', 0, '1.00000', '', 0, '0.00', 0, 'ރ.', 'MVR', 2, '.', ',', 0),
(98, 'UM ', 'MRO', '%i', 'Mauritanian ouguiya', 0, '1.00000', '', 0, '0.00', 0, 'UM ', 'MRO', 2, '.', ',', 0),
(99, '₨', 'MUR', '%i', 'Mauritian rupee', 0, '1.00000', '', 0, '0.00', 0, '₨', 'MUR', 2, '.', ',', 0),
(100, '$', 'MXN', '%i', 'Mexican peso', 0, '1.00000', '', 0, '0.00', 0, '$', 'MXN', 2, '.', ',', 0),
(101, 'MXV', 'MXV', '%i', 'Mexican Unid', 0, '1.00000', '', 0, '0.00', 0, 'MXV', 'MXV', 2, '.', ',', 0),
(102, 'L ', 'MDL', '%i', 'Moldovan leu', 0, '1.00000', '', 0, '0.00', 0, 'L ', 'MDL', 2, '.', ',', 0),
(103, '₮', 'MNT', '%i', 'Mongolian tögrög', 0, '1.00000', '', 0, '0.00', 0, '₮', 'MNT', 2, '.', ',', 0),
(104, 'د.م.', 'MAD', '%i', 'Moroccan dirham', 0, '1.00000', '', 0, '0.00', 0, 'د.م.', 'MAD', 2, '.', ',', 0),
(105, 'MT', 'MZN', '%i', 'Mozambican metical', 0, '1.00000', '', 0, '0.00', 0, 'MT', 'MZN', 2, '.', ',', 0),
(106, 'BOV', 'BOV', '%i', 'Mvdol', 0, '1.00000', '', 0, '0.00', 0, 'BOV', 'BOV', 2, '.', ',', 0),
(107, 'K ', 'MMK', '%i', 'Myanmar kyat', 0, '1.00000', '', 0, '0.00', 0, 'K ', 'MMK', 2, '.', ',', 0),
(108, '$', 'NAD', '%i', 'Namibian dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'NAD', 2, '.', ',', 0),
(109, '₨', 'NPR', '%i', 'Nepalese rupee', 0, '1.00000', '', 0, '0.00', 0, '₨', 'NPR', 2, '.', ',', 0),
(110, 'ƒ', 'ANG', '%i', 'Netherlands Antillean gulden', 0, '1.00000', '', 0, '0.00', 0, 'ƒ', 'ANG', 2, '.', ',', 0),
(111, 'NT$', 'TWD', '%i', 'New Taiwan dollar', 0, '1.00000', '', 0, '0.00', 0, 'NT$', 'TWD', 2, '.', ',', 0),
(112, 'C$', 'NIO', '%i', 'Nicaraguan córdoba', 0, '1.00000', '', 0, '0.00', 0, 'C$', 'NIO', 2, '.', ',', 0),
(113, '₦', 'NGN', '%i', 'Nigerian naira', 0, '1.00000', '', 0, '0.00', 0, '₦', 'NGN', 2, '.', ',', 0),
(114, '₩', 'KPW', '%i', 'North Korean won', 0, '1.00000', '', 0, '0.00', 0, '₩', 'KPW', 2, '.', ',', 0),
(115, 'kr', 'NOK', '%i', 'Norwegian krone', 0, '1.00000', '', 0, '0.00', 0, 'kr', 'NOK', 2, '.', ',', 0),
(116, '﷼', 'OMR', '%i', 'Omani rial', 0, '1.00000', '', 0, '0.00', 0, '﷼', 'OMR', 2, '.', ',', 0),
(117, '₨', 'PKR', '%i', 'Pakistani rupee', 0, '1.00000', '', 0, '0.00', 0, '₨', 'PKR', 2, '.', ',', 0),
(118, 'XPD', 'XPD', '%i', 'Palladium', 0, '1.00000', '', 0, '0.00', 0, 'XPD', 'XPD', 2, '.', ',', 0),
(119, 'B/.', 'PAB', '%i', 'Panamanian balboa', 0, '1.00000', '', 0, '0.00', 0, 'B/.', 'PAB', 2, '.', ',', 0),
(120, 'K ', 'PGK', '%i', 'Papua New Guinean kina', 0, '1.00000', '', 0, '0.00', 0, 'K ', 'PGK', 2, '.', ',', 0),
(121, '₲', 'PYG', '%i', 'Paraguayan guaraní', 0, '1.00000', '', 0, '0.00', 0, '₲', 'PYG', 2, '.', ',', 0),
(122, 'S/.', 'PEN', '%i', 'Peruvian nuevo sol', 0, '1.00000', '', 0, '0.00', 0, 'S/.', 'PEN', 2, '.', ',', 0),
(123, '₱', 'PHP', '%i', 'Philippine peso', 0, '1.00000', '', 0, '0.00', 0, '₱', 'PHP', 2, '.', ',', 0),
(124, 'XPT', 'XPT', '%i', 'Platinum', 0, '1.00000', '', 0, '0.00', 0, 'XPT', 'XPT', 2, '.', ',', 0),
(125, 'zł', 'PLN', '%i', 'Polish Złoty', 0, '1.00000', '', 0, '0.00', 0, 'zł', 'PLN', 2, '.', ',', 0),
(126, '﷼', 'QAR', '%i', 'Qatari riyal', 0, '1.00000', '', 0, '0.00', 0, '﷼', 'QAR', 2, '.', ',', 0),
(127, 'lei', 'RON', '%i', 'Romanian leu', 0, '1.00000', '', 0, '0.00', 0, 'lei', 'RON', 2, '.', ',', 0),
(128, 'руб', 'RUB', '%i', 'Russian ruble', 0, '1.00000', '', 0, '0.00', 0, 'руб', 'RUB', 2, '.', ',', 0),
(129, 'Fr ', 'RWF', '%i', 'Rwandan franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'RWF', 2, '.', ',', 0),
(130, '£', 'SHP', '%i', 'Saint Helenian pound', 0, '1.00000', '', 0, '0.00', 0, '£', 'SHP', 2, '.', ',', 0),
(131, '$', 'SVC', '%i', 'Salvadoran colón', 0, '1.00000', '', 0, '0.00', 0, '$', 'SVC', 2, '.', ',', 0),
(132, 'T ', 'WST', '%i', 'Samoan tala', 0, '1.00000', '', 0, '0.00', 0, 'T ', 'WST', 2, '.', ',', 0),
(133, 'Db ', 'STD', '%i', 'São Tomé and Príncipe dobra', 0, '1.00000', '', 0, '0.00', 0, 'Db ', 'STD', 2, '.', ',', 0),
(134, '﷼', 'SAR', '%i', 'Saudi riyal', 0, '1.00000', '', 0, '0.00', 0, '﷼', 'SAR', 2, '.', ',', 0),
(135, 'XDR', 'XDR', '%i', 'SDR', 0, '1.00000', '', 0, '0.00', 0, 'XDR', 'XDR', 2, '.', ',', 0),
(136, 'Дин.', 'RSD', '%i', 'Serbian dinar', 0, '1.00000', '', 0, '0.00', 0, 'Дин.', 'RSD', 2, '.', ',', 0),
(137, '₨', 'SCR', '%i', 'Seychellois rupee', 0, '1.00000', '', 0, '0.00', 0, '₨', 'SCR', 2, '.', ',', 0),
(138, 'Le ', 'SLL', '%i', 'Sierra Leonean leone', 0, '1.00000', '', 0, '0.00', 0, 'Le ', 'SLL', 2, '.', ',', 0),
(139, 'XAG', 'XAG', '%i', 'Silver', 0, '1.00000', '', 0, '0.00', 0, 'XAG', 'XAG', 2, '.', ',', 0),
(140, '$', 'SGD', '%i', 'Singapore dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'SGD', 2, '.', ',', 0),
(141, 'Sk ', 'SKK', '%i', 'Slovak koruna', 0, '1.00000', '', 0, '0.00', 0, 'Sk ', 'SKK', 2, '.', ',', 0),
(142, '$', 'SBD', '%i', 'Solomon Islands dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'SBD', 2, '.', ',', 0),
(143, 'S', 'SOS', '%i', 'Somali shilling', 0, '1.00000', '', 0, '0.00', 0, 'S', 'SOS', 2, '.', ',', 0),
(144, 'R', 'ZAR', '%i', 'South African rand', 0, '1.00000', '', 0, '0.00', 0, 'R', 'ZAR', 2, '.', ',', 0),
(145, '₩', 'KRW', '%i', 'South Korean won', 0, '1.00000', '', 0, '0.00', 0, '₩', 'KRW', 2, '.', ',', 0),
(146, '₨', 'LKR', '%i', 'Sri Lankan rupee', 0, '1.00000', '', 0, '0.00', 0, '₨', 'LKR', 2, '.', ',', 0),
(147, '£ ', 'SDG', '%i', 'Sudanese pound', 0, '1.00000', '', 0, '0.00', 0, '£ ', 'SDG', 2, '.', ',', 0),
(148, '$', 'SRD', '%i', 'Surinamese dollar', 0, '1.00000', '', 0, '0.00', 0, '$', 'SRD', 2, '.', ',', 0),
(149, 'L ', 'SZL', '%i', 'Swazi lilangeni', 0, '1.00000', '', 0, '0.00', 0, 'L ', 'SZL', 2, '.', ',', 0),
(150, 'kr', 'SEK', '%i', 'Swedish krona', 0, '1.00000', '', 0, '0.00', 0, 'kr', 'SEK', 2, '.', ',', 0),
(151, 'CHF', 'CHF', '%i', 'Swiss franc', 0, '1.00000', '', 0, '0.00', 0, 'CHF', 'CHF', 2, '.', ',', 0),
(152, '£', 'SYP', '%i', 'Syrian pound', 0, '1.00000', '', 0, '0.00', 0, '£', 'SYP', 2, '.', ',', 0),
(153, 'ЅМ', 'TJS', '%i', 'Tajikistani somoni', 0, '1.00000', '', 0, '0.00', 0, 'ЅМ', 'TJS', 2, '.', ',', 0),
(154, 'Sh ', 'TZS', '%i', 'Tanzanian shilling', 0, '1.00000', '', 0, '0.00', 0, 'Sh ', 'TZS', 2, '.', ',', 0),
(155, '฿', 'THB', '%i', 'Thai baht', 0, '1.00000', '', 0, '0.00', 0, '฿', 'THB', 2, '.', ',', 0),
(156, 'XXX', 'XXX', '%i', 'The codes as', 0, '1.00000', '', 0, '0.00', 0, 'XXX', 'XXX', 2, '.', ',', 0),
(157, 'T$ ', 'TOP', '%i', 'Tongan paʻanga', 0, '1.00000', '', 0, '0.00', 0, 'T$ ', 'TOP', 2, '.', ',', 0),
(158, 'TT$', 'TTD', '%i', 'Trinidad and Tobago dollar', 0, '1.00000', '', 0, '0.00', 0, 'TT$', 'TTD', 2, '.', ',', 0),
(159, 'د.ت', 'TND', '%i', 'Tunisian dinar', 0, '1.00000', '', 0, '0.00', 0, 'د.ت', 'TND', 2, '.', ',', 0),
(160, 'YTL', 'TRY', '%i', 'Turkish new lira', 0, '1.00000', '', 0, '0.00', 0, 'YTL', 'TRY', 2, '.', ',', 0),
(161, 'm ', 'TMM', '%i', 'Turkmenistani manat', 0, '1.00000', '', 0, '0.00', 0, 'm ', 'TMM', 2, '.', ',', 0),
(162, 'Sh ', 'UGX', '%i', 'Ugandan shilling', 0, '1.00000', '', 0, '0.00', 0, 'Sh ', 'UGX', 2, '.', ',', 0),
(163, 'XFU', 'XFU', '%i', 'UIC-Franc', 0, '1.00000', '', 0, '0.00', 0, 'XFU', 'XFU', 2, '.', ',', 0),
(164, '₴', 'UAH', '%i', 'Ukrainian hryvnia', 0, '1.00000', '', 0, '0.00', 0, '₴', 'UAH', 2, '.', ',', 0),
(165, 'COU', 'COU', '%i', 'Unidad de Va', 0, '1.00000', '', 0, '0.00', 0, 'COU', 'COU', 2, '.', ',', 0),
(166, 'CLF', 'CLF', '%i', 'Unidades de ', 0, '1.00000', '', 0, '0.00', 0, 'CLF', 'CLF', 2, '.', ',', 0),
(167, 'د.إ', 'AED', '%i', 'United Arab Emirates dirham', 0, '1.00000', '', 0, '0.00', 0, 'د.إ', 'AED', 2, '.', ',', 0),
(168, 'UYI', 'UYI', '%i', 'Uruguay Peso', 0, '1.00000', '', 0, '0.00', 0, 'UYI', 'UYI', 2, '.', ',', 0),
(169, '$', 'UYU', '%i', 'Uruguayan peso', 0, '1.00000', '', 0, '0.00', 0, '$', 'UYU', 2, '.', ',', 0),
(170, '$', 'USN', '%i', 'US Dollar (Next Day)', 0, '1.00000', '', 0, '0.00', 0, '$', 'USN', 2, '.', ',', 0),
(171, '$', 'USS', '%i', 'US Dollar (Second Day)', 0, '1.00000', '', 0, '0.00', 0, '$', 'USS', 2, '.', ',', 0),
(172, 'лв', 'UZS', '%i', 'Uzbekistani som', 0, '1.00000', '', 0, '0.00', 0, 'лв', 'UZS', 2, '.', ',', 0),
(173, 'Vt ', 'VUV', '%i', 'Vanuatu vatu', 0, '1.00000', '', 0, '0.00', 0, 'Vt ', 'VUV', 2, '.', ',', 0),
(174, 'Bs', 'VEF', '%i', 'Venezuelan bolívar', 0, '1.00000', '', 0, '0.00', 0, 'Bs', 'VEF', 2, '.', ',', 0),
(175, '₫', 'VND', '%i', 'Vietnamese Dong', 0, '1.00000', '', 0, '0.00', 0, '₫', 'VND', 2, '.', ',', 0),
(176, 'Fr ', 'XOF', '%i', 'West African CFA franc', 0, '1.00000', '', 0, '0.00', 0, 'Fr ', 'XOF', 2, '.', ',', 0),
(177, '€', 'CHE', '%i', 'WIR Euro', 0, '1.00000', '', 0, '0.00', 0, '€', 'CHE', 2, '.', ',', 0),
(178, 'CHW', 'CHW', '%i', 'WIR Franc', 0, '1.00000', '', 0, '0.00', 0, 'CHW', 'CHW', 2, '.', ',', 0),
(179, '﷼', 'YER', '%i', 'Yemeni rial', 0, '1.00000', '', 0, '0.00', 0, '﷼', 'YER', 2, '.', ',', 0),
(180, 'ZK ', 'ZMK', '%i', 'Zambian kwacha', 0, '1.00000', '', 0, '0.00', 0, 'ZK ', 'ZMK', 2, '.', ',', 0),
(181, 'Z$', 'ZWD', '%i', 'Zimbabwean dollar', 0, '1.00000', '', 0, '0.00', 0, 'Z$', 'ZWD', 2, '.', ',', 0);

UPDATE `#__invoices_templates` SET `content_email` = '<!doctype html>\r\n<html >\r\n  <head>\r\n    <meta name=\"viewport\" content=\"width=device-width\" />\r\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\r\n    <title>[[INVOICE]] {invoice_num}</title>\r\n    <style>\r\n      /* -------------------------------------\r\n          GLOBAL RESETS\r\n      ------------------------------------- */\r\n      img {\r\n        border: none;\r\n        -ms-interpolation-mode: bicubic;\r\n        max-width: 100%; }\r\n\r\n      body {\r\n        background-color: #f6f6f6;\r\n        font-family: sans-serif;\r\n        -webkit-font-smoothing: antialiased;\r\n        font-size: 14px;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        padding: 0;\r\n        -ms-text-size-adjust: 100%;\r\n        -webkit-text-size-adjust: 100%; }\r\n\r\n      table {\r\n        border-collapse: separate;\r\n        mso-table-lspace: 0pt;\r\n        mso-table-rspace: 0pt;\r\n        width: 100%; }\r\n        table td {\r\n          font-family: sans-serif;\r\n          font-size: 14px;\r\n          vertical-align: top; }\r\n\r\n      /* -------------------------------------\r\n          BODY & CONTAINER\r\n      ------------------------------------- */\r\n\r\n      .body {\r\n        background-color: #f6f6f6;\r\n        width: 100%; }\r\n\r\n      /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */\r\n      .container {\r\n        display: block;\r\n        Margin: 0 auto !important;\r\n        /* makes it centered */\r\n        max-width: 580px;\r\n        padding: 10px;\r\n        width: 580px; }\r\n\r\n      /* This should also be a block element, so that it will fill 100% of the .container */\r\n      .content {\r\n        box-sizing: border-box;\r\n        display: block;\r\n        Margin: 0 auto;\r\n        max-width: 580px;\r\n        padding: 10px; }\r\n\r\n      /* -------------------------------------\r\n          HEADER, FOOTER, MAIN\r\n      ------------------------------------- */\r\n      .main {\r\n        background: #fff;\r\n        border-radius: 3px;\r\n        width: 100%; }\r\n\r\n      .wrapper {\r\n        box-sizing: border-box;\r\n        padding: 20px; }\r\n\r\n      .footer {\r\n        clear: both;\r\n        padding-top: 10px;\r\n        text-align: center;\r\n        width: 100%; }\r\n        .footer td,\r\n        .footer p,\r\n        .footer span,\r\n        .footer a {\r\n          color: #999999;\r\n          font-size: 12px;\r\n          text-align: center; }\r\n\r\n      /* -------------------------------------\r\n          TYPOGRAPHY\r\n      ------------------------------------- */\r\n      h1,\r\n      h2,\r\n      h3,\r\n      h4 {\r\n        color: #000000;\r\n        font-family: sans-serif;\r\n        font-weight: 400;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        Margin-bottom: 30px; }\r\n\r\n      h1 {\r\n        font-size: 35px;\r\n        font-weight: 300;\r\n        text-align: center;\r\n        text-transform: capitalize; }\r\n\r\n      p,\r\n      ul,\r\n      ol {\r\n        font-family: sans-serif;\r\n        font-size: 14px;\r\n        font-weight: normal;\r\n        margin: 0;\r\n        Margin-bottom: 15px; }\r\n        p li,\r\n        ul li,\r\n        ol li {\r\n          list-style-position: inside;\r\n          margin-left: 5px; }\r\n\r\n      a {\r\n        color: #3498db;\r\n        text-decoration: underline; }\r\n\r\n      /* -------------------------------------\r\n          BUTTONS\r\n      ------------------------------------- */\r\n      .btn {\r\n        box-sizing: border-box;\r\n        width: 100%; }\r\n        .btn > tbody > tr > td {\r\n          padding-bottom: 15px; }\r\n        .btn table {\r\n          width: auto; }\r\n        .btn table td {\r\n          background-color: #ffffff;\r\n          border-radius: 5px;\r\n          text-align: center; }\r\n        .btn a {\r\n          background-color: #ffffff;\r\n          border: solid 1px #3498db;\r\n          border-radius: 5px;\r\n          box-sizing: border-box;\r\n          color: #3498db;\r\n          cursor: pointer;\r\n          display: inline-block;\r\n          font-size: 14px;\r\n          font-weight: bold;\r\n          margin: 0;\r\n          padding: 12px 25px;\r\n          text-decoration: none;\r\n          text-transform: capitalize; }\r\n\r\n      .btn-primary table td {\r\n        background-color: #3498db; }\r\n\r\n      .btn-primary a {\r\n        background-color: #3498db;\r\n        border-color: #3498db;\r\n        color: #ffffff; }\r\n\r\n      /* -------------------------------------\r\n          OTHER STYLES THAT MIGHT BE USEFUL\r\n      ------------------------------------- */\r\n      .last {\r\n        margin-bottom: 0; }\r\n\r\n      .first {\r\n        margin-top: 0; }\r\n\r\n      .align-center {\r\n        text-align: center; }\r\n\r\n      .align-right {\r\n        text-align: right; }\r\n\r\n      .align-left {\r\n        text-align: left; }\r\n\r\n      .clear {\r\n        clear: both; }\r\n\r\n      .mt0 {\r\n        margin-top: 0; }\r\n\r\n      .mb0 {\r\n        margin-bottom: 0; }\r\n\r\n      .preheader {\r\n        color: transparent;\r\n        display: none;\r\n        height: 0;\r\n        max-height: 0;\r\n        max-width: 0;\r\n        opacity: 0;\r\n        overflow: hidden;\r\n        mso-hide: all;\r\n        visibility: hidden;\r\n        width: 0; }\r\n\r\n      .powered-by a {\r\n        text-decoration: none; }\r\n\r\n      hr {\r\n        border: 0;\r\n        border-bottom: 1px solid #f6f6f6;\r\n        Margin: 20px 0; }\r\n\r\n      /* -------------------------------------\r\n          RESPONSIVE AND MOBILE FRIENDLY STYLES\r\n      ------------------------------------- */\r\n      @media only screen and (max-width: 620px) {\r\n        table[class=body] h1 {\r\n          font-size: 28px !important;\r\n          margin-bottom: 10px !important; }\r\n        table[class=body] p,\r\n        table[class=body] ul,\r\n        table[class=body] ol,\r\n        table[class=body] td,\r\n        table[class=body] span,\r\n        table[class=body] a {\r\n          font-size: 16px !important; }\r\n        table[class=body] .wrapper,\r\n        table[class=body] .article {\r\n          padding: 10px !important; }\r\n        table[class=body] .content {\r\n          padding: 0 !important; }\r\n        table[class=body] .container {\r\n          padding: 0 !important;\r\n          width: 100% !important; }\r\n        table[class=body] .main {\r\n          border-left-width: 0 !important;\r\n          border-radius: 0 !important;\r\n          border-right-width: 0 !important; }\r\n        table[class=body] .btn table {\r\n          width: 100% !important; }\r\n        table[class=body] .btn a {\r\n          width: 100% !important; }\r\n        table[class=body] .img-responsive {\r\n          height: auto !important;\r\n          max-width: 100% !important;\r\n          width: auto !important; }}\r\n\r\n      /* -------------------------------------\r\n          PRESERVE THESE STYLES IN THE HEAD\r\n      ------------------------------------- */\r\n      @media all {\r\n        .ExternalClass {\r\n          width: 100%; }\r\n        .ExternalClass,\r\n        .ExternalClass p,\r\n        .ExternalClass span,\r\n        .ExternalClass font,\r\n        .ExternalClass td,\r\n        .ExternalClass div {\r\n          line-height: 100%; }\r\n        .apple-link a {\r\n          color: inherit !important;\r\n          font-family: inherit !important;\r\n          font-size: inherit !important;\r\n          font-weight: inherit !important;\r\n          line-height: inherit !important;\r\n          text-decoration: none !important; }\r\n        .btn-primary table td:hover {\r\n          background-color: #34495e !important; }\r\n        .btn-primary a:hover {\r\n          background-color: #34495e !important;\r\n          border-color: #34495e !important; } }\r\n\r\n    </style>\r\n  </head>\r\n  <body class=\"\">\r\n    <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"body\">\r\n      <tr>\r\n        <td> </td>\r\n        <td class=\"container\">\r\n          <div class=\"content\">\r\n\r\n            <!-- START CENTERED WHITE CONTAINER -->\r\n            <span class=\"preheader\">[[INVOICE_TOTAL]]: {total}</span>\r\n            <table class=\"main\">\r\n\r\n              <!-- START MAIN CONTENT AREA -->\r\n              <tr>\r\n                <td class=\"wrapper\">\r\n                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                    <tr>\r\n                      <td>\r\n                        <p>[[DEAR]] {to_name},</p>\r\n                        <p>[[FIND_ATTACHED]] <strong>{invoice_num}</strong></p>\r\n                        <p>[[INVOICE_TOTAL]]: <strong>{total}</strong></p>\r\n\r\n                        <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"btn btn-primary\">\r\n                          <tbody>\r\n                            <tr>\r\n                              <td align=\"left\">\r\n                                <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                                  <tbody>\r\n                                    <tr>\r\n                                      <td> {paynow_button} </td>\r\n                                    </tr>\r\n                                  </tbody>\r\n                                </table>\r\n                              </td>\r\n                            </tr>\r\n                          </tbody>\r\n                        </table>\r\n                        <p>[[THANKS]]</p>\r\n                      </td>\r\n                    </tr>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n\r\n              <!-- END MAIN CONTENT AREA -->\r\n              </table>\r\n\r\n            <!-- START FOOTER -->\r\n            <div class=\"footer\">\r\n              <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                <tr>\r\n                  <td class=\"content-block\">\r\n                    <span class=\"apple-link\">JoomlaThat.com</span>\r\n                  </td>\r\n                </tr>\r\n\r\n              </table>\r\n            </div>\r\n\r\n            <!-- END FOOTER -->\r\n\r\n<!-- END CENTERED WHITE CONTAINER --></div>\r\n        </td>\r\n        <td> </td>\r\n      </tr>\r\n    </table>\r\n  </body>\r\n</html>' WHERE `content_email` = '';
