ALTER TABLE `#__invoices_invoices` ADD  `language` VARCHAR(255) NOT NULL;
ALTER TABLE `#__invoices_invoices` ADD  `last_sent` DATETIME NOT NULL;
ALTER TABLE `#__invoices_invoices` MODIFY `computed_total` DECIMAL(12,4) NOT NULL;
ALTER TABLE `#__invoices_invoices` MODIFY `discount` DECIMAL(12,4) NOT NULL;

ALTER TABLE `#__invoices_items` MODIFY `value` DECIMAL(12,4) NOT NULL;
ALTER TABLE `#__invoices_items` MODIFY `discount` DECIMAL(12,4) NOT NULL;
ALTER TABLE `#__invoices_items` MODIFY `tax` DECIMAL(12,4) NOT NULL;

ALTER TABLE `#__invoices_taxes` ADD  `checked` TINYINT(1) NOT NULL;
ALTER TABLE `#__invoices_taxes` MODIFY  `value` DECIMAL(12,4) NOT NULL;

ALTER TABLE `#__invoices_templateitems` MODIFY `value` DECIMAL(12,4) NOT NULL;
ALTER TABLE `#__invoices_templateitems` MODIFY `tax` DECIMAL(12,4) NOT NULL;


INSERT INTO `#__invoices_templates` (`id`, `name`, `content`, `items`, `taxes`, `payments`, `payments2`, `styles`, `content_pdf`) VALUES
(NULL, 'Invoice (Bootstrap)', '<div style="font-family: Helvetica;">\r\n  <div class="row-fluid">\r\n    <div class="span6"><img src="http://www.joomlathat.com/images/joomlathat3.png" alt="" /><br />\r\n      <br />\r\n      <dl class="dl-horizontal">\r\n        <dt>[[FROM]]</dt>\r\n        <dd><strong>{from_name}</strong></dd>\r\n        <dt>[[ADDRESS]]</dt>\r\n        <dd>\r\n          <address>\r\n          {from_address}\r\n          </address>\r\n        </dd>\r\n        <dt>[[EMAIL]]</dt>\r\n        <dd>{from_email}</dd>\r\n        <dt>[[FISCAL_NUMBER]]</dt>\r\n        <dd>{from_num}</dd>\r\n      </dl>\r\n    </div>\r\n    <div class="span6">\r\n      <div class="well well-small">\r\n        <dl class="dl-horizontal">\r\n          <dt>[[INVOICE_NUM]]</dt>\r\n          <dd>{invoice_num}</dd>\r\n          <dt>[[INVOICE_DATE]]</dt>\r\n          <dd>{invoice_date}</dd>\r\n          <dt>[[DUE_DATE]]</dt>\r\n          <dd>{invoice_duedate}</dd>\r\n          <dt>[[INVOICE_TOTAL]]</dt>\r\n          <dd>{total}</dd>\r\n          <dt>[[STATUS]]</dt>\r\n          <dd>{status}</dd>\r\n        </dl>\r\n      </div>\r\n      <div class="well well-small">\r\n        <dl class="dl-horizontal">\r\n          <dt>[[BILL_TO]]</dt>\r\n          <dd><strong>{to_name}</strong></dd>\r\n          <dt>[[ADDRESS]]</dt>\r\n          <dd>\r\n            <address>\r\n            {to_company} <br />\r\n            {to_address} <br />\r\n            {to_zipcode} {to_city} <br />\r\n            {to_state} {to_country}\r\n            </address>\r\n          </dd>\r\n          <dt>[[EMAIL]]</dt>\r\n          <dd>{to_email}</dd>\r\n          <dt>[[VATID]]</dt>\r\n          <dd>{to_vatid}</dd>\r\n          <dt>[[PHONE]]</dt>\r\n          <dd>{to_phone}</dd>\r\n        </dl>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <h2 class="invoice_header">[[ITEMS]]</h2>\r\n  <table class="table table-striped" width="100%">\r\n    <thead>\r\n      <tr>\r\n        <th align="left">[[SKU]]</th>\r\n        <th align="left">[[DESCRIPTION]]</th>\r\n        <th style="text-align: right;" align="right">[[UNIT_COST]]</th>\r\n        <th style="text-align: right;" align="right">[[QUANTITY]]</th>\r\n        <th style="text-align: right;" align="right">[[DISCOUNT]]</th>\r\n        <th style="text-align: right;" align="right">[[TAX]]</th>\r\n        <th style="text-align: right;" align="right">[[PRICE]]</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <!--ITEMS-->\r\n      <tr>\r\n        <td>{sku}</td>\r\n        <td><strong>{name}</strong><br />\r\n          {desc}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n        <td style="text-align: right;" align="right">{amount}</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n        <td style="text-align: right;" align="right">{tax}</td>\r\n        <td style="text-align: right;" align="right">{item_total}</td>\r\n      </tr>\r\n      <!--/ITEMS-->\r\n    </tbody>\r\n    <tfoot>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[DISCOUNT]]</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n      </tr>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[SUBTOTAL]]</td>\r\n        <td style="text-align: right;" align="right">{subtotal}</td>\r\n      </tr>\r\n      <!--TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">{name}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n      </tr>\r\n      <!--/TAXES-->\r\n      <!--GROUPED_TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">{name}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n      </tr>\r\n      <!--/GROUPED_TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right"><strong>[[TOTAL]]</strong></td>\r\n        <td style="text-align: right;" align="right"><strong>{total}</strong></td>\r\n      </tr>\r\n    </tfoot>\r\n  </table>\r\n  <ul class="nav nav-tabs">\r\n    <li><a href="#payments_received" data-toggle="tab">[[PAYMENTS_RECEIVED]] {num_payments_received}</a></li>\r\n    <li class="active"><a href="#pending_payments" data-toggle="tab">[[PENDING_PAYMENTS]] {num_pending_payments}</a></li>\r\n  </ul>\r\n  <div class="tab-content">\r\n    <div id="payments_received" class="tab-pane ">\r\n      <table class="table table-striped " style="table-layout: fixed;" width="100%">\r\n        <thead>\r\n          <tr>\r\n            <th align="left">[[PAYMENT_DATE]]</th>\r\n            <th align="left">[[DESCRIPTION]]</th>\r\n            <th align="left">[[STATUS]]</th>\r\n            <th align="left"> </th>\r\n            <th style="text-align: right;" align="right">[[AMOUNT]]</th>\r\n          </tr>\r\n        </thead>\r\n        <tbody>\r\n          <!--PAYMENTS-->\r\n          <tr>\r\n            <td>{payment_datetime}</td>\r\n            <td>{description}</td>\r\n            <td>{payment_status}</td>\r\n            <td style="text-align: right;" align="right"><a class="btn btn-mini" href="{payment_link}"> [[VIEW_DETAILS]]</a></td>\r\n            <td style="text-align: right;" align="right">{amount}</td>\r\n          </tr>\r\n          <!--/PAYMENTS-->\r\n        </tbody>\r\n        <tfoot>\r\n          <tr>\r\n            <td> </td>\r\n            <td> </td>\r\n            <td> </td>\r\n            <td style="text-align: right;" align="right"><strong>[[TOTAL_AMOUNT_PAID]]</strong></td>\r\n            <td style="text-align: right;" align="right"><strong>{total_payments}</strong></td>\r\n          </tr>\r\n        </tfoot>\r\n      </table>\r\n    </div>\r\n    <div id="pending_payments" class="tab-pane active">\r\n      <table class="table table-striped table-hover" style="table-layout: fixed;" width="100%">\r\n        <thead>\r\n          <tr>\r\n            <th align="left">[[DUE_DATE]]</th>\r\n            <th align="left">[[DESCRIPTION]]</th>\r\n            <th align="left">[[STATUS]]</th>\r\n            <th align="left"> </th>\r\n            <th style="text-align: right;" align="right">[[AMOUNT]]</th>\r\n          </tr>\r\n        </thead>\r\n        <tbody>\r\n          <!--PAYMENTS2-->\r\n          <tr>\r\n            <td>{duedate}</td>\r\n            <td>{description}</td>\r\n            <td>{payment_status}</td>\r\n            <td style="text-align: right;" align="right"><a class="btn btn-info btn-mini" href="{payment_link}" target="_parent"> [[PAY_NOW]]</a></td>\r\n            <td style="text-align: right;" align="right">{amount}</td>\r\n          </tr>\r\n          <!--/PAYMENTS2-->\r\n        </tbody>\r\n        <tfoot>\r\n          <tr>\r\n            <td> </td>\r\n            <td> </td>\r\n            <td> </td>\r\n            <td style="text-align: right;" align="right"><strong>[[AMOUNT_OUTSTANDING]]</strong></td>\r\n            <td style="text-align: right;" align="right"><strong>{amount_outstanding}</strong></td>\r\n          </tr>\r\n        </tfoot>\r\n      </table>\r\n    </div>\r\n  </div>\r\n  <div style="padding: 2px;">[[NOTES]]</div>\r\n  <div class="muted" style="border-top: 1px solid #000; padding: 2px;"><small>{notes}</small></div>\r\n</div>', '', '', '', '', '.clearfix{*zoom:1;}.clearfix:before,.clearfix:after{display:table;content:"";line-height:0;}\r\n.clearfix:after{clear:both;}\r\n.hide-text{font:0/0 a;color:transparent;text-shadow:none;background-color:transparent;border:0;}\r\n\r\ndl{margin-bottom:20px;}\r\ndt,dd{line-height:20px;}\r\ndt{font-weight:bold;}\r\ndd{margin-left:10px;}\r\n.dl-horizontal{*zoom:1;}.dl-horizontal:before,.dl-horizontal:after{display:table;content:"";line-height:0;}\r\n.dl-horizontal:after{clear:both;}\r\n.dl-horizontal dt{float:left;width:120px;clear:left;text-align:right;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;}\r\n.dl-horizontal dd{margin-left:140px;}\r\nhr{margin:20px 0;border:0;border-top:1px solid #eeeeee;border-bottom:1px solid #ffffff;}\r\nabbr[title],abbr[data-original-title]{cursor:help;border-bottom:1px dotted #999999;}\r\nabbr.initialism{font-size:90%;text-transform:uppercase;}\r\n\r\nq:before,q:after,blockquote:before,blockquote:after{content:"";}\r\naddress{display:block;margin-bottom:20px;font-style:normal;line-height:20px;}\r\n\r\ntable{max-width:100%;background-color:transparent;border-collapse:collapse;border-spacing:0;}\r\n.table{width:100%;margin-bottom:20px;}.table th,.table td{padding:8px;line-height:20px;text-align:left;vertical-align:top;border-top:1px solid #dddddd;}\r\n.table th{font-weight:bold;}\r\n.table thead th{vertical-align:bottom;}\r\n.table caption+thead tr:first-child th,.table caption+thead tr:first-child td,.table colgroup+thead tr:first-child th,.table colgroup+thead tr:first-child td,.table thead:first-child tr:first-child th,.table thead:first-child tr:first-child td{border-top:0;}\r\n.table tbody+tbody{border-top:2px solid #dddddd;}\r\n.table .table{background-color:#ffffff;}\r\n.table-condensed th,.table-condensed td{padding:4px 5px;}\r\n.table-bordered{border:1px solid #dddddd;border-collapse:separate;*border-collapse:collapse;border-left:0;-webkit-border-radius:4px;-moz-border-radius:4px;border-radius:4px;}.table-bordered th,.table-bordered td{border-left:1px solid #dddddd;}\r\n.table-bordered caption+thead tr:first-child th,.table-bordered caption+tbody tr:first-child th,.table-bordered caption+tbody tr:first-child td,.table-bordered colgroup+thead tr:first-child th,.table-bordered colgroup+tbody tr:first-child th,.table-bordered colgroup+tbody tr:first-child td,.table-bordered thead:first-child tr:first-child th,.table-bordered tbody:first-child tr:first-child th,.table-bordered tbody:first-child tr:first-child td{border-top:0;}\r\n.table-bordered thead:first-child tr:first-child>th:first-child,.table-bordered tbody:first-child tr:first-child>td:first-child,.table-bordered tbody:first-child tr:first-child>th:first-child{-webkit-border-top-left-radius:4px;-moz-border-radius-topleft:4px;border-top-left-radius:4px;}\r\n.table-bordered thead:first-child tr:first-child>th:last-child,.table-bordered tbody:first-child tr:first-child>td:last-child,.table-bordered tbody:first-child tr:first-child>th:last-child{-webkit-border-top-right-radius:4px;-moz-border-radius-topright:4px;border-top-right-radius:4px;}\r\n.table-bordered thead:last-child tr:last-child>th:first-child,.table-bordered tbody:last-child tr:last-child>td:first-child,.table-bordered tbody:last-child tr:last-child>th:first-child,.table-bordered tfoot:last-child tr:last-child>td:first-child,.table-bordered tfoot:last-child tr:last-child>th:first-child{-webkit-border-bottom-left-radius:4px;-moz-border-radius-bottomleft:4px;border-bottom-left-radius:4px;}\r\n.table-bordered thead:last-child tr:last-child>th:last-child,.table-bordered tbody:last-child tr:last-child>td:last-child,.table-bordered tbody:last-child tr:last-child>th:last-child,.table-bordered tfoot:last-child tr:last-child>td:last-child,.table-bordered tfoot:last-child tr:last-child>th:last-child{-webkit-border-bottom-right-radius:4px;-moz-border-radius-bottomright:4px;border-bottom-right-radius:4px;}\r\n.table-bordered tfoot+tbody:last-child tr:last-child td:first-child{-webkit-border-bottom-left-radius:0;-moz-border-radius-bottomleft:0;border-bottom-left-radius:0;}\r\n.table-bordered tfoot+tbody:last-child tr:last-child td:last-child{-webkit-border-bottom-right-radius:0;-moz-border-radius-bottomright:0;border-bottom-right-radius:0;}\r\n.table-bordered caption+thead tr:first-child th:first-child,.table-bordered caption+tbody tr:first-child td:first-child,.table-bordered colgroup+thead tr:first-child th:first-child,.table-bordered colgroup+tbody tr:first-child td:first-child{-webkit-border-top-left-radius:4px;-moz-border-radius-topleft:4px;border-top-left-radius:4px;}\r\n.table-bordered caption+thead tr:first-child th:last-child,.table-bordered caption+tbody tr:first-child td:last-child,.table-bordered colgroup+thead tr:first-child th:last-child,.table-bordered colgroup+tbody tr:first-child td:last-child{-webkit-border-top-right-radius:4px;-moz-border-radius-topright:4px;border-top-right-radius:4px;}\r\n.table-striped tbody>tr:nth-child(odd)>td,.table-striped tbody>tr:nth-child(odd)>th{background-color:#f9f9f9;}\r\n.table-hover tbody tr:hover>td,.table-hover tbody tr:hover>th{background-color:#f5f5f5;}\r\ntable td[class*="span"],table th[class*="span"],.row-fluid table td[class*="span"],.row-fluid table th[class*="span"]{display:table-cell;float:none;margin-left:0;}\r\n.table td.span1,.table th.span1{float:none;width:44px;margin-left:0;}\r\n.table td.span2,.table th.span2{float:none;width:124px;margin-left:0;}\r\n.table td.span3,.table th.span3{float:none;width:204px;margin-left:0;}\r\n.table td.span4,.table th.span4{float:none;width:284px;margin-left:0;}\r\n.table td.span5,.table th.span5{float:none;width:364px;margin-left:0;}\r\n.table td.span6,.table th.span6{float:none;width:444px;margin-left:0;}\r\n.table td.span7,.table th.span7{float:none;width:524px;margin-left:0;}\r\n.table td.span8,.table th.span8{float:none;width:604px;margin-left:0;}\r\n.table td.span9,.table th.span9{float:none;width:684px;margin-left:0;}\r\n.table td.span10,.table th.span10{float:none;width:764px;margin-left:0;}\r\n.table td.span11,.table th.span11{float:none;width:844px;margin-left:0;}\r\n.table td.span12,.table th.span12{float:none;width:924px;margin-left:0;}\r\n.table tbody tr.success>td{background-color:#dff0d8;}\r\n.table tbody tr.error>td{background-color:#f2dede;}\r\n.table tbody tr.warning>td{background-color:#fcf8e3;}\r\n.table tbody tr.info>td{background-color:#d9edf7;}\r\n.table-hover tbody tr.success:hover>td{background-color:#d0e9c6;}\r\n.table-hover tbody tr.error:hover>td{background-color:#ebcccc;}\r\n.table-hover tbody tr.warning:hover>td{background-color:#faf2cc;}\r\n.table-hover tbody tr.info:hover>td{background-color:#c4e3f3;}\r\n\r\n.well{min-height:20px;padding:19px;margin-bottom:20px;background-color:#f5f5f5;border:1px solid #e3e3e3;-webkit-border-radius:4px;-moz-border-radius:4px;border-radius:4px;-webkit-box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);-moz-box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);}.well blockquote{border-color:#ddd;border-color:rgba(0, 0, 0, 0.15);}\r\n.well-large{padding:24px;-webkit-border-radius:6px;-moz-border-radius:6px;border-radius:6px;}\r\n.well-small{padding:9px;-webkit-border-radius:3px;-moz-border-radius:3px;border-radius:3px;}\r\n\r\ntable.dl-table td{line-height:20px;}\r\ntd.invoice_label{text-align:right;font-weight:bold;\r\nwidth:120px; padding-right:20px;line-height:20px;}', '<div style="font-family: Helvetica; font-size: 12px;">\r\n  <table width="100%">\r\n    <tbody>\r\n      <tr>\r\n        <td valign="top" width="50%"><img src="http://www.joomlathat.com/images/joomlathat3.png" alt="" /><br />\r\n          <br />\r\n          <table class="dl-table">\r\n            <tbody>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[FROM]]</td>\r\n                <td valign="top"><strong>{from_name}</strong></td>\r\n              </tr>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[ADDRESS]]</td>\r\n                <td valign="top"><address>\r\n                  {from_address}\r\n                  </address></td>\r\n              </tr>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[EMAIL]]</td>\r\n                <td valign="top">{from_email}</td>\r\n              </tr>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[FISCAL_NUMBER]]</td>\r\n                <td valign="top">{from_num}</td>\r\n              </tr>\r\n            </tbody>\r\n          </table></td>\r\n        <td valign="top" width="50%"><div class="well well-small">\r\n            <table class="dl-table">\r\n              <tbody>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[INVOICE_NUM]]</td>\r\n                  <td valign="top">{invoice_num}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[INVOICE_DATE]]</td>\r\n                  <td valign="top">{invoice_date}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[DUE_DATE]]</td>\r\n                  <td valign="top">{invoice_duedate}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[INVOICE_TOTAL]]</td>\r\n                  <td valign="top">{total}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[STATUS]]</td>\r\n                  <td valign="top">{status}</td>\r\n                </tr>\r\n              </tbody>\r\n            </table>\r\n          </div>\r\n          <div class="well well-small">\r\n            <table class="dl-table">\r\n              <tbody>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[BILL_TO]]</td>\r\n                  <td valign="top"><strong>{to_name}</strong></td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[ADDRESS]]</td>\r\n                  <td valign="top"><address>\r\n                    {to_company} <br />\r\n                    {to_address} <br />\r\n                    {to_zipcode} {to_city} <br />\r\n                    {to_state} {to_country}\r\n                    </address></td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[EMAIL]]</td>\r\n                  <td valign="top">{to_email}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[VATID]]</td>\r\n                  <td valign="top">{to_vatid}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[PHONE]]</td>\r\n                  <td valign="top">{to_phone}</td>\r\n                </tr>\r\n              </tbody>\r\n            </table>\r\n          </div></td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <h2 class="invoice_header">[[ITEMS]]</h2>\r\n  <table class="table table-striped" width="100%">\r\n    <thead>\r\n      <tr>\r\n        <th align="left">[[SKU]]</th>\r\n        <th align="left">[[DESCRIPTION]]</th>\r\n        <th style="text-align: right;" align="right">[[UNIT_COST]]</th>\r\n        <th style="text-align: right;" align="right">[[QUANTITY]]</th>\r\n        <th style="text-align: right;" align="right">[[DISCOUNT]]</th>\r\n        <th style="text-align: right;" align="right">[[TAX]]</th>\r\n        <th style="text-align: right;" align="right">[[PRICE]]</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <!--ITEMS-->\r\n      <tr>\r\n        <td>{sku}</td>\r\n        <td><strong>{name}</strong><br />\r\n          {desc}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n        <td style="text-align: right;" align="right">{amount}</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n        <td style="text-align: right;" align="right">{tax}</td>\r\n        <td style="text-align: right;" align="right">{item_total}</td>\r\n      </tr>\r\n      <!--/ITEMS-->\r\n    </tbody>\r\n    <tfoot>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[DISCOUNT]]</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n      </tr>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[SUBTOTAL]]</td>\r\n        <td style="text-align: right;" align="right">{subtotal}</td>\r\n      </tr>\r\n      <!--TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">{name}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n      </tr>\r\n      <!--/TAXES-->\r\n      <!--GROUPED_TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">{name}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n      </tr>\r\n      <!--/GROUPED_TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right"><strong>[[TOTAL]]</strong></td>\r\n        <td style="text-align: right;" align="right"><strong>{total}</strong></td>\r\n      </tr>\r\n    </tfoot>\r\n  </table>\r\n  <h2 class="invoice_header">[[PAYMENTS_RECEIVED]]</h2>\r\n  <table class="table table-striped " style="table-layout: fixed;" width="100%">\r\n    <thead>\r\n      <tr>\r\n        <th align="left">[[PAYMENT_DATE]]</th>\r\n        <th align="left">[[DESCRIPTION]]</th>\r\n        <th align="left">[[STATUS]]</th>\r\n        <th align="left"> </th>\r\n        <th style="text-align: right;" align="right">[[AMOUNT]]</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <!--PAYMENTS-->\r\n      <tr>\r\n        <td>{payment_datetime}</td>\r\n        <td>{description}</td>\r\n        <td>{payment_status}</td>\r\n        <td style="text-align: right;" align="right"><a class="btn btn-mini" href="{payment_link}"> [[VIEW_DETAILS]]</a></td>\r\n        <td style="text-align: right;" align="right">{amount}</td>\r\n      </tr>\r\n      <!--/PAYMENTS-->\r\n    </tbody>\r\n    <tfoot>\r\n      <tr>\r\n        <td> </td>\r\n        <td> </td>\r\n        <td> </td>\r\n        <td style="text-align: right;" align="right"><strong>[[TOTAL_AMOUNT_PAID]]</strong></td>\r\n        <td style="text-align: right;" align="right"><strong>{total_payments}</strong></td>\r\n      </tr>\r\n    </tfoot>\r\n  </table>\r\n  <h2 class="invoice_header">[[PENDING_PAYMENTS]]</h2>\r\n  <table class="table table-striped table-hover" style="table-layout: fixed;" width="100%">\r\n    <thead>\r\n      <tr>\r\n        <th align="left">[[DUE_DATE]]</th>\r\n        <th align="left">[[DESCRIPTION]]</th>\r\n        <th align="left">[[STATUS]]</th>\r\n        <th align="left"> </th>\r\n        <th style="text-align: right;" align="right">[[AMOUNT]]</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <!--PAYMENTS2-->\r\n      <tr>\r\n        <td>{duedate}</td>\r\n        <td>{description}</td>\r\n        <td>{payment_status}</td>\r\n        <td style="text-align: right;" align="right"><a class="btn btn-info btn-mini" href="{payment_link}" target="_parent"> [[PAY_NOW]]</a></td>\r\n        <td style="text-align: right;" align="right">{amount}</td>\r\n      </tr>\r\n      <!--/PAYMENTS2-->\r\n    </tbody>\r\n    <tfoot>\r\n      <tr>\r\n        <td> </td>\r\n        <td> </td>\r\n        <td> </td>\r\n        <td style="text-align: right;" align="right"><strong>[[AMOUNT_OUTSTANDING]]</strong></td>\r\n        <td style="text-align: right;" align="right"><strong>{amount_outstanding}</strong></td>\r\n      </tr>\r\n    </tfoot>\r\n  </table>\r\n  <div style="padding: 2px;">[[NOTES]]</div>\r\n  <div class="muted" style="border-top: 1px solid #000; padding: 2px;"><small>{notes}</small></div>\r\n</div>'),
(NULL, 'Quote (Bootstrap)', '<div style="font-family:Helvetica;"  >\r\n  <div class="row-fluid">\r\n    <div class="span6"> <img src="http://www.joomlathat.com/images/joomlathat3.png" /><br />\r\n      <br />\r\n      <dl class="dl-horizontal">\r\n        <dt>[[FROM]]</dt>\r\n        <dd><strong>{from_name}</strong></dd>\r\n        <dt>[[ADDRESS]]</dt>\r\n        <dd>\r\n          <address>\r\n          {from_address}\r\n          </address>\r\n        </dd>\r\n        <dt>[[EMAIL]]</dt>\r\n        <dd>{from_email}</dd>\r\n        <dt>[[FISCAL_NUMBER]]</dt>\r\n        <dd>{from_num}</dd>\r\n      </dl>\r\n    </div>\r\n    <div class="span6">\r\n      <div class="well well-small">\r\n        <dl class="dl-horizontal">\r\n          <dt>[[QUOTE_NUM]]</dt>\r\n          <dd>{invoice_num}</dd>\r\n          <dt>[[QUOTE_DATE]]</dt>\r\n          <dd>{invoice_date}</dd>\r\n          <dt>[[DUE_DATE]]</dt>\r\n          <dd>{invoice_duedate}</dd>\r\n          <dt>[[QUOTE_TOTAL]]</dt>\r\n          <dd>{total}</dd>\r\n          <dt>[[STATUS]]</dt>\r\n          <dd>{status}</dd>\r\n        </dl>\r\n      </div>\r\n      <div class="well well-small">\r\n        <dl class="dl-horizontal">\r\n          <dt>[[BILL_TO]]</dt>\r\n          <dd><strong>{to_name}</strong></dd>\r\n          <dt>[[ADDRESS]]</dt>\r\n          <dd>\r\n            <address>\r\n            {to_company} <br />\r\n            {to_address} <br />\r\n            {to_zipcode} {to_city} <br />\r\n            {to_state} {to_country}\r\n            </address>\r\n          </dd>\r\n          <dt>[[EMAIL]]</dt>\r\n          <dd>{to_email}</dd>\r\n          <dt>[[VATID]]</dt>\r\n          <dd>{to_vatid}</dd>\r\n          <dt>[[PHONE]]</dt>\r\n          <dd>{to_phone}</dd>\r\n        </dl>\r\n      </div>\r\n\r\n {accept_button}  {reject_button}\r\n\r\n    </div>\r\n  </div>\r\n  <h2 class="invoice_header">[[ITEMS]]</h2>\r\n  <table width="100%" class="table table-striped"   >\r\n    <thead>\r\n      <tr>\r\n        <th align="left">[[SKU]]</th>\r\n        <th align="left">[[DESCRIPTION]]</th>\r\n        <th style="text-align: right;" align="right">[[UNIT_COST]]</th>\r\n        <th style="text-align: right;" align="right">[[QUANTITY]]</th>\r\n        <th style="text-align: right;" align="right">[[DISCOUNT]]</th>\r\n        <th style="text-align: right;" align="right">[[TAX]]</th>\r\n        <th style="text-align: right;" align="right">[[PRICE]]</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <!--ITEMS-->\r\n      <tr>\r\n        <td>{sku}</td>\r\n        <td><strong>{name}</strong><br />\r\n          {desc}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n        <td style="text-align: right;" align="right">{amount}</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n        <td style="text-align: right;" align="right">{tax}</td>\r\n        <td style="text-align: right;" align="right">{item_total}</td>\r\n      </tr>\r\n      <!--/ITEMS-->\r\n    </tbody>\r\n    <tfoot>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[DISCOUNT]]</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n      </tr>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[SUBTOTAL]]</td>\r\n        <td style="text-align: right;" align="right">{subtotal}</td>\r\n      </tr>\r\n      <!--TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">{name}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n      </tr>\r\n      <!--/TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right"><strong>[[TOTAL]]</strong></td>\r\n        <td style="text-align: right;" align="right"><strong>{total}</strong></td>\r\n      </tr>\r\n    </tfoot>\r\n  </table>\r\n  <div style="padding: 2px;">[[NOTES]]</div>\r\n  <div style="border-top:1px solid #000; padding:2px; " class="muted"><small>{notes}</small></div>\r\n</div>', '', '', '', '', '.clearfix{*zoom:1;}.clearfix:before,.clearfix:after{display:table;content:"";line-height:0;}\r\n.clearfix:after{clear:both;}\r\n.hide-text{font:0/0 a;color:transparent;text-shadow:none;background-color:transparent;border:0;}\r\n\r\ndl{margin-bottom:20px;}\r\ndt,dd{line-height:20px;}\r\ndt{font-weight:bold;}\r\ndd{margin-left:10px;}\r\n.dl-horizontal{*zoom:1;}.dl-horizontal:before,.dl-horizontal:after{display:table;content:"";line-height:0;}\r\n.dl-horizontal:after{clear:both;}\r\n.dl-horizontal dt{float:left;width:120px;clear:left;text-align:right;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;}\r\n.dl-horizontal dd{margin-left:140px;}\r\nhr{margin:20px 0;border:0;border-top:1px solid #eeeeee;border-bottom:1px solid #ffffff;}\r\nabbr[title],abbr[data-original-title]{cursor:help;border-bottom:1px dotted #999999;}\r\nabbr.initialism{font-size:90%;text-transform:uppercase;}\r\n\r\nq:before,q:after,blockquote:before,blockquote:after{content:"";}\r\naddress{display:block;margin-bottom:20px;font-style:normal;line-height:20px;}\r\n\r\ntable{max-width:100%;background-color:transparent;border-collapse:collapse;border-spacing:0;}\r\n.table{width:100%;margin-bottom:20px;}.table th,.table td{padding:8px;line-height:20px;text-align:left;vertical-align:top;border-top:1px solid #dddddd;}\r\n.table th{font-weight:bold;}\r\n.table thead th{vertical-align:bottom;}\r\n.table caption+thead tr:first-child th,.table caption+thead tr:first-child td,.table colgroup+thead tr:first-child th,.table colgroup+thead tr:first-child td,.table thead:first-child tr:first-child th,.table thead:first-child tr:first-child td{border-top:0;}\r\n.table tbody+tbody{border-top:2px solid #dddddd;}\r\n.table .table{background-color:#ffffff;}\r\n.table-condensed th,.table-condensed td{padding:4px 5px;}\r\n.table-bordered{border:1px solid #dddddd;border-collapse:separate;*border-collapse:collapse;border-left:0;-webkit-border-radius:4px;-moz-border-radius:4px;border-radius:4px;}.table-bordered th,.table-bordered td{border-left:1px solid #dddddd;}\r\n.table-bordered caption+thead tr:first-child th,.table-bordered caption+tbody tr:first-child th,.table-bordered caption+tbody tr:first-child td,.table-bordered colgroup+thead tr:first-child th,.table-bordered colgroup+tbody tr:first-child th,.table-bordered colgroup+tbody tr:first-child td,.table-bordered thead:first-child tr:first-child th,.table-bordered tbody:first-child tr:first-child th,.table-bordered tbody:first-child tr:first-child td{border-top:0;}\r\n.table-bordered thead:first-child tr:first-child>th:first-child,.table-bordered tbody:first-child tr:first-child>td:first-child,.table-bordered tbody:first-child tr:first-child>th:first-child{-webkit-border-top-left-radius:4px;-moz-border-radius-topleft:4px;border-top-left-radius:4px;}\r\n.table-bordered thead:first-child tr:first-child>th:last-child,.table-bordered tbody:first-child tr:first-child>td:last-child,.table-bordered tbody:first-child tr:first-child>th:last-child{-webkit-border-top-right-radius:4px;-moz-border-radius-topright:4px;border-top-right-radius:4px;}\r\n.table-bordered thead:last-child tr:last-child>th:first-child,.table-bordered tbody:last-child tr:last-child>td:first-child,.table-bordered tbody:last-child tr:last-child>th:first-child,.table-bordered tfoot:last-child tr:last-child>td:first-child,.table-bordered tfoot:last-child tr:last-child>th:first-child{-webkit-border-bottom-left-radius:4px;-moz-border-radius-bottomleft:4px;border-bottom-left-radius:4px;}\r\n.table-bordered thead:last-child tr:last-child>th:last-child,.table-bordered tbody:last-child tr:last-child>td:last-child,.table-bordered tbody:last-child tr:last-child>th:last-child,.table-bordered tfoot:last-child tr:last-child>td:last-child,.table-bordered tfoot:last-child tr:last-child>th:last-child{-webkit-border-bottom-right-radius:4px;-moz-border-radius-bottomright:4px;border-bottom-right-radius:4px;}\r\n.table-bordered tfoot+tbody:last-child tr:last-child td:first-child{-webkit-border-bottom-left-radius:0;-moz-border-radius-bottomleft:0;border-bottom-left-radius:0;}\r\n.table-bordered tfoot+tbody:last-child tr:last-child td:last-child{-webkit-border-bottom-right-radius:0;-moz-border-radius-bottomright:0;border-bottom-right-radius:0;}\r\n.table-bordered caption+thead tr:first-child th:first-child,.table-bordered caption+tbody tr:first-child td:first-child,.table-bordered colgroup+thead tr:first-child th:first-child,.table-bordered colgroup+tbody tr:first-child td:first-child{-webkit-border-top-left-radius:4px;-moz-border-radius-topleft:4px;border-top-left-radius:4px;}\r\n.table-bordered caption+thead tr:first-child th:last-child,.table-bordered caption+tbody tr:first-child td:last-child,.table-bordered colgroup+thead tr:first-child th:last-child,.table-bordered colgroup+tbody tr:first-child td:last-child{-webkit-border-top-right-radius:4px;-moz-border-radius-topright:4px;border-top-right-radius:4px;}\r\n.table-striped tbody>tr:nth-child(odd)>td,.table-striped tbody>tr:nth-child(odd)>th{background-color:#f9f9f9;}\r\n.table-hover tbody tr:hover>td,.table-hover tbody tr:hover>th{background-color:#f5f5f5;}\r\ntable td[class*="span"],table th[class*="span"],.row-fluid table td[class*="span"],.row-fluid table th[class*="span"]{display:table-cell;float:none;margin-left:0;}\r\n.table td.span1,.table th.span1{float:none;width:44px;margin-left:0;}\r\n.table td.span2,.table th.span2{float:none;width:124px;margin-left:0;}\r\n.table td.span3,.table th.span3{float:none;width:204px;margin-left:0;}\r\n.table td.span4,.table th.span4{float:none;width:284px;margin-left:0;}\r\n.table td.span5,.table th.span5{float:none;width:364px;margin-left:0;}\r\n.table td.span6,.table th.span6{float:none;width:444px;margin-left:0;}\r\n.table td.span7,.table th.span7{float:none;width:524px;margin-left:0;}\r\n.table td.span8,.table th.span8{float:none;width:604px;margin-left:0;}\r\n.table td.span9,.table th.span9{float:none;width:684px;margin-left:0;}\r\n.table td.span10,.table th.span10{float:none;width:764px;margin-left:0;}\r\n.table td.span11,.table th.span11{float:none;width:844px;margin-left:0;}\r\n.table td.span12,.table th.span12{float:none;width:924px;margin-left:0;}\r\n.table tbody tr.success>td{background-color:#dff0d8;}\r\n.table tbody tr.error>td{background-color:#f2dede;}\r\n.table tbody tr.warning>td{background-color:#fcf8e3;}\r\n.table tbody tr.info>td{background-color:#d9edf7;}\r\n.table-hover tbody tr.success:hover>td{background-color:#d0e9c6;}\r\n.table-hover tbody tr.error:hover>td{background-color:#ebcccc;}\r\n.table-hover tbody tr.warning:hover>td{background-color:#faf2cc;}\r\n.table-hover tbody tr.info:hover>td{background-color:#c4e3f3;}\r\n\r\n.well{min-height:20px;padding:19px;margin-bottom:20px;background-color:#f5f5f5;border:1px solid #e3e3e3;-webkit-border-radius:4px;-moz-border-radius:4px;border-radius:4px;-webkit-box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);-moz-box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);}.well blockquote{border-color:#ddd;border-color:rgba(0, 0, 0, 0.15);}\r\n.well-large{padding:24px;-webkit-border-radius:6px;-moz-border-radius:6px;border-radius:6px;}\r\n.well-small{padding:9px;-webkit-border-radius:3px;-moz-border-radius:3px;border-radius:3px;}\r\n\r\ntable.dl-table td{line-height:20px;}\r\ntd.invoice_label{text-align:right;font-weight:bold;\r\nwidth:120px; padding-right:20px;line-height:20px;}', '<div style="font-family:Helvetica; font-size:12px;"  >\r\n  <table width="100%">\r\n    <tr>\r\n      <td width="50%"  valign="top"><img src="http://www.joomlathat.com/images/joomlathat3.png" /><br />\r\n        <br />\r\n        <table class="dl-table">\r\n          <tbody>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[FROM]]</td>\r\n                <td valign="top"><strong>{from_name}</strong></td>\r\n              </tr>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[ADDRESS]]</td>\r\n                <td valign="top"><address>\r\n                  {from_address}\r\n                  </address></td>\r\n              </tr>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[EMAIL]]</td>\r\n                <td valign="top">{from_email}</td>\r\n              </tr>\r\n              <tr>\r\n                <td class="invoice_label" valign="top">[[FISCAL_NUMBER]]</td>\r\n                <td valign="top">{from_num}</td>\r\n              </tr>\r\n            </tbody>\r\n        </table></td>\r\n      <td width="50%"  valign="top"><div class="well well-small">\r\n          <table class="dl-table">\r\n              <tbody>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[QUOTE_NUM]]</td>\r\n                  <td valign="top">{invoice_num}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[QUOTE_DATE]]</td>\r\n                  <td valign="top">{invoice_date}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[DUE_DATE]]</td>\r\n                  <td valign="top">{invoice_duedate}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[QUOTE_TOTAL]]</td>\r\n                  <td valign="top">{total}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[STATUS]]</td>\r\n                  <td valign="top">{status}</td>\r\n                </tr>\r\n              </tbody>\r\n            </table>\r\n        </div>\r\n        <div class="well well-small">\r\n          <table class="dl-table">\r\n            <tbody>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[BILL_TO]]</td>\r\n                  <td valign="top"><strong>{to_name}</strong></td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[ADDRESS]]</td>\r\n                  <td valign="top"><address>\r\n                    {to_company} <br />\r\n                    {to_address} <br />\r\n                    {to_zipcode} {to_city} <br />\r\n                    {to_state} {to_country}\r\n                    </address></td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[EMAIL]]</td>\r\n                  <td valign="top">{to_email}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[VATID]]</td>\r\n                  <td valign="top">{to_vatid}</td>\r\n                </tr>\r\n                <tr>\r\n                  <td class="invoice_label" valign="top">[[PHONE]]</td>\r\n                  <td valign="top">{to_phone}</td>\r\n                </tr>\r\n              </tbody>\r\n          </table>\r\n        </div></td>\r\n    </tr>\r\n  </table>\r\n  <h2 class="invoice_header">[[ITEMS]]</h2>\r\n  <table width="100%" class="table table-striped">\r\n    <thead>\r\n      <tr>\r\n        <th align="left">[[SKU]]</th>\r\n        <th align="left">[[DESCRIPTION]]</th>\r\n        <th style="text-align: right;" align="right">[[UNIT_COST]]</th>\r\n        <th style="text-align: right;" align="right">[[QUANTITY]]</th>\r\n        <th style="text-align: right;" align="right">[[DISCOUNT]]</th>\r\n        <th style="text-align: right;" align="right">[[TAX]]</th>\r\n        <th style="text-align: right;" align="right">[[PRICE]]</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <!--ITEMS-->\r\n      <tr>\r\n        <td>{sku}</td>\r\n        <td><strong>{name}</strong><br />\r\n          {desc}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n        <td style="text-align: right;" align="right">{amount}</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n        <td style="text-align: right;" align="right">{tax}</td>\r\n        <td style="text-align: right;" align="right">{item_total}</td>\r\n      </tr>\r\n      <!--/ITEMS-->\r\n    </tbody>\r\n    <tfoot>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[DISCOUNT]]</td>\r\n        <td style="text-align: right;" align="right">{discount}</td>\r\n      </tr>\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">[[SUBTOTAL]]</td>\r\n        <td style="text-align: right;" align="right">{subtotal}</td>\r\n      </tr>\r\n      <!--TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right">{name}</td>\r\n        <td style="text-align: right;" align="right">{value}</td>\r\n      </tr>\r\n      <!--/TAXES-->\r\n      <tr>\r\n        <td colspan="4"> </td>\r\n        <td style="text-align: right;" colspan="2" align="right"><strong>[[TOTAL]]</strong></td>\r\n        <td style="text-align: right;" align="right"><strong>{total}</strong></td>\r\n      </tr>\r\n    </tfoot>\r\n  </table>\r\n  <div style="padding: 2px;">[[NOTES]]</div>\r\n  <div style="border-top:1px solid #000; padding:2px; " class="muted"><small>{notes}</small></div>\r\n</div>');
