<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Script file of INVOICE MANAGER component
 */
class com_InvoicesInstallerScript
{
	/**
	 * method to install the component
	 *
	 * @return void
	 */
	function install($parent)
	{

	}

	/**
	 * method to uninstall the component
	 *
	 * @return void
	 */
	function uninstall($parent)
	{
	
	}

	/**
	 * method to update the component
	 *
	 * @return void
	 */
	function update($parent)
	{
		// $parent is the class calling this method
		//print_r($parent->manifest);die;
		$this->update_taxes();
	}

	/**
	 * method to run before an install/update/uninstall method
	 *
	 * @return void
	 */
	function preflight($type, $parent)
	{
		// $parent is the class calling this method
		// $type is the type of change (install, update or discover_install)
	}

	/**
	 * method to run after an install/update/uninstall method
	 *
	 * @return void
	 */
	function postflight($type, $parent)
	{
		// $parent is the class calling this method
		// $type is the type of change (install, update or discover_install)
	}

	function update_taxes(){

		if(!defined('DS')){
			define('DS',DIRECTORY_SEPARATOR);
		}

		$db = JFactory::getDBO();

		$query = " SELECT id FROM #__invoices_tax_invoice ";
		$db->setQuery($query);
		$notempty = $db->loadResult();

		require_once(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'helpers.php');

		require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'tables'.DS.'invoice.php' );
		require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'tables'.DS.'contact.php' );
		require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'tables'.DS.'item.php' );
		require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'tables'.DS.'payment.php' );
		require_once( JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'tables'.DS.'taxinvoice.php' );

		if(!$notempty){ //only if it's empty

			//function to update taxes method from 2.0 to 2.1

			$model = InvoicesHelper::getInvoiceAdminModel();

			$query = " SELECT * FROM #__invoices_invoices WHERE taxes != '' ";
			$db->setQuery($query);
			$invoices = $db->loadObjectList();

			$query = " SELECT * FROM #__invoices_taxes ";
			$db->setQuery($query);
			$alltaxes = $db->loadObjectList('id');

			foreach($invoices as $invoice){
				$taxes = explode(",", $invoice->taxes);
				foreach($taxes as $tax){
					$model->add_tax_to_invoice($tax, $alltaxes[$tax]->value, $invoice->id);
				}

				$invoice_computed_total = InvoicesHelper::get_total_from_id($invoice->id, true) ;
				$invoice_computed_subtotal = InvoicesHelper::get_subtotal_items($invoice->id) ;

				$query = "UPDATE #__invoices_invoices SET computed_total = '$invoice_computed_total', computed_subtotal = '$invoice_computed_subtotal' WHERE id = " . $invoice->id ;
				$db->setQuery($query);
				$db->query();

			}

		}


		$query = " SELECT * FROM #__invoices_invoices ";
		$db->setQuery($query);
		$invoices = $db->loadObjectList();

		foreach($invoices as $invoice){

			InvoicesHelper::updateComputedData($invoice->id);
		}

	}
}
