<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport('joomla.application.component.model');

class TemplatesModelTemplate extends JModelLegacy
{

	var $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

		$array = $this->input->get('cid',  0, '', 'array');
		$this->setId((int)$array[0]);

		$this->params = JComponentHelper::getParams( 'com_invoices' );

	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;

	}

	function &getData()
	{
		// Load the data
		if (empty( $this->_data )) {
			$query = ' SELECT te.* FROM #__invoices_templates as te '.

					'  WHERE te.id = '.$this->_id;
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();


		}
		//print_r( $this->_data);die();
		if (!$this->_data) {
			$this->_data = new stdClass();
			$this->_data->id = 0;
			$this->_data->name = "";
			$this->_data->content = "";
			$this->_data->items = "";
			$this->_data->taxes = "";
			$this->_data->payments = "";
            $this->_data->content_pdf = "";
            $this->_data->styles = "";
			$this->_data->company_logo = "";
		}

		return $this->_data;
	}

	function duplicate($template_id){

		$params = JComponentHelper::getParams( 'com_invoices' );

		//get the current data
		$query = ' SELECT * FROM #__invoices_templates '.
				 ' WHERE id = '.$template_id;
		$this->_db->setQuery( $query );
		$template = $this->_db->loadAssoc();

		$template['id'] = 0 ;
		$template['name'] = $template['name']." [COPY]" ;

		//save the template
		$this->store($template);

		return true;

	}

	function store($data = false)
	{
		$row = $this->getTable();

		if(!$data) {
			$data = $this->input->post->getArray();

			$data['content'] = $this->input->post->getRaw('thecontent');
			$data['taxes'] = $this->input->post->getRaw('taxes');
			$data['items'] = $this->input->post->getRaw('items');
			$data['payments'] = $this->input->post->getRaw('payments');

			$data['payments2'] = $this->input->post->getRaw('payments2');
			$data['styles'] = $this->input->post->getRaw('styles');
			$data['content_pdf'] = $this->input->post->getRaw('content_pdf');
			$data['content_email'] = $this->input->post->getRaw('content_email');
			$data['content_vue'] = $this->input->post->getRaw('content_vue');

		}

		$datafiles = $this->input->files->getArray();

		// Bind the form fields to the album table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->bind($datafiles)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->check()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->store()) {
			//print_r($row);die();
			$this->setError( $this->_db->getErrorMsg() );
			return false;
		}

		return $row->id;
	}


	function delete()
	{
		$cids = $this->input->get( 'cid', array(0), 'post', 'array' );

		$row = $this->getTable();

		if (count( $cids )) {
			foreach($cids as $cid) {

				if (!$row->delete( $cid )) {
					$this->setError( $row->getErrorMsg() );
					return false;
				}
			}
		}
		return true;
	}

}
