<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport('joomla.application.component.model');

class ContactsModelContact extends JModelLegacy
{

	var $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

		$array = $this->input->get('cid',  0, '', 'array');
		$this->setId((int)$array[0]);

		$this->params = JComponentHelper::getParams( 'com_invoices' );

	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;

	}

	function &getData()
	{
		// Load the data
		if (empty( $this->_data )) {
			$query = ' SELECT co.*, u.username FROM #__invoices_contacts as co '.
					' LEFT JOIN #__users as u ON u.id = co.user_id ' .
					' WHERE co.id = '.$this->_id;
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();


		}
		//print_r( $this->_data);die();
		if (!$this->_data) {
			$this->_data = new stdClass();
			$this->_data->id = 0;
			$this->_data->name = "";
			$this->_data->company = "";
			$this->_data->address = "";
			$this->_data->email = "";
			$this->_data->user_id = 0;
			$this->_data->username = "";
			$this->_data->phone = "";
			$this->_data->zipcode = "";
			$this->_data->city = "";
			$this->_data->state = "";
			$this->_data->country = "";
			$this->_data->vatid = "";

		}

		return $this->_data;
	}

	function store($data = false)
	{
		$row = $this->getTable();

		if(!$data) {
			$data = $this->input->post->getArray();
		}

		if($data['vincular_cliente_checkbox'] == 0){
			$data['user_id'] = 0 ;
		}

		// Bind the form fields to the album table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->check()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if (!$row->store()) {
			$this->setError( $this->_db->getErrorMsg() );
			return false;
		}

		return $row->id;
	}


	function delete()
	{
		$cids = $this->input->get( 'cid', array(0), 'default', 'array' );

		$row = $this->getTable();

		if (count( $cids )) {
			foreach($cids as $cid) {

				if (!$row->delete( $cid )) {
					$this->setError( $row->getErrorMsg() );
					return false;
				}
			}
		}
		return true;
	}

	function getDataDisplay($id = false)
	{
		if($id) $this->setId($id);

		$params = JComponentHelper::getParams( 'com_invoices' );

		$query = ' SELECT co.*, u.username FROM #__invoices_contacts as co '.
					' LEFT JOIN #__users as u ON u.id = co.user_id ' .
					' WHERE co.id = '.$this->_id;
		$this->_db->setQuery( $query );
		$row = $this->_db->loadObject();

		$query = ' SELECT SUM(i.computed_total) AS total_invoices, COUNT(DISTINCT i.id) AS nun_invoices FROM #__invoices_invoices AS i WHERE i.user_id = '.$row->id ;
		$this->_db->setQuery($query);
		$invoices = $this->_db->loadObject();
		$row->total_invoices = $invoices->total_invoices;
		$row->num_invoices = $invoices->nun_invoices;

		$row->formatted_total_invoices = InvoicesHelper::format($row->total_invoices, $params->get('currency_before'), $params->get('currency_after'));

		if($row->user_id) $row->joomlauser = $row->username;
		else $row->joomlauser = JText::_('JNO');

		return $row;
	}

}
