<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

//new for Joomla 3.0
if(!defined('DS')){
define('DS',DIRECTORY_SEPARATOR);
}

$jinput = JFactory::getApplication()->input;

if (!JFactory::getUser()->authorise('core.manage', 'com_invoices'))
{
	return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
}

// Require the base controller
require_once(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'helpers.php');
require_once( JPATH_COMPONENT.DS.'controller.php' );

$params = JComponentHelper::getParams( 'com_invoices' );

// Require specific controller if requested
if($controller = $jinput->getWord('controller')) {

	$path = JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';
	if (file_exists($path)) {
		require_once $path;
	} else {
		$controller = '';
	}
}

$invoices = false;
$payments = false;
$items = false;
$templates = false;
$taxes = false;
$contacts = false;
$templateitems = false;
$quotes = false;

switch($controller){

	case "invoices":
	case "invoice":
		$invoices = true;
		$prefix	= 'Invoices';
		break;

	case "payments":
	case "payment":

		$payments = true;
		$prefix	= 'Payments';
		break;

	case "items":
	case "item":

		$items = true;
		$prefix	= 'Items';
		break;

	case "templates":
	case "template":

		$templates = true;
		$prefix	= 'Templates';
		break;

	case "taxes":
	case "tax":

		$taxes = true;
		$prefix	= 'Taxes';
		break;

	case "contacts":
	case "contact":

		$contacts = true;
		$prefix	= 'Contacts';
		break;

	case "templateitems":
	case "templateitem":

		$templateitems = true;
		$prefix	= 'Templateitems';
		break;

	case "quotes":
	case "quote":

		$quotes = true;
		$prefix	= 'Quotes';
		break;

		case "currencies":
		case "currency":

			$currencies = true;
			$prefix	= 'Currencies';
			break;

	default:
		$invoices = true ;
		$prefix	= 'Invoices';
		break;
}

$lang = JFactory::getLanguage();
$lang->load('com_invoices', JPATH_SITE);

$document	= JFactory::getDocument();
$document->addStyleSheet('components/com_invoices/assets/css/template-isis.css');

$document->addStyleSheet('components/com_invoices/assets/css/invoices.css');

JHtml::_('jquery.framework');

$document->addStyleSheet('components/com_invoices/assets/libs/datepicker/css/bootstrap-datepicker3.min.css');
$document->addScript('components/com_invoices/assets/libs/datepicker/js/bootstrap-datepicker.min.js');

$document->addStyleSheet("components/com_invoices/assets/css/spinner.css");
$document->addScript('components/com_invoices/assets/libs/mdl/material.min.js');

//BS3
$document->addScript('components/com_invoices/assets/libs/bootstrap/js/bootstrap-buttons.js');
$document->addScript('components/com_invoices/assets/libs/bootstrap/js/bootstrap-modal.js');
$document->addScript('components/com_invoices/assets/libs/bootstrap/js/bootstrap-tooltips.js');
$document->addScript('components/com_invoices/assets/libs/bootstrap/js/bootstrap-scrollspy.js');

$document->addScript('components/com_invoices/assets/js/bootstrap2.js');

//BS3
$document->addStyleSheet("components/com_invoices/assets/libs/bootstrap/css/bootstrap-buttons.css");
$document->addStyleSheet("components/com_invoices/assets/libs/bootstrap/css/bootstrap-glyphicons.css");
$document->addStyleSheet("components/com_invoices/assets/libs/bootstrap/css/bootstrap-forms.css");
$document->addStyleSheet("components/com_invoices/assets/libs/bootstrap/css/bootstrap-modal.css");
$document->addStyleSheet("components/com_invoices/assets/libs/bootstrap/css/bootstrap-labels.css");
$document->addStyleSheet("components/com_invoices/assets/libs/bootstrap/css/bootstrap-panels.css");

//BS4
// $document->addStyleSheet("https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/css/bootstrap.min.css");
// $document->addScript("https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.11.0/umd/popper.min.js");
// $document->addScript("https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js");

$document->addScript('components/com_invoices/assets/libs/noty/js/noty/packaged/jquery.noty.packaged.min.js');
$document->addScript('components/com_invoices/assets/libs/noty/js/noty/themes/material.js');

$document->addScript("components/com_invoices/assets/libs/typeahead.js/typeahead.bundle.js");

//Vue
if($params->get('vue', 1)) $document->addScript("components/com_invoices/assets/libs/vue/vue.min.js");
else $document->addScript("components/com_invoices/assets/libs/vue/vue.js");

//Moment
$document->addScript("components/com_invoices/assets/libs/moment/moment-with-locales.min.js");

//Tween
$document->addScript("components/com_invoices/assets/libs/Tween.js");

//nav bar
$document->addStyleSheet("components/com_invoices/assets/css/slide-menu.css");
$document->addScript("components/com_invoices/assets/libs/jquery.big-slide.js");

$document->addScript('components/com_invoices/assets/js/common.js');

//PDF check
$mainframe = JFactory::getApplication();
//$version = PHP_VERSION >= 5.0 ? true : false ;
$quotes = get_magic_quotes_gpc();
//echo $quotes;die;
if(file_exists(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'dompdf'.DS.'dompdf_config.inc.php') && $quotes){
	$mainframe->enqueueMessage(JText::sprintf('ALERT_PDF_MAGIC_QUOTES', php_ini_loaded_file()));
}

//plugin check
$main_plugin_ok = JPluginHelper::importPlugin('system', 'invoices');
if(!$main_plugin_ok){
	$mainframe->enqueueMessage(JText::_('ALERT_SYSTEM_PLUGIN'), 'warning');
}

// Create the controller
$classname	= $prefix.'Controller'.$controller;

$controller	= new $classname( );

// Perform the Request task
$controller->execute( $jinput->getVar( 'task' ) );

// Redirect if set by the controller
$controller->redirect();
