<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class TaxesControllerTax extends TaxesController
{

	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply',	'save' );
	}

	function edit()
	{
		$this->input->set( 'view', 'tax' );
		$this->input->set( 'layout', 'form'  );
		$this->input->set('hidemainmenu', 1);

		parent::display();
	}

	function save()
	{
		$model = $this->getModel('tax');

		if ($model->store()) {
			$msg = JText::_( 'TAX_SAVED' );
		} else {
			$msg = JText::_( 'ERROR_SAVING_TAX' );
		}

		$task = $this->input->getCmd( 'task' );
		$id = $this->input->getInt('id');

		switch ($task)
		{
			case 'apply':
				$link = 'index.php?option=com_invoices&controller=tax&task=edit&cid[]='. $id ;
				break;

			case 'save':
			default:
				$link = 'index.php?option=com_invoices&controller=taxes';
				break;
		}

		$this->setRedirect($link, $msg);
	}

	function remove()
	{
		$model = $this->getModel('tax');
		if(!$model->delete()) {
			$msg = JText::_( 'ERROR_DELETING_TAXS' );
		} else {
			$msg = JText::_( 'TAXS_DELETED' );
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=taxes', $msg );
	}

	function cancel()
	{
		$msg = JText::_( 'OPERATION_CANCELLED' );
		$this->setRedirect( 'index.php?option=com_invoices&controller=taxes', $msg );
	}
}
