<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class QuotesControllerQuote extends QuotesController
{

	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply',	'save' );
	}

	function display( $cachable = false, $urlparams = array())
	{

		$modal = $this->input->getInt( 'modal' ) ;
		$tmpl = $this->input->getString( 'tmpl' ) ;

		if(($modal || $tmpl == "component")){
			$layout = $this->input->getString( 'layout' );

			$mainframe = JFactory::getApplication();

			$model = $this->getModel('quote');

			$view = $this->getInvoiceView();

			$params = JComponentHelper::getParams( 'com_invoices' );

			$view->setModel($model);

			$view->invoice = $model->getData();
			$view->items = $model->getItems();
			$view->template = $model->getTemplate();
			$view->taxes = $model->getTaxesInvoice();
			$view->payments = $model->getPaymentsInvoice();
			$view->payments2 = $model->getPaymentsInvoice2();

			$view->params = $params;

			$content = $view->loadTemplate( 'email' );

			$data = $this->get_invoice_data();

			$return = new stdClass();

			//we fill the content to return
			$return->content = $content ;
			$return->data = $data ;

			$this->sendJSONResponse($return);

		}

		parent::display($cachable,$urlparams);
	}

	static function getQuoteView()
	{
		if (!class_exists( 'QuotesViewQuote' ))
		{
			// Build the path to the model based upon a supplied base path
			$path = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'quote'.DS.'view.html.php';
			$false = false;

			// If the model file exists include it and try to instantiate the object
			if (file_exists( $path )) {
				require_once( $path );
				//require_once(JPATH_SITE.DS.'components'.DS.'com_finances'.DS.'views'.DS.'item'.DS.'tmpl'.DS.'default_email.php');
				if (!class_exists( 'QuotesViewQuote' )) {
					JError::raiseWarning( 0, 'View class QuotesViewQuote not found in file.' );
					return $false;
				}
			} else {
				JError::raiseWarning( 0, 'View QuotesViewQuote not supported. File not found.' );
				return $false;
			}
		}

		$view = new QuotesViewQuote();
		return $view;
	}

	function edit()
	{
		if(InvoicesHelper::allowEdit()){
			$this->input->set( 'view', 'invoice' );
			$this->input->set( 'layout', 'form'  );
			$this->input->set( 'hidemainmenu', 1);

			$modal = $this->input->getInt( 'modal' ) ;
			$tmpl = $this->input->getString( 'tmpl' ) ;

			if(($modal || $tmpl == "component")){
				$layout = $this->input->getString( 'layout' );

				$model = $this->getModel('quote');

				$return = new stdClass();

				//we fill the content to return
				$return->data = $model->getData();
				
				$this->sendJSONResponse($return);

			}

			parent::display();
		}

		else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
	}

	function save()
	{
		$mainframe = JFactory::getApplication();

		$model = $this->getModel('invoice');

		if ($id = $model->store()) {
			$msg = JText::_( 'QUOTE_SAVED' );
			$type = "message";
		} else {
			$msg = JText::_( 'ERROR_SAVING_QUOTE' );
			$type = "error";
		}

		$task = $this->input->getCmd( 'task' );
		$tab = $this->input->getCmd( 'tab' );

		switch ($task)
		{
			case 'apply':
				$link = 'index.php?option=com_invoices&controller=quote&task=edit&cid[]='. $id.'&tab='.$tab ;
				break;

			case 'save':
			default:
				$link = 'index.php?option=com_invoices&controller=quotes';
				break;
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay($id) ;

			//we return the totals as well
			$modelinvoices = $this->getModel('quotes');
			$return->summary = $modelinvoices->getTotals();

			//return json
			$this->sendJSONResponse($return);
		}

		$this->setRedirect($link, $msg);
	}

	function remove()
	{
		$mainframe = JFactory::getApplication();

		if(InvoicesHelper::canDelete()){
			$model = $this->getModel('quote');
			if(!$model->delete()) {
				$msg = JText::_( 'ERROR_DELETING_QUOTES' );
				$type = "error";
			} else {
				$msg = JText::_( 'QUOTES_DELETED' );
				$type = "message";
			}

			$this->setRedirect( 'index.php?option=com_invoices&controller=quotes', $msg );
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = "" ;

			//we return
			echo json_encode($return);

			$mainframe->close();
		}
	}

	function cancel()
	{
		$msg = JText::_( 'OPERATION_CANCELLED' );
		$this->setRedirect( 'index.php?option=com_invoices&controller=quotes', $msg );
	}

	function publish()
	{
		$mainframe = JFactory::getApplication();

		if(InvoicesHelper::canEditState()){
			$model = $this->getModel('quote');
			if(!$model->publish()) {
				$msg = JText::_( 'ERROR_PUBLISHING_QUOTES' );
				$type = "error";
			} else {
				$msg = JText::_( 'QUOTES_PUBLISHED' );
				$type = "message";
			}

			$this->setRedirect( 'index.php?option=com_invoices&controller=quotes', $msg );
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay() ;

			//we return
			echo json_encode($return);

			$mainframe->close();
		}
	}

	function unpublish()
	{
		$mainframe = JFactory::getApplication();

		if(InvoicesHelper::canEditState()){
			$model = $this->getModel('quote');
			if(!$model->unpublish()) {
				$msg = JText::_( 'ERROR_UNPUBLISHING_QUOTES' );
				$type = "error";
			} else {
				$msg = JText::_( 'QUOTES_UNPUBLISHED' );
				$type = "message";
			}

			$this->setRedirect( 'index.php?option=com_invoices&controller=quotes', $msg );
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay() ;

			//we return
			echo json_encode($return);

			$mainframe->close();
		}
	}

	function duplicate()
	{
		$mainframe = JFactory::getApplication();

		$cids = $this->input->getVar( 'cid', array(0), 'default', 'array' );

		$model = $this->getModel('quote');

		if (count( $cids )) {
			foreach($cids as $cid) {
				$model->duplicate($cid);
			}
		}

		$msg = JText::_( 'QUOTES_DUPLICATED' );
		$type = "message";

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = "" ;

			//we return
			echo json_encode($return);

			$mainframe->close();
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=quotes', $msg );
	}


	function send_email(){
		$mainframe = JFactory::getApplication();

		$id = $this->input->getVar("id");

		$lang = JFactory::getLanguage();
		$lang->load('com_invoices', JPATH_SITE);

		$model = $this->getQuoteModel();

		$cids = $this->input->getVar( 'cid', array(0), 'default', 'array' );

		if (count( $cids )) {
			foreach($cids as $cid) {
				$model->setId($cid) ;

				if ($model->sendMail()) {
					$msg = JText::sprintf( 'QUOTE_SENT', $model->_data->invoice_num, $model->_data->to_email );
					$mainframe->enqueueMessage($msg);

				} else {
					$msg = JText::sprintf( 'ERROR_SENDING_QUOTE', $model->_data->invoice_num, $model->_data->to_email );
					$mainframe->enqueueMessage($msg, 'error');

				}
			}
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications = $mainframe->getMessageQueue();

			//we fill the content to return
			//this is the LAST invoice data. Only useful for one invoice at a time
			$return->content = $model->getDataDisplay() ;

			//we return
			echo json_encode($return);

			$mainframe->close();
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=quotes' );
	}

	function convert_to_invoice()
	{

		$cids = $this->input->getVar( 'cid', array(0), 'post', 'array' );

		$model = $this->getModel('quote');

		if (count( $cids )) {
			foreach($cids as $cid) {
				$model->duplicate($cid, 1);
			}
		}

		$msg = JText::_( 'QUOTES_CONVERTED_TO_INVOICE' );

		$this->setRedirect( 'index.php?option=com_invoices&controller=invoices', $msg );
	}

	function getQuoteModel()
	{
		if (!class_exists( 'QuotesModelQuote' ))
		{
			// Build the path to the model based upon a supplied base path
			$path = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'models'.DS.'quote.php';
			$false = false;

			// If the model file exists include it and try to instantiate the object
			if (file_exists( $path )) {
				require_once( $path );
				if (!class_exists( 'QuotesModelQuote' )) {
					JError::raiseWarning( 0, 'View class QuotesModelQuote not found in file.' );
					return $false;
				}
			} else {
				JError::raiseWarning( 0, 'View QuotesModelQuote not supported. File not found.' );
				return $false;
			}
		}

		$model = new QuotesModelQuote(false, false, false);
		return $model;
	}

	function get_invoice_data(){

		$params = JComponentHelper::getParams( 'com_invoices' );

		$model = $this->getModel('quote');

		$invoice = $model->getData();

		return $invoice;
	}

	function get_invoice(){

		$invoice = $this->get_invoice_data();

		//return json
		$this->sendJSONResponse($return);
	}

}
