<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class PaymentsControllerPayments extends PaymentsController
{

	function __construct()
	{
		parent::__construct();
		$this->input->set('view', 'payments');

	}

	function export(){

		//require_once(JPATH_SITE.DS.'components'.DS.'com_finances'.DS.'models'.DS.'items.php');
		require_once(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'payments'.DS.'view.html.php');

		//$model = new FinancesModelItems();
		$model = $this->getModel('payments');
		$view = new PaymentsViewPayments();

		$max = 5000;
		$total = $model->getTotal();
		if($total > $max){
			$link = 'index.php?option=com_invoices&controller=payments';
			$msg = JText::sprintf('YOU_CANONT_EXPORT', $max, $max) ;
			$this->setRedirect($link, $msg, "warning");
		}
		else{

		  $filename = "payments_" . date('Y_m_d') . ".csv";

		  header("Content-Disposition: attachment; filename=\"$filename\"");
		  header("Content-Type: text/csv");

			$view->setModel($model);

			$view->pagination = $model->getPagination();
			$view->cal_start = $model->getCalstart();
			$view->cal_end = $model->getCalend();
			$view->items = $model->getData();
			$view->status = InvoicesHelper::getStatusPaymentFilters();
			$view->status_id = $model->getStatusId();
			$view->invoice_id = $model->getInvoiceId();

			$content = $view->loadTemplate( 'csv' );

			echo $content;

			die;

		}

	}

	function load_items(){

		$mainframe = JFactory::getApplication();

		$params = JComponentHelper::getParams( 'com_invoices' );

		$model = $this->getModel('payments');

		$items = $model->getData();
		$summary = $model->getTotals();

		$result = new stdClass();
		$result->items = $items;
		$result->summary = $summary;

		$this->sendJSONResponse($result);
	}

	function get_totals(){

		$mainframe = JFactory::getApplication();

		$params = JComponentHelper::getParams( 'com_invoices' );

		$model = $this->getModel('payments');

		$summary = $model->getTotals();

		$return = new stdClass();
		$return->notifications = array();

		//we fill the content to return
		$return->content = $summary ;

		$this->sendJSONResponse($return);
	}

}
