<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class PaymentsControllerPayment extends PaymentsController
{

	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply',	'save' );
	}

	function edit()
	{
		if(InvoicesHelper::allowEdit()){
			$this->input->set( 'view', 'payment' );
			$this->input->set( 'layout', 'form'  );
			$this->input->set( 'hidemainmenu', 1);

			$modal = $this->input->getInt( 'modal' ) ;
			$tmpl = $this->input->getString( 'tmpl' ) ;

			if(($modal || $tmpl == "component")){

				$mainframe = JFactory::getApplication();

				$model = $this->getModel('payment');

				$view = $this->getPaymentView();

				$params = JComponentHelper::getParams( 'com_invoices' );

				$view->setModel($model);

				$view->payment = $model->getData();

				$view->setLayout('form');

				$view->params = $params;

				$content = $view->loadTemplate( 'form' );

				echo $content;

				$mainframe->close();
			}

			parent::display();
		}

		else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
	}

	static function getPaymentView()
	{
		if (!class_exists( 'PaymentsViewPayment' ))
		{
			// Build the path to the model based upon a supplied base path
			$path = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'payment'.DS.'view.html.php';
			$false = false;

			// If the model file exists include it and try to instantiate the object
			if (file_exists( $path )) {
				require_once( $path );
				//require_once(JPATH_SITE.DS.'components'.DS.'com_finances'.DS.'views'.DS.'item'.DS.'tmpl'.DS.'default_email.php');
				if (!class_exists( 'PaymentsViewPayment' )) {
					JError::raiseWarning( 0, 'View class PaymentsViewPayment not found in file.' );
					return $false;
				}
			} else {
				JError::raiseWarning( 0, 'View PaymentsViewPayment not supported. File not found.' );
				return $false;
			}
		}

		$view = new PaymentsViewPayment();
		return $view;
	}

	function save()
	{
		$model = $this->getModel('payment');

		if ($id = $model->store()) {
			$msg = JText::_( 'PAYMENT_SAVED' );
			$type = "message";
		} else {
			$msg = JText::_( 'ERROR_SAVING_PAYMENT' );
			$type = "error";
		}

		$task = $this->input->getCmd( 'task' );
		$from = $this->input->getCmd( 'from' );

		switch ($task)
		{
			case 'apply':
				$link = 'index.php?option=com_invoices&controller=payment&task=edit&cid[]='. $id ;
				break;

			case 'save':
			default:
				$link = 'index.php?option=com_invoices&controller=payments';
				if($from == "invoices") $link = 'index.php?option=com_invoices&controller=invoices';
				break;
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay($id) ;

			//return json
			$this->sendJSONResponse($return);
		}

		$this->setRedirect($link, $msg);
	}

	function remove()
	{
		$mainframe = JFactory::getApplication();

		if(InvoicesHelper::canDelete()){

			$model = $this->getModel('payment');

			$frominvoice = $this->input->getInt( 'frominvoice' );

			$invoice_id = $this->input->getInt('id');

			if(!$model->delete()) {
				$msg = JText::_( 'ERROR_DELETING_PAYMENT' );
				$type = "error";
			} else {
				$msg = JText::_( 'PAYMENT_DELETED' );
				$type = "message";
			}

			$link = 'index.php?option=com_invoices&controller=payments';
			if($frominvoice) $link = 'index.php?option=com_invoices&controller=invoice&task=edit&cid[]='.$frominvoice;
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = "" ;

			//we return
			echo json_encode($return);

			$mainframe->close();
		}

		$this->setRedirect( $link, $msg );
	}

	function cancel()
	{
		$msg = JText::_( 'OPERATION_CANCELLED' );
		$from = $this->input->getCmd( 'from' );

		$link = 'index.php?option=com_invoices&controller=payments';

		if($from == "invoices") $link = 'index.php?option=com_invoices&controller=invoices';

		$this->setRedirect( $link, $msg );
	}

	function publish()
	{
		$model = $this->getModel('payment');
		if(!$model->publish()) {
			$msg = JText::_( 'ERROR_MARKING_PAYMENT_PAYED' );
		} else {
			$msg = JText::_( 'PAYMENT_PAYED' );
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=payments', $msg );
	}

	function unpublish()
	{
		$model = $this->getModel('payment');
		if(!$model->unpublish()) {
			$msg = JText::_( 'ERROR_MARKING_PAYMENT_UNPAYED' );
		} else {
			$msg = JText::_( 'PAYMENT_NOT_PAYED' );
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=payments', $msg );
	}

	function search_invoice(){
		$mainframe = JFactory::getApplication();

		$return = "";

		$keywords = $this->input->getVar("searchword");

		$db = JFactory::getDBO();

		$where_clause[] = ' ( u.name LIKE "%'.$keywords.'%" OR u.username LIKE "%'.$keywords.'%" OR u.email LIKE "%'.$keywords.'%" OR i.id LIKE "%'.$keywords.'%" OR i.invoice_num LIKE "%'.$keywords.'%" OR co.name LIKE "%'.$keywords.'%" OR co.company LIKE "%'.$keywords.'%" ) ';

		// Build the where clause of the content record query
		$where_clause = (count($where_clause) ? ' WHERE '.implode(' AND ', $where_clause) : '');

		$query = ' SELECT i.id as invoice_id, i.invoice_num, i.to_name AS name, u.username, CONCAT("[", i.invoice_num, "] ", i.to_name, " (", u.username, ")") AS name_invoice FROM #__invoices_invoices AS i '
				.'LEFT JOIN #__invoices_contacts AS co ON co.id = i.user_id '
				.'LEFT JOIN #__users AS u ON u.id = co.user_id '
				. $where_clause
				.' ORDER BY i.id DESC '
				.' LIMIT 20 ';
		$db->setQuery($query);
		$invoices = $db->loadObjectList();

		$return = $invoices;

		echo json_encode($return) ;

		$mainframe->close();
	}

	function obtain_invoice(){
		$mainframe = JFactory::getApplication();

		$return = array();

		$id = $this->input->getInt("id");

		$db = JFactory::getDBO();

		$query = ' SELECT i.*, u.username, co.name, co.company FROM #__invoices_invoices AS i '
				.' LEFT JOIN #__invoices_contacts AS co ON co.id = i.user_id '
				.' LEFT JOIN #__users AS u ON u.id = co.user_id '
				.' WHERE i.id = ' .$id;
		$db->setQuery($query);
		$invoice = $db->loadObject();

		$return[0] = new stdClass();
		$return[0]->key = 'invoice_id' ;
		$return[0]->value = $invoice->id ;

		$return[1] = new stdClass();
		$return[1]->key = 'name_invoice' ;
		$return[1]->value = "[" .$invoice->invoice_num ."] ".$invoice->name . " (" . $invoice->username. ")" ;

		echo json_encode($return);

		$mainframe->close();
	}
}
