<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class ContactsControllerContact extends ContactsController
{

	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply',	'save' );
	}

	function edit()
	{
		if(InvoicesHelper::allowEdit()){

			$this->input->set( 'view', 'contact' );
			$this->input->set( 'layout', 'form'  );
			$this->input->set( 'hidemainmenu', 1);

			$modal = $this->input->getInt( 'modal' ) ;
			$tmpl = $this->input->getString( 'tmpl' ) ;

			if(($modal || $tmpl == "component")){

				$model = $this->getModel('contact');

				$return = new stdClass();

				//we fill the content to return
				$return->data = $model->getData();

				$this->sendJSONResponse($return);
			}

			parent::display();
		}

		else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
	}

	static function getContactView()
	{
		if (!class_exists( 'ContactsViewContact' ))
		{
			// Build the path to the model based upon a supplied base path
			$path = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'contact'.DS.'view.html.php';
			$false = false;

			// If the model file exists include it and try to instantiate the object
			if (file_exists( $path )) {
				require_once( $path );
				//require_once(JPATH_SITE.DS.'components'.DS.'com_finances'.DS.'views'.DS.'item'.DS.'tmpl'.DS.'default_email.php');
				if (!class_exists( 'ContactsViewContact' )) {
					JError::raiseWarning( 0, 'View class ContactsViewContact not found in file.' );
					return $false;
				}
			} else {
				JError::raiseWarning( 0, 'View ContactsViewContact not supported. File not found.' );
				return $false;
			}
		}

		$view = new ContactsViewContact();
		return $view;
	}

	function save()
	{

		$model = $this->getModel('contact');

		if ($id = $model->store()) {
			$msg = JText::_( 'CONTACT_SAVED' );
			$type = "message";
		} else {
			$msg = JText::_( 'ERROR_SAVING_CONTACT' );
			$type = "error";
		}

		$task = $this->input->getCmd( 'task' );

		switch ($task)
		{
			case 'apply':
				$link = 'index.php?option=com_invoices&controller=contact&task=edit&cid[]='. $id ;
				break;

			case 'save':
			default:
				$link = 'index.php?option=com_invoices&controller=contacts';
				break;
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = $model->getDataDisplay($id) ;

			//return json
			$this->sendJSONResponse($return);
		}

		$this->setRedirect($link, $msg);
	}

	function remove()
	{

		$app = JFactory::getApplication();

		if(InvoicesHelper::canDelete()){
			$model = $this->getModel('contact');
			if(!$model->delete()) {
				$msg = JText::_( 'ERROR_DELETING_CONTACTS' );
				$type = "error";
			} else {
				$msg = JText::_( 'CONTACTS_DELETED' );
				$type = "message";
			}

			$this->setRedirect( 'index.php?option=com_invoices&controller=contacts', $msg );
		}
		else {
			if($this->input->getInt('ajax')) {
				$msg = JText::_( 'JERROR_ALERTNOAUTHOR' );
				$type = "error";
			}
			else return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		if($this->input->getInt('ajax')) {
			//we fill the notification to return
			$return = new stdClass();
			$return->notifications = array();
			$return->notifications[0] = new stdClass();
			$return->notifications[0]->message = $msg;
			$return->notifications[0]->type = $type;

			//we fill the content to return
			$return->content = "" ;

			//we return
			echo json_encode($return);

			$app->close();
		}
	}

	function cancel()
	{
		$msg = JText::_( 'OPERATION_CANCELLED' );
		$this->setRedirect( 'index.php?option=com_invoices&controller=contacts', $msg );
	}

	function search_user(){
		$app = JFactory::getApplication();

		$keywords = $this->input->getVar("searchword");

		$db = JFactory::getDBO();

		$return = "";

		$where_clause[] = ' ( u.name LIKE "%'.$keywords.'%" OR u.username LIKE "%'.$keywords.'%" OR u.email LIKE "%'.$keywords.'%" OR u.id LIKE "%'.$keywords.'%" ) ';

		// Build the where clause of the content record query
		$where_clause = (count($where_clause) ? ' WHERE '.implode(' AND ', $where_clause) : '');

		$query = ' SELECT u.id AS user_id, u.username AS vincular_cliente, u.name AS thename FROM #__users as u ' . $where_clause . ' LIMIT 20 ';
		$db->setQuery($query);
		$usuaris = $db->loadObjectList();

		$return = $usuaris;

		echo json_encode($return) ;

		$app->close();
	}
}
