"use strict";

var invoice_component = Vue.extend({
  template: '#invoice-vue-template',
  props: {
    invoice: Object,
    extended: {
      type: Boolean,
      default: true
    },
  },
  replace: false,
  computed: {
    status_class: function() {

      var status = "default";

      switch (this.invoice.getStatus()) {
        case "paid":case "payed":case "accepted":case "accepted_client":
          status = "success";
          break;
        case "pending":case "partial_paid":
          status = "warning";
          break;
        case "pastdue":case "rejected":case "rejected_client":
          status = "danger";
          break;
        case "refunded":case "partial_refunded":case "cancelled":case "expired":
          status = "inverse";
          break;
        case "corrected":
          status = "info";
          break;
        default:
          status = "default";
          break;
      }

      return status;
    },
    status_name: function() {
      return Joomla.JText._(this.invoice.getStatus());
    },
    rec_title: function() {
      return this.$options.filters.date(this.invoice.rec_nextdate);
    }
  },
  methods: {

    display_tax: function (_display_tax) {
      function display_tax(_x) {
        return _display_tax.apply(this, arguments);
      }

      display_tax.toString = function () {
        return _display_tax.toString();
      };

      return display_tax;
    }(function (tax_id) {
      return display_tax(tax_id);
    })

  },
  mounted: function mounted() {
    jQuery("#row" + this.invoice.id + ' [data-toggle="tooltip"]').tooltip();
    jQuery('#sign_group').button();
  }
});
