<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.0
	@build			13th July, 2022
	@created		13th July, 2022
	@package		Hilation
	@subpackage		relations.php
	@author			farhad shahbazi <http://lmskaran.ir>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Relations Controller
 */
class HilationControllerRelations extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_HILATION_RELATIONS';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Relation', $prefix = 'HilationModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	public function exportData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if export is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('relation.export', 'com_hilation') && $user->authorise('core.export', 'com_hilation'))
		{
			// Get the input
			$input = JFactory::getApplication()->input;
			$pks = $input->post->get('cid', array(), 'array');
			// Sanitize the input
			$pks = ArrayHelper::toInteger($pks);
			// Get the model
			$model = $this->getModel('Relations');
			// get the data to export
			$data = $model->getExportData($pks);
			if (HilationHelper::checkArray($data))
			{
				// now set the data to the spreadsheet
				$date = JFactory::getDate();
				HilationHelper::xls($data,'Relations_'.$date->format('jS_F_Y'),'Relations exported ('.$date->format('jS F, Y').')','relations');
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_HILATION_EXPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_hilation&view=relations', false), $message, 'error');
		return;
	}


	public function importData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if import is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('relation.import', 'com_hilation') && $user->authorise('core.import', 'com_hilation'))
		{
			// Get the import model
			$model = $this->getModel('Relations');
			// get the headers to import
			$headers = $model->getExImPortHeaders();
			if (HilationHelper::checkObject($headers))
			{
				// Load headers to session.
				$session = JFactory::getSession();
				$headers = json_encode($headers);
				$session->set('relation_VDM_IMPORTHEADERS', $headers);
				$session->set('backto_VDM_IMPORT', 'relations');
				$session->set('dataType_VDM_IMPORTINTO', 'relation');
				// Redirect to import view.
				$message = JText::_('COM_HILATION_IMPORT_SELECT_FILE_FOR_RELATIONS');
				$this->setRedirect(JRoute::_('index.php?option=com_hilation&view=import', false), $message);
				return;
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_HILATION_IMPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_hilation&view=relations', false), $message, 'error');
		return;
	}
}
