<?php
/**
 * Form Field class for the Joomla HDP.
 * Supports a textarea inut.
 *
 * @package     Joomla.HDP
 * @subpackage  Form
 */

use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

class HDPFormFieldTextarea extends HDPFormField
{

	protected $type = 'Textarea';

	/**
	 * Method to instantiate the form field object.
	 *
	 * @param   JTable  $row    the table object store form field definitions
	 * @param   mixed   $value  the initial value of the form field
	 *
	 */
	public function __construct($row, $value)
	{
		parent::__construct($row, $value);

		if ($row->place_holder)
		{
			$this->attributes['placeholder'] = $row->place_holder;
		}

		if ($row->max_length)
		{
			$this->attributes['maxlength'] = $row->max_length;
		}

		if ($row->rows)
		{
			$this->attributes['rows'] = $row->rows;
		}

		if ($row->cols)
		{
			$this->attributes['cols'] = $row->cols;
		}
	}

	/**
	 * Method to get the field input markup.
	 *
	 * @param   HelpdeskProHelperBootstrap  $bootstrapHelper
	 *
	 * @return  string  The field input markup.
	 *
	 */
	protected function getInput($bootstrapHelper = null)
	{
		// Add uk-textarea to input elements
		if ($bootstrapHelper && $bootstrapHelper->getBootstrapVersion() === 'uikit3')
		{
			$this->addClass('uk-textarea');
		}

		if ($bootstrapHelper && $bootstrapHelper->getFrameworkClass('form-control'))
		{
			$this->addClass('form-control');
		}

		$data = [
			'name'       => $this->name,
			'value'      => $this->value,
			'attributes' => $this->buildAttributes(),
			'row'        => $this->row,
		];

		return HelpdeskProHelperHtml::loadCommonLayout('fieldlayout/textarea.php', $data);
	}
}