<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use OSL\Utils\Html as HtmlUtils;

defined('_JEXEC') or die;

HTMLHelper::_('bootstrap.tooltip');
$document = Factory::getDocument();
$document->addStyleDeclaration(".hasTip{display:block !important}");

ToolbarHelper::title(Text::_('Configuration'), 'generic.png');
ToolbarHelper::apply('apply', 'JTOOLBAR_APPLY');
ToolbarHelper::save('save');
ToolbarHelper::cancel('cancel');

if (Factory::getUser()->authorise('core.admin', 'com_helpdeskpro'))
{
	ToolbarHelper::preferences('com_helpdeskpro');
}

$config = $this->config;

if (HelpdeskproHelper::isJoomla4())
{
	$tabApiPrefix = 'uitab.';
}
else
{
	$tabApiPrefix = 'bootstrap.';
}
?>
<form action="index.php?option=com_helpdeskpro&view=configuration" method="post" name="adminForm" id="adminForm" class="form-horizontal hdp-configuration">
    <?php
        echo HTMLHelper::_($tabApiPrefix . 'startTabSet', 'configuration', array('active' => 'general-page'));
        echo HTMLHelper::_($tabApiPrefix . 'addTab', 'configuration', 'general-page', Text::_('HDP_GENERAL', true));
    ?>
    <div class="span6">
        <fieldset class="form-horizontal">
            <legend><?php echo Text::_('HDP_GENERAL_SETTINGS'); ?></legend>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('download_id', Text::_('HDP_DOWNLOAD_ID'), Text::_('HDP_DOWNLOAD_ID_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <input type="text" name="download_id" class="input-xlarge form-control" value="<?php echo $config->download_id; ?>" size="60" />
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('allow_public_user_submit_ticket', Text::_('HDP_ALLOW_PUBLIC_USER_SUBMIT_TICKETS')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('allow_public_user_submit_ticket', $config->allow_public_user_submit_ticket); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('load_twttier_bootstrap_framework_in_frontend', Text::_('HDP_LOAD_TWITTER_BOOTSTRAP_FRAMEWORK'), Text::_('HDP_LOAD_TWITTER_BOOTSTRAP_FRAMEWORK_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('load_twttier_bootstrap_framework_in_frontend', $config->load_twttier_bootstrap_framework_in_frontend); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('twitter_bootstrap_version', Text::_('HDP_TWITTER_BOOTSTRAP_VERSION'), Text::_('HDP_TWITTER_BOOTSTRAP_VERSION_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['twitter_bootstrap_version'];?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('enable_captcha', Text::_('HDP_ENABLE_CAPTCHA')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['enable_captcha']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('use_html_editor', Text::_('HDP_USE_HTML_EDITOR'), Text::_('HDP_USE_HTML_EDITOR_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('use_html_editor', $config->use_html_editor); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('date_format', Text::_('HDP_DATE_FORMAT')); ?>
                </div>
                <div class="controls">
                    <input type="text" name="date_format" value="<?php echo $config->date_format; ?>"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('default_ticket_priority_id', Text::_('HDP_DEFAULT_TICKET_PRIORITY')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['default_ticket_priority_id']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('new_ticket_status_id', Text::_('HDP_NEW_TICKET_STATUS')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['new_ticket_status_id']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('ticket_status_when_customer_add_comment', Text::_('HDP_TICKET_STATUS_WHEN_CUSTOMER_ADD_COMMENT')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['ticket_status_when_customer_add_comment']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('ticket_status_when_admin_add_comment', Text::_('HDP_TICKET_STATUS_WHEN_ADMIN_ADD_COMMENT')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['ticket_status_when_admin_add_comment']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('closed_ticket_status', Text::_('HDP_CLOSED_TICKET_STATUS')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['closed_ticket_status']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
			        <?php echo HtmlUtils::getFieldLabel('manager_default_status_filters', Text::_('HDP_MANAGER_DEFAULT_STATUS_FILTERS'), Text::_('HDP_MANAGER_DEFAULT_STATUS_FILTERS_EXPLAIN')); ?>
                </div>
                <div class="controls">
			        <?php echo $this->lists['manager_default_status_filters']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('enable_attachment', Text::_('HDP_ENABLE_ATTACHMENT'), Text::_('HDP_ENABLE_ATTACHMENT_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('enable_attachment', $config->enable_attachment); ?>
                </div>
            </div>
	        <div class="control-group">
		        <div class="control-label">
			        <?php echo HtmlUtils::getFieldLabel('enable_rating', Text::_('HDP_ENABLE_RATING'), Text::_('HDP_ENABLE_RATING_EXPLAIN')); ?>
		        </div>
		        <div class="controls">
			        <?php echo HtmlUtils::getBooleanInput('enable_rating', $config->get('enable_rating', 1)); ?>
		        </div>
	        </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('allowed_file_types', Text::_('HDP_ALLOWED_FILE_TYPES')); ?>
                </div>
                <div class="controls">
                    <input type="text" class="form-control" name="allowed_file_types" size="30"
                           value="<?php echo $config->allowed_file_types; ?>"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('max_number_attachments', Text::_('HDP_MAX_NUMBER_ATTACHMENS_PER_MESSAGE')); ?>
                </div>
                <div class="controls">
                    <input type="text" class="input-small form-control" name="max_number_attachments" size="30"
                           value="<?php echo $config->max_number_attachments ? $config->max_number_attachments : 3; ?>"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('max_filesize_type', Text::_('HDP_MAX_UPLOAD_FILE_SIZE'), Text::_('HDP_MAX_UPLOAD_FILE_SIZE_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <input type="text" name="max_file_size" class="input-mini form-control d-inline" value="<?php echo $this->config->max_file_size; ?>" size="5" />
                    <?php echo $this->lists['max_filesize_type'] ; ?>&nbsp;&nbsp;&nbsp;<?php echo Text::_('HDP_DEFAULT_INI_SETTING'); ?>: <strong><?php echo ini_get('upload_max_filesize'); ?></strong>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('process_bb_code', Text::_('HDP_PROCESS_BBCODE')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('process_bb_code', $config->process_bb_code); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('highlight_code', Text::_('HDP_HIGHTLIGHT_CODE')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('highlight_code', $config->highlight_code); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('programming_languages', Text::_('HDP_PROGRAMING_LANGUAGES'), Text::_('HDP_PROGRAMING_LANGUAGES_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo $this->lists['programming_languages']; ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('staff_group_id', Text::_('HDP_STAFF_GROUP'), Text::_('HDP_STAFF_GROUP_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo HTMLHelper::_('access.usergroup', 'staff_group_id', $config->staff_group_id, 'class="form-select"'); ?>
                </div>
            </div>
	        <div class="control-group">
		        <div class="control-label">
			        <?php echo HtmlUtils::getFieldLabel('staff_group_id', Text::_('HDP_STAFF_DISPLAY_FIELD'), Text::_('HDP_STAFF_DISPLAY_FIELD_EXPLAIN')); ?>
		        </div>
		        <div class="controls">
			        <?php echo $this->lists['staff_display_field']; ?>
		        </div>
	        </div>
        </fieldset>
    </div>
    <div class="span6">
        <fieldset class="form-horizontal">
            <legend><?php echo Text::_('HDP_EMAIL_SETTINGS'); ?></legend>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('from_name', Text::_('HDP_FROM_NAME'), Text::_('HDP_FROM_NAME_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <input type="text" name="from_name" class="form-control" value="<?php echo $config->from_name; ?>"
                           size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('from_email', Text::_('HDP_FROM_EMAIL'), Text::_('HDP_FROM_EMAIL_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <input type="text" name="from_email" class="form-control"
                           value="<?php echo $config->from_email; ?>" size="50"/>
                </div>
            </div>
	        <div class="control-group">
		        <div class="control-label">
			        <?php echo HtmlUtils::getFieldLabel('from_email', Text::_('HDP_REPLY_TO_EMAIL'), Text::_('HDP_REPLY_TO_EMAIL_EXPLAIN')); ?>
		        </div>
		        <div class="controls">
			        <input type="text" name="reply_to_email" class="form-control"
			               value="<?php echo $config->reply_to_email; ?>" size="50"/>
		        </div>
	        </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('notification_emails', Text::_('HDP_NOTIFICATION_EMAILS'), Text::_('HDP_NOTIFICATION_EMAILS_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <input type="text" name="notification_emails" class="form-control"
                           value="<?php echo $config->notification_emails; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('notify_manager_when_staff_reply', Text::_('HDP_NOTIFY_MANAGER_WHEN_STAFF_REPLY'), Text::_('HDP_NOTIFY_MANAGER_WHEN_STAFF_REPLY_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('notify_manager_when_staff_reply', $config->notify_manager_when_staff_reply); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
			        <?php echo HtmlUtils::getFieldLabel('notify_other_managers_when_a_manager_reply', Text::_('HDP_NOTIFY_OTHER_MANAGERS_WHEN_A_MANAGER_REPLY'), Text::_('HDP_NOTIFY_OTHER_MANAGERS_WHEN_A_MANAGER_REPLY_EXPLAIN')); ?>
                </div>
                <div class="controls">
			        <?php echo HtmlUtils::getBooleanInput('notify_other_managers_when_a_manager_reply', $config->notify_other_managers_when_a_manager_reply); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('notify_staff_when_customer_reply', Text::_('HDP_NOTIFY_STAFF_WHEN_CUSTOMER_REPLY'), Text::_('HDP_NOTIFY_STAFF_WHEN_CUSTOMER_REPLY_EXPLAIN')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('notify_staff_when_customer_reply', $config->notify_staff_when_customer_reply); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo HtmlUtils::getFieldLabel('send_ticket_attachments_to_email', Text::_('HDP_SEND_ATTACHMENTS_TO_EMAIL')); ?>
                </div>
                <div class="controls">
                    <?php echo HtmlUtils::getBooleanInput('send_ticket_attachments_to_email', $config->send_ticket_attachments_to_email); ?>
                </div>
            </div>
        </fieldset>
    </div>

	<?php
	echo HTMLHelper::_($tabApiPrefix . 'endTab');

	echo HTMLHelper::_($tabApiPrefix . 'addTab', 'configuration', 'api-page', Text::_('HDP_API_SETTINGS', true));
	echo $this->loadTemplate('api');
	echo HTMLHelper::_($tabApiPrefix . 'endTab');

	if ($this->editor)
	{
		echo $this->loadTemplate('custom_css');
	}

	echo HTMLHelper::_($tabApiPrefix . 'endTabSet');
	?>
	<div class="clearfix"></div>
	<input type="hidden" name="task" value=""/>
</form>