<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Configuration;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use OSL\View\HtmlView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskproHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;

defined('_JEXEC') or die;

class Html extends HtmlView
{
	protected function beforeRender()
	{
		jimport('joomla.filesystem.folder');

		$config = HelpdeskproHelper::getConfig();

		$languages = [
			'Php',
			'JScript',
			'Css',
			'Xml',
			'Plain',
			'AS3',
			'Bash',
			'Cpp',
			'CSharp',
			'Delphi',
			'Diff',
			'Groovy',
			'Java',
			'JavaFX',
			'Perl',
			'PowerShell',
			'Python',
			'Ruby',
			'Scala',
			'Sql',
			'Vb',
		];

		$options = [];

		foreach ($languages as $language)
		{
			$options[] = HTMLHelper::_('select.option', $language, $language);
		}

		$lists['programming_languages'] = HTMLHelper::_('select.genericlist', $options, 'programming_languages[]', ' class="form-select" multiple="multiple" ', 'value', 'text', explode(',', $config->programming_languages));

		$statuses                      = HelpdeskproHelperDatabase::getAllStatuses();
		$options                       = [];
		$options[]                     = HTMLHelper::_('select.option', 0, Text::_('HDP_SELECT'), 'id', 'title');
		$options                       = array_merge($options, $statuses);
		$lists['new_ticket_status_id'] = HTMLHelper::_('select.genericlist', $options, 'new_ticket_status_id',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'title',
				'option.key'         => 'id',
				'list.attr'          => 'class="form-select"',
				'list.select'        => $config->new_ticket_status_id]);

		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_DONOT_CHANGE'), 'id', 'title');
		$options   = array_merge($options, $statuses);

		$lists['ticket_status_when_customer_add_comment'] = HTMLHelper::_('select.genericlist', $options, 'ticket_status_when_customer_add_comment',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'title',
				'option.key'         => 'id',
				'list.attr'          => 'class="form-select" ',
				'list.select'        => $config->ticket_status_when_customer_add_comment]);

		$lists['ticket_status_when_admin_add_comment'] = HTMLHelper::_('select.genericlist', $options, 'ticket_status_when_admin_add_comment',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'title',
				'option.key'         => 'id',
				'list.attr'          => 'class="form-select" ',
				'list.select'        => $config->ticket_status_when_admin_add_comment]);

		$lists['closed_ticket_status'] = HTMLHelper::_('select.genericlist', $options, 'closed_ticket_status',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'title',
				'option.key'         => 'id',
				'list.attr'          => 'class="form-select"',
				'list.select'        => $config->closed_ticket_status]);

		if ($config->manager_default_status_filters)
		{
			$statusFilters = explode(',', $config->manager_default_status_filters);
		}
		else
		{
			$statusFilters = [$config->new_ticket_status_id, $config->ticket_status_when_customer_add_comment];
		}

		$lists['manager_default_status_filters'] = HTMLHelper::_('select.genericlist', $statuses, 'manager_default_status_filters[]',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'title',
				'option.key'         => 'id',
				'list.attr'          => 'class="form-select" multiple',
				'list.select'        => $statusFilters]);


		$options                             = [];
		$options[]                           = HTMLHelper::_('select.option', 0, Text::_('HDP_SELECT'), 'id', 'title');
		$options                             = array_merge($options, HelpdeskproHelperDatabase::getAllPriorities());
		$lists['default_ticket_priority_id'] = HTMLHelper::_('select.genericlist', $options, 'default_ticket_priority_id',
			[
				'option.text.toHtml' => false,
				'option.text'        => 'title',
				'option.key'         => 'id',
				'list.attr'          => 'class="form-select"',
				'list.select'        => $config->default_ticket_priority_id]);

		$options                    = [];
		$options[]                  = HTMLHelper::_('select.option', 0, Text::_('Select'));
		$options[]                  = HTMLHelper::_('select.option', '1', Text::_('Byte'));
		$options[]                  = HTMLHelper::_('select.option', '2', Text::_('Kb'));
		$options[]                  = HTMLHelper::_('select.option', '3', Text::_('Mb'));
		$lists['max_filesize_type'] = HTMLHelper::_('select.genericlist', $options, 'max_filesize_type', 'class="input-small form-select d-inline"', 'value', 'text', $config->max_filesize_type ? $config->max_filesize_type : 3);

		$options = [];

		if (!HelpdeskproHelper::isJoomla4())
		{
			$options[] = HTMLHelper::_('select.option', 2, Text::_('HDP_VERSION_2'));
			$options[] = HTMLHelper::_('select.option', 3, Text::_('HDP_VERSION_3'));
		}

		$options[] = HTMLHelper::_('select.option', 4, Text::_('HDP_VERSION_4'));
		$options[] = HTMLHelper::_('select.option', 5, Text::_('HDP_VERSION_5'));
		$options[] = HTMLHelper::_('select.option', 'uikit3', Text::_('HDP_UIKIT_3'));

		// Get extra UI options
		$files = Folder::files(JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/libraries/ui', '.php');

		foreach ($files as $file)
		{
			if (in_array($file, ['abstract.php', 'bootstrap2.php', 'uikit3.php', 'bootstrap3.php', 'bootstrap4.php', 'bootstrap5.php', 'interface.php']))
			{
				continue;
			}

			$file      = str_replace('.php', '', $file);
			$options[] = HTMLHelper::_('select.option', $file, ucfirst($file));
		}

		$lists['twitter_bootstrap_version'] = HTMLHelper::_('select.genericlist', $options, 'twitter_bootstrap_version', 'class="form-select"', 'value', 'text', $config->get('twitter_bootstrap_version', 2));

		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('JNO'));
		$options[] = HTMLHelper::_('select.option', '1', Text::_('JYES'));
		$options[] = HTMLHelper::_('select.option', '2', Text::_('HDP_FOR_PUBLIC_USERS_ONLY'));

		$lists['enable_captcha'] = HTMLHelper::_('select.genericlist', $options, 'enable_captcha',
			[
				'option.text.toHtml' => false,
				'list.attr'          => 'class="form-select"',
				'list.select'        => $config->enable_captcha]);

		$options   = [];
		$options[] = HTMLHelper::_('select.option', '', Text::_('HDP_STAFF_DISPLAY_FIELD'));
		$options[] = HTMLHelper::_('select.option', 'username', Text::_('Username'));
		$options[] = HTMLHelper::_('select.option', 'email', Text::_('Email'));
		$options[] = HTMLHelper::_('select.option', 'name', Text::_('Name'));

		$lists['staff_display_field'] = HTMLHelper::_('select.genericlist', $options, 'staff_display_field',
			[
				'option.text.toHtml' => false,
				'list.attr'          => 'class="form-select"',
				'list.select'        => $config->get('staff_display_field', 'username')]);

		$editorPlugin = '';

		if (PluginHelper::isEnabled('editors', 'codemirror'))
		{
			$editorPlugin = 'codemirror';
		}
		elseif (PluginHelper::isEnabled('editor', 'none'))
		{
			$editorPlugin = 'none';
		}

		if ($editorPlugin)
		{
			$this->editor = Editor::getInstance($editorPlugin);
		}
		else
		{
			$this->editor = null;
		}

		$this->lists  = $lists;
		$this->config = $config;
	}
}