<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Category;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\View\ItemView;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;

// no direct access
defined('_JEXEC') or die;

class Html extends ItemView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		$db    = $this->container->db;
		$query = $db->getQuery(true)
			->select('*')
			->from('#__helpdeskpro_categories')
			->order('title');
		$db->setQuery($query);
		$rows = $db->loadObjectList();

		$this->lists['parent_id'] = HelpdeskproHelperHtml::buildCategoryDropdown($this->item->parent_id, 'parent_id', 'class="form-select"', $rows);

		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_BOTH'));
		$options[] = HTMLHelper::_('select.option', 1, Text::_('HDP_TICKETS'));
		$options[] = HTMLHelper::_('select.option', 2, Text::_('HDP_KNOWLEDGE_BASE'));

		$this->lists['category_type'] = HTMLHelper::_('select.genericlist', $options, 'category_type', 'class="form-select"', 'value', 'text', $this->item->category_type);
	}
}