<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */
namespace OSSolution\HelpdeskPro\Admin\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Table\Table;

/**
 * Message table class
 *
 * @property $id
 * @property $user_id
 * @property $ticket_id
 * @property $date_added
 * @property $attachments
 * @property @original_filenames
 */
class Message extends Table
{

	/**
	 * Constructor
	 *
	 * @param \JDatabaseDriver $db connector object
	 *
	 * @since 1.5
	 */
	public function __construct(& $db)
	{
		parent::__construct('#__helpdeskpro_messages', 'id', $db);
	}
}