<?php

define('_JEXEC', 1);

define('JPATH_BASE', dirname(dirname(dirname(dirname(__FILE__)))));
require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';
$app = JFactory::getApplication('site');

// print_r($app);
$filename = __DIR__ . '/log.txt';
$input = $app->input;
// JLoader::register('ReservationModelMessage', JPATH_ADMINISTRATOR . '/components/com_reservation/models/message.php');
// JLoader::register('ReservationModelAjax', JPATH_SITE . '/components/com_reservation/models/ajax.php');
// file_put_contents($filename, "input = " . print_r($input->getArray(), True) . "\n", FILE_APPEND);


$events = $input->get('event', array(), 'ARRAY');
// file_put_contents($filename, "events = " . print_r($events, True) . "\n", FILE_APPEND);
if(!empty($events))
{
  $event = json_decode($events[0])[0];
  // file_put_contents($filename, "event = " . print_r($event, True) . "\n", FILE_APPEND);
  $attributes = $event->data->attributes;
  $meeting = $attributes->meeting;
  // file_put_contents($filename, "attributes = " . print_r($attributes, True) . "\n", FILE_APPEND);
  // file_put_contents($filename, "event type = " . print_r($event->data->id, True) . "\n", FILE_APPEND);
  // file_put_contents($filename, "meeting = " . print_r($meeting, True) . "\n", FILE_APPEND);
  
  $db = JFactory::getDbo();
  $query = $db->getQuery(true);
  $query->select($db->quoteName(array('id', 'name', 'planid', 'seid', 'vpass', 'mpass', 'inmid', 'exmid')));
  $query->from($db->quoteName('#__reservation_bbbclass'));
  $query->where($db->quoteName('exmid') . ' = ' . $db->quote($meeting->{'external-meeting-id'}));
  $db->setQuery($query);
  $bbbclassrow = $db->loadAssoc();
  // file_put_contents($filename, "bbbclassrow = " . print_r($bbbclassrow, True) . "\n", FILE_APPEND);
  
  JLoader::register('ReservationTableBbbclass', JPATH_ADMINISTRATOR . '/components/com_reservation/tables/bbbclass.php');
  JLoader::register('ReservationModelBbbclass', JPATH_ADMINISTRATOR . '/components/com_reservation/models/bbbclass.php');
  switch($event->data->id)
  {
    case "meeting-created":
      // create bbbclass or if exist publish
      
      JLoader::register('ReservationModelBbbclass', JPATH_ADMINISTRATOR.'/components/com_reservation/models/bbbclass.php');
      //{'operation.name'}
      $bbbclass = array(
        "name"    => $meeting->name,
        "planid"  => $meeting->metadata->pid,
        "seid"    => $meeting->metadata->seid,
        "vpass"   => $meeting->{'viewer-pass'},
        "mpass"   => $meeting->{'moderator-pass'},
        "inmid"   => $meeting->{'internal-meeting-id'},
        "exmid"   => $meeting->{'external-meeting-id'},
      );
      if(!empty($bbbclassrow))
      {
        $db = JFactory::getDbo();
        $bbbclass_model = new ReservationTableBbbclass($db);
        $bbbclass['id'] = $bbbclassrow['id'];
        $pkc = array(
          'id' => $bbbclassrow['id']
        );
        $bbbclass_model->publish($pkc, 1);
      }
      
      $bbbclass_model = new ReservationModelBbbclass();
      $stat = $bbbclass_model->save($bbbclass);
      // file_put_contents($filename, "stat = " . print_r($stat, True) . "\n", FILE_APPEND);
      
    break;
    case "meeting-ended":
      // unpublish bbbclass
      if(!empty($bbbclassrow))
      {
        $db = JFactory::getDbo();
        $bbbclass_model = new ReservationTableBbbclass($db);
        $pkc = array(
          'id' => $bbbclassrow['id']
        );
        $bbbclass_model->publish($pkc, -1);
        // $bbbclass_model->delete($pkc);
      }
    break;
    case "user-joined":
      $user = $attributes->user;
      if($user->role == "MODERATOR" && !empty($bbbclassrow))
      {
        $cname = $bbbclassrow['exmid'];
        $e = explode('-', $cname);
        
        file_put_contents($filename, "d = " . print_r($d, True) . "\n", FILE_APPEND);
        
        
        $message = 'مشاور وارد جلسه ویدوئویی شد. برای ورود به جلسه بر روی این لینک کلیک کنید.';
        $fromValue = $e[0];
        $toValue = $e[1];
        $seidValue = $bbbclassrow['seid'];
        $pidValue = $bbbclassrow['planid'];
        $replyidValue = 0;
        $pmidValue = 0;
        
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
          ->select('finish ,channel_token')
          ->from($db->quoteName('#__reservation_session','se'))
          ->where($db->quoteName('se.id').'='.$seidValue);

        $db->setQuery($query);
        $result = $db->loadObject();
        JLoader::register('ReservationModelMessage', JPATH_ADMINISTRATOR . '/components/com_reservation/models/message.php');

        date_default_timezone_set('asia/tehran');
        $created= date('Y-m-d H:i:s');
        $created_by= $fromValue;
        
        
        require_once JPATH_ADMINISTRATOR . '/components/com_reservation/bbb/autoload.php';
        $app_params = JComponentHelper::getParams('com_reservation');
        $url = $app_params->get('serverurl', '');
        $secret = $app_params->get('serversecret', '');
        $bbb = new BigBlueButton\BigBlueButton($url, $secret);
        $auser = JFactory::getUser($toValue);
        $attendee_password = md5($auser->username);
        
        $joinMeetingParams = new BigBlueButton\Parameters\JoinMeetingParameters($bbbclassrow['exmid'], $auser->name, $attendee_password);
        $joinMeetingParams->setRedirect(true);
        $url = $bbb->getJoinMeetingURL($joinMeetingParams);
        $message .= " <a href='$url' target='_blank'>لینک</a>";
        
        $data = ['message' => $message, 'from' => $fromValue, 'to' => $toValue, 'channel_token' => $result->channel_token, 'reply' => $replyidValue];
        $data2 = ['message' => $message, 'from' => $fromValue, 'to' => $toValue,'created' => $created,'created_by' => $created_by,'seid' => $seidValue, 'seen' => 1, 'reply' => $replyidValue];

        $adminMessageModel= new ReservationModelMessage();
        $adminMessageModel->save($data2);
        $item = $adminMessageModel->getItem();
        $data['id'] = $item->id;
        \JPluginHelper::importPlugin('chat');
        $dispatcher = \JEventDispatcher::getInstance();
        $dispatcher->trigger('afterChatSave', array($data));
        
        
        // file_put_contents($filename, JPATH_ADMINISTRATOR . "/components/com_reservation/models/message.php\n", FILE_APPEND);
        // file_put_contents($filename, JPATH_SITE . "/components/com_reservation/models/ajax.php\n", FILE_APPEND);
        file_put_contents($filename, "event join = " . print_r($event, True) . "\n", FILE_APPEND);
      }
    break;
  }
  
}