<?php
/**
 * @package    Joomla.Component.Builder
 *
 * @created    30th April, 2015
 * @author     Llewellyn van der Merwe <http://www.joomlacomponentbuilder.com>
 * @github     Joomla Component Builder <https://github.com/vdm-io/Joomla-Component-Builder>
 * @copyright  Copyright (C) 2015 Vast Development Method. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Componentbuilder Ajax Controller
 */
class ComponentbuilderControllerAjax extends JControllerLegacy
{
	public function __construct($config)
	{
		parent::__construct($config);
		// make sure all json stuff are set
		JFactory::getDocument()->setMimeEncoding( 'application/json' );
		JResponse::setHeader('Content-Disposition','attachment;filename="getajax.json"');
		JResponse::setHeader("Access-Control-Allow-Origin", "*");
		// load the tasks 
		$this->registerTask('isNew', 'ajax');
		$this->registerTask('isRead', 'ajax');
		$this->registerTask('getComponentDetails', 'ajax');
		$this->registerTask('getCronPath', 'ajax');
		$this->registerTask('getJCBpackageInfo', 'ajax');
		$this->registerTask('getCrowdinDetails', 'ajax');
		$this->registerTask('getModuleCode', 'ajax');
		$this->registerTask('getClassCode', 'ajax');
		$this->registerTask('getClassCodeIds', 'ajax');
		$this->registerTask('getClassHeaderCode', 'ajax');
		$this->registerTask('tableColumns', 'ajax');
		$this->registerTask('fieldSelectOptions', 'ajax');
		$this->registerTask('getDynamicScripts', 'ajax');
		$this->registerTask('getButton', 'ajax');
		$this->registerTask('getButtonID', 'ajax');
		$this->registerTask('getAjaxDisplay', 'ajax');
		$this->registerTask('getLinked', 'ajax');
		$this->registerTask('checkAliasField', 'ajax');
		$this->registerTask('checkCategoryField', 'ajax');
		$this->registerTask('templateDetails', 'ajax');
		$this->registerTask('getLayoutDetails', 'ajax');
		$this->registerTask('dbTableColumns', 'ajax');
		$this->registerTask('viewTableColumns', 'ajax');
		$this->registerTask('getDynamicValues', 'ajax');
		$this->registerTask('checkFunctionName', 'ajax');
		$this->registerTask('usedin', 'ajax');
		$this->registerTask('getEditCustomCodeButtons', 'ajax');
		$this->registerTask('placedin', 'ajax');
		$this->registerTask('checkPlaceholderName', 'ajax');
		$this->registerTask('getExistingValidationRuleCode', 'ajax');
		$this->registerTask('getValidationRulesTable', 'ajax');
		$this->registerTask('checkRuleName', 'ajax');
		$this->registerTask('fieldTypeProperties', 'ajax');
		$this->registerTask('getFieldPropertyDesc', 'ajax');
		$this->registerTask('getCodeGlueOptions', 'ajax');
		$this->registerTask('snippetDetails', 'ajax');
		$this->registerTask('setSnippetGithub', 'ajax');
		$this->registerTask('getSnippets', 'ajax');
	}

	public function ajax()
	{
		$user 		= JFactory::getUser();
		$jinput 	= JFactory::getApplication()->input;
		// Check Token!
		$token 		= JSession::getFormToken();
		$call_token	= $jinput->get('token', 0, 'ALNUM');
		if($jinput->get($token, 0, 'ALNUM') || $token === $call_token)
		{
			$task = $this->getTask();
			switch($task)
			{
				case 'isNew':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$noticeValue = $jinput->get('notice', NULL, 'STRING');
						if($noticeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->isNew($noticeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'isRead':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$noticeValue = $jinput->get('notice', NULL, 'STRING');
						if($noticeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->isRead($noticeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getComponentDetails':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($idValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getComponentDetails($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getCronPath':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$getTypeValue = $jinput->get('getType', NULL, 'WORD');
						if($getTypeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getCronPath($getTypeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getJCBpackageInfo':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$urlValue = $jinput->get('url', NULL, 'STRING');
						if($urlValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getJCBpackageInfo($urlValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getCrowdinDetails':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$identifierValue = $jinput->get('identifier', NULL, 'CMD');
						$keyValue = $jinput->get('key', NULL, 'ALNUM');
						if($identifierValue && $user->id != 0 && $keyValue)
						{
							$result = $this->getModel('ajax')->getCrowdinDetails($identifierValue, $keyValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getModuleCode':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$dataValue = $jinput->get('data', NULL, 'STRING');
						if($dataValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getModuleCode($dataValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getClassCode':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						$typeValue = $jinput->get('type', NULL, 'WORD');
						if($idValue && $user->id != 0 && $typeValue)
						{
							$result = $this->getModel('ajax')->getClassCode($idValue, $typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getClassCodeIds':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						$typeValue = $jinput->get('type', NULL, 'WORD');
						if($idValue && $user->id != 0 && $typeValue)
						{
							$result = $this->getModel('ajax')->getClassCodeIds($idValue, $typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getClassHeaderCode':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						$typeValue = $jinput->get('type', NULL, 'WORD');
						if($idValue && $user->id != 0 && $typeValue)
						{
							$result = $this->getModel('ajax')->getClassHeaderCode($idValue, $typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'tableColumns':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$tableValue = $jinput->get('table', NULL, 'WORD');
						if($tableValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getTableColumns($tableValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'fieldSelectOptions':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($idValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getFieldSelectOptions($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getDynamicScripts':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$typeValue = $jinput->get('type', NULL, 'WORD');
						if($typeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getDynamicScripts($typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getButton':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$typeValue = $jinput->get('type', NULL, 'WORD');
						$sizeValue = $jinput->get('size', NULL, 'INT');
						if($typeValue && $user->id != 0 && $sizeValue)
						{
							$result = $this->getModel('ajax')->getButton($typeValue, $sizeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getButtonID':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$typeValue = $jinput->get('type', NULL, 'WORD');
						$sizeValue = $jinput->get('size', NULL, 'INT');
						if($typeValue && $user->id != 0 && $sizeValue)
						{
							$result = $this->getModel('ajax')->getButtonID($typeValue, $sizeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getAjaxDisplay':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$typeValue = $jinput->get('type', NULL, 'WORD');
						if($typeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getAjaxDisplay($typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getLinked':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$typeValue = $jinput->get('type', NULL, 'ALNUM');
						if($typeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getLinked($typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'checkAliasField':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$typeValue = $jinput->get('type', NULL, 'ALNUM');
						if($typeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->checkAliasField($typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'checkCategoryField':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$typeValue = $jinput->get('type', NULL, 'ALNUM');
						if($typeValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->checkCategoryField($typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'templateDetails':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', null, 'INT');
						if($idValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getTemplateDetails($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getLayoutDetails':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($idValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getLayoutDetails($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'dbTableColumns':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$nameValue = $jinput->get('name', NULL, 'WORD');
						$asValue = $jinput->get('as', NULL, 'WORD');
						$typeValue = $jinput->get('type', NULL, 'INT');
						if($nameValue && $user->id != 0 && $asValue && $typeValue)
						{
							$result = $this->getModel('ajax')->getDbTableColumns($nameValue, $asValue, $typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'viewTableColumns':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						$asValue = $jinput->get('as', NULL, 'WORD');
						$typeValue = $jinput->get('type', NULL, 'INT');
						if($idValue && $user->id != 0 && $asValue && $typeValue)
						{
							$result = $this->getModel('ajax')->getViewTableColumns($idValue, $asValue, $typeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getDynamicValues':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						$viewValue = $jinput->get('view', NULL, 'WORD');
						if($idValue && $user->id != 0 && $viewValue)
						{
							$result = $this->getModel('ajax')->getDynamicValues($idValue, $viewValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'checkFunctionName':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$functioNameValue = $jinput->get('functioName', NULL, 'STRING');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($functioNameValue && $user->id != 0 && $idValue)
						{
							$result = $this->getModel('ajax')->checkFunctionName($functioNameValue, $idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'usedin':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$functioNameValue = $jinput->get('functioName', NULL, 'WORD');
						$idValue = $jinput->get('id', NULL, 'INT');
						$targetValue = $jinput->get('target', NULL, 'WORD');
						if($functioNameValue && $user->id != 0 && $idValue && $targetValue)
						{
							$result = $this->getModel('ajax')->usedin($functioNameValue, $idValue, $targetValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getEditCustomCodeButtons':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($idValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getEditCustomCodeButtons($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'placedin':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$placeholderValue = $jinput->get('placeholder', NULL, 'WORD');
						$idValue = $jinput->get('id', NULL, 'INT');
						$targetValue = $jinput->get('target', NULL, 'WORD');
						if($placeholderValue && $user->id != 0 && $idValue && $targetValue)
						{
							$result = $this->getModel('ajax')->placedin($placeholderValue, $idValue, $targetValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'checkPlaceholderName':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						$placeholderNameValue = $jinput->get('placeholderName', NULL, 'STRING');
						if($idValue && $user->id != 0 && $placeholderNameValue)
						{
							$result = $this->getModel('ajax')->checkPlaceholderName($idValue, $placeholderNameValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getExistingValidationRuleCode':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$nameValue = $jinput->get('name', NULL, 'WORD');
						if($nameValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getExistingValidationRuleCode($nameValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getValidationRulesTable':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($idValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getValidationRulesTable($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'checkRuleName':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$nameValue = $jinput->get('name', NULL, 'STRING');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($nameValue && $user->id != 0 && $idValue)
						{
							$result = $this->getModel('ajax')->checkRuleName($nameValue, $idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'fieldTypeProperties':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($idValue)
						{
							$result = $this->getModel('ajax')->getFieldTypeProperties($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getFieldPropertyDesc':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$propertyValue = $jinput->get('property', NULL, 'WORD');
						$fieldtypeValue = $jinput->get('fieldtype', NULL, 'ALNUM');
						if($propertyValue && $user->id != 0 && $fieldtypeValue)
						{
							$result = $this->getModel('ajax')->getFieldPropertyDesc($propertyValue, $fieldtypeValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getCodeGlueOptions':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$listfieldValue = $jinput->get('listfield', NULL, 'INT');
						$joinfieldsValue = $jinput->get('joinfields', NULL, 'STRING');
						$typeValue = $jinput->get('type', NULL, 'INT');
						$areaValue = $jinput->get('area', NULL, 'INT');
						if($listfieldValue && $user->id != 0 && $joinfieldsValue && $typeValue && $areaValue)
						{
							$result = $this->getModel('ajax')->getCodeGlueOptions($listfieldValue, $joinfieldsValue, $typeValue, $areaValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'snippetDetails':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$idValue = $jinput->get('id', NULL, 'INT');
						if($idValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getSnippetDetails($idValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'setSnippetGithub':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$pathValue = $jinput->get('path', NULL, 'STRING');
						$statusValue = $jinput->get('status', NULL, 'WORD');
						if($pathValue && $user->id != 0 && $statusValue)
						{
							$result = $this->getModel('ajax')->setSnippetGithub($pathValue, $statusValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
				case 'getSnippets':
					try
					{
						$returnRaw = $jinput->get('raw', false, 'BOOLEAN');
						$librariesValue = $jinput->get('libraries', NULL, 'STRING');
						if($librariesValue && $user->id != 0)
						{
							$result = $this->getModel('ajax')->getSnippets($librariesValue);
						}
						else
						{
							$result = false;
						}
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback . "(".json_encode($result).");";
						}
						elseif($returnRaw)
						{
							echo json_encode($result);
						}
						else
						{
							echo "(".json_encode($result).");";
						}
					}
					catch(Exception $e)
					{
						if($callback = $jinput->get('callback', null, 'CMD'))
						{
							echo $callback."(".json_encode($e).");";
						}
						else
						{
							echo "(".json_encode($e).");";
						}
					}
				break;
			}
		}
		else
		{
			if($callback = $jinput->get('callback', null, 'CMD'))
			{
				echo $callback."(".json_encode(false).");";
			}
			else
			{
				echo "(".json_encode(false).");";
			}
		}
	}
}
