<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJiveForums\Trigger;

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\Table\CategoryTable;
use CB\Plugin\GroupJiveForums\CBGroupJiveForums;

defined('CBLIB') or die();

class ForumsTrigger extends \cbPluginHandler
{

	/**
	 * render frontend forum group edit params
	 *
	 * @param string        $return
	 * @param GroupTable    $row
	 * @param array         $input
	 * @param CategoryTable $category
	 * @param UserTable     $user
	 * @return string
	 */
	public function editGroup( &$return, &$row, &$input, $category, $user )
	{
		if ( ! CBGroupJiveForums::getForum() ) {
			return null;
		}

		CBGroupJive::getTemplate( 'group_edit', true, true, $this->element );

		$enableTooltip		=	cbTooltip( null, CBTxt::T( 'Optionally enable or disable usage of forums.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['forums']	=	\moscomprofilerHTML::yesnoButtonList( 'params[forums]', $enableTooltip, $this->getInput()->getInt( 'post/params.forums', $row->params()->getInt( 'forums', 1 ) ), CBTxt::T( 'Enable' ), CBTxt::T( 'Disable' ), null, false );

		return \HTML_groupjiveForumsParams::showForumsParams( $row, $input, $category, $user, $this );
	}

	/**
	 * store the forum category for the group or category that was deleted
	 *
	 * @param GroupTable|CategoryTable $row
	 */
	public function storeForum( $row )
	{
		if ( ( ! CBGroupJiveForums::getForum() ) || $row->getBool( '_skipForums', false ) ) {
			return;
		}

		$parent					=	$this->params->getInt( 'groups_forums_category', 0 );

		if ( ! $parent ) {
			return;
		}

		if ( ( $row instanceof GroupTable ) && $row->category()->getInt( 'id', 0 ) ) {
			$parentCategory		=	CBGroupJiveForums::getForum()->getCategory( $row->category()->params()->getInt( 'forum_id', 0 ) );

			if ( ! $parentCategory->getInt( 'id', 0 ) ) {
				$parentCategory->set( 'parent', $parent );
				$parentCategory->set( 'name', $row->category()->getString( 'name' ) );
				$parentCategory->set( 'alias', $row->category()->getInt( 'id', 0 ) . '-' . $row->category()->getString( 'name' ) );
				$parentCategory->set( 'description', $row->category()->getString( 'description' ) );
				$parentCategory->set( 'published', ( ! $row->category()->params()->getBool( 'forums', true ) ? 0 : $row->category()->getInt( 'published', 0 ) ) );

				$parentCategory->access( $row->category() );

				if ( ! $parentCategory->check() ) {
					return;
				}

				if ( ! $parentCategory->store() ) {
					return;
				}

				$row->category()->set( '_skipForums', true );

				$row->category()->params()->set( 'forum_id', $parentCategory->getInt( 'id', 0 ) );

				$row->category()->set( 'params', $row->category()->params()->asJson() );

				$row->category()->store();

				$row->category()->set( '_skipForums', false );
			}

			$parent				=	$parentCategory->getInt( 'id', 0 );
		}

		$category				=	CBGroupJiveForums::getForum()->getCategory( $row->params()->getInt( 'forum_id', 0 ) );

		$new					=	( ! $category->getInt( 'id', 0 ) );

		$category->set( 'parent', $parent );
		$category->set( 'name', $row->getString( 'name' ) );
		$category->set( 'alias', $row->getInt( 'id', 0 ) . '-' . $row->getString( 'name' ) );
		$category->set( 'description', $row->getString( 'description' ) );
		$category->set( 'published', ( ! $row->params()->getBool( 'forums', false ) ? 0 : $row->getInt( 'published', 0 ) ) );

		$category->access( $row );

		if ( ! $category->check() ) {
			return;
		}

		if ( ! $category->store() ) {
			return;
		}

		if ( ( $row instanceof GroupTable ) && ( ! CBGroupJive::isModerator( $row->getInt( 'user_id', 0 ) ) ) ) {
			$moderators			=	cbToArrayOfInt( $category->moderators() );

			if ( ! in_array( $row->getInt( 'user_id', 0 ), $moderators, true ) ) {
				$category->moderators( $row->getInt( 'user_id', 0 ) );
			}
		}

		if ( $new ) {
			$row->set( '_skipForums', true );

			$row->params()->set( 'forum_id', $category->getInt( 'id', 0 ) );

			$row->set( 'params', $row->params()->asJson() );

			$row->store();

			$row->set( '_skipForums', false );
		}
	}

	/**
	 * delete the forum category for the group or category that was deleted
	 *
	 * @param GroupTable|CategoryTable $row
	 */
	public function deleteForum( $row )
	{
		if ( ! CBGroupJiveForums::getForum() ) {
			return;
		}

		$category		=	CBGroupJiveForums::getForum()->getCategory( $row->params()->getInt( 'forum_id', 0 ) );

		if ( ! $category->getInt( 'id', 0 ) ) {
			return;
		}

		$category->delete();
	}

	/**
	 * add or remove forum category moderators
	 *
	 * @param \CB\Plugin\GroupJive\Table\UserTable $row
	 */
	public function storeModerator( $row )
	{
		if ( ( ! CBGroupJiveForums::getForum() ) || CBGroupJive::isModerator( $row->getInt( 'user_id', 0 ) ) ) {
			return;
		}

		$category		=	CBGroupJiveForums::getForum()->getCategory( $row->group()->params()->getInt( 'forum_id', 0 ) );

		if ( ! $category->getInt( 'id', 0 ) ) {
			return;
		}

		$moderators		=	cbToArrayOfInt( $category->moderators() );

		if ( $row->getInt( 'status', 0 ) >= 2 ) {
			if ( ! in_array( $row->getInt( 'user_id', 0 ), $moderators, true ) ) {
				$category->moderators( $row->getInt( 'user_id', 0 ) );
			}
		} elseif ( in_array( $row->getInt( 'user_id', 0 ), $moderators, true ) ) {
			$category->moderators( null, $row->getInt( 'user_id', 0 ) );
		}
	}

	/**
	 * remove forum category moderators
	 *
	 * @param \CB\Plugin\GroupJive\Table\UserTable $row
	 */
	public function deleteModerator( $row )
	{
		if ( ( ! CBGroupJiveForums::getForum() ) || CBGroupJive::isModerator( $row->getInt( 'user_id', 0 ) ) ) {
			return;
		}

		$category		=	CBGroupJiveForums::getForum()->getCategory( $row->group()->params()->getInt( 'forum_id', 0 ) );

		if ( ! $category->getInt( 'id', 0 ) ) {
			return;
		}

		$moderators		=	cbToArrayOfInt( $category->moderators() );

		if ( in_array( $row->getInt( 'user_id', 0 ), $moderators, true ) ) {
			$category->moderators( null, $row->getInt( 'user_id', 0 ) );
		}
	}

	/**
	 * prepare frontend forum render
	 *
	 * @param string     $return
	 * @param GroupTable $group
	 * @param string     $users
	 * @param string     $invites
	 * @param array      $counters
	 * @param array      $buttons
	 * @param array      $menu
	 * @param \cbTabs    $tabs
	 * @param UserTable  $user
	 * @return array|null
	 */
	public function showForums( &$return, &$group, &$users, &$invites, &$counters, &$buttons, &$menu, &$tabs, $user )
	{
		if ( ! CBGroupJiveForums::getForum() ) {
			return null;
		}

		return CBGroupJiveForums::getForum()->getTopics( $user, $group, $counters );
	}
}