<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJiveForums;

use CB\Plugin\GroupJiveForums\Forum\ForumInterface;
use CBLib\Registry\Registry;
use Kunena\Forum\Libraries\Forum\KunenaForum as Kunena6Forum;

defined('CBLIB') or die();

class CBGroupJiveForums
{

	/**
	 * @return Registry
	 */
	public static function getGlobalParams()
	{
		global $_PLUGINS;

		static $params	=	null;

		if ( $params === null ) {
			$plugin		=	$_PLUGINS->getLoadedPlugin( 'user/plug_cbgroupjive/plugins', 'cbgroupjiveforums' );
			$params		=	new Registry();

			if ( $plugin ) {
				$params->load( $plugin->params );
			}
		}

		/** @var Registry $params */
		return $params;
	}

	/**
	 * Returns the forum instance
	 *
	 * @return null|ForumInterface
	 */
	public static function getForum()
	{
		global $_CB_framework;

		static $forum				=	null;

		if ( $forum === null && ( self::getGlobalParams()->getString( 'groups_forums_model', 'kunena' ) === 'kunena' ) ) {
			$api					=	$_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_kunena/api.php';

			if ( file_exists( $api ) ) {
				require_once( $api );

				if ( class_exists( 'KunenaForum' ) && \KunenaForum::installed() ) {
					\KunenaForum::setup();

					$version		=	0;

					if ( method_exists( 'KunenaForum', 'version' ) ) {
						$version	=	(int) substr( (string) \KunenaForum::version(), 0, 1 );
					}

					$forum			=	new Forum\Kunena\KunenaForum( $version );
				}
			} elseif ( class_exists( '\Kunena\Forum\Libraries\Forum\KunenaForum' ) ) {
				if ( Kunena6Forum::isCompatible( '6.0' ) && Kunena6Forum::enabled() ) {
					$version		=	(int) substr( (string) Kunena6Forum::version(), 0, 1 );
					$forum			=	new Forum\Kunena\KunenaForum( $version );
				}
			}
		}

		return $forum;
	}

	/**
	 * Checks if there's too many categories for dropdown usage
	 * 
	 * @return bool
	 */
	public static function checkTooManyCategories()
	{
		$forum	=	self::getForum();

		if ( ! $forum ) {
			return false;
		}

		return ( $forum->getCategoriesCount() > 100 );
	}

	/**
	 * Returns select options list of forum categories
	 *
	 * @return array
	 */
	public static function getCategoryOptions()
	{
		$forum	=	self::getForum();

		if ( ! $forum ) {
			return array();
		}

		return $forum->getCategories();
	}
}