<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CB\Database\Table\PluginTable;
use CBLib\Registry\Registry;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/GroupJiveAbout/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbgroupjiveabout_install()
{
	// Grab GJ params to migrate the legacy params:
	$plugin				=	new PluginTable();

	$plugin->load( array( 'element' => 'cbgroupjive' ) );

	$pluginParams		=	new Registry( $plugin->getRaw( 'params', array() ) );

	if ( ( ! $pluginParams->has( 'about_content' ) ) || ( $pluginParams->getHtml( 'about_content' ) === null ) ) {
		return;
	}

	// Migrate about integration parameters:
	$about				=	new PluginTable();

	$about->load( array( 'element' => 'cbgroupjiveabout' ) );

	$aboutParams		=	new Registry( $about->getRaw( 'params', array() ) );

	if ( $aboutParams->getBool( 'migrated', false ) ) {
		return;
	}

	$aboutParams->set( 'groups_about_content_plugins', $pluginParams->getHtml( 'about_content' ) );
	$aboutParams->set( 'migrated', true );

	$about->set( 'params', $aboutParams->asJson() );

	$about->store();
}